/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.org;

import com.kingdee.bos.bi.model.common.mm.appmodel.FinanceCellObject;
import com.kingdee.bos.bi.model.common.mm.appmodel.FinanceDRDetailXmlModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.security.SecurityObject;
import com.kingdee.bos.bi.model.security.SelSecurityObjects;
import com.kingdee.bos.bi.model.ui.dialog.org.OrgType;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OrgImportDialog
extends TypicalDialog
implements KDPromptSelector {
    private static final long serialVersionUID = 1L;
    private OrgImportUI _ui;

    public OrgImportDialog() {
    }

    public OrgImportDialog(Dialog dlg) {
        super(dlg);
    }

    public OrgImportDialog(Frame frm) {
        super(frm);
    }

    protected void todoInit() {
        this._ui = new OrgImportUI();
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this._ui.getCtrl(), thisCell);
    }

    public void setSupply(OrgDimensionNode moRoot) {
        this._ui.setSupply(moRoot);
    }

    public OrgDimensionNode[] getSelected() {
        return this._ui.getSelected();
    }

    public void setCurrent(SelSecurityObjects sos) {
        this._ui.setCurrent(sos);
    }

    public void setOnlyShowControlUnitOrg() {
        this._ui.setOnlyShowControlUnitOrg();
    }

    public Object getData() {
        Object[] orgDimensionNode = this.getSelected();
        if (orgDimensionNode.length > 0) {
            return new FinanceCellObject(FinanceDRDetailXmlModel.toDimList(orgDimensionNode));
        }
        return null;
    }

    public DefaultKingdeeTreeNode getTreeRoot() {
        return this._ui.getTreeRoot();
    }

    public boolean isCanceled() {
        return false;
    }

    public void show() {
        super.showDialog();
    }

    private static class OrgImportUI {
        private KDPanel _panAll;
        private KDTree _tree;
        private KDWorkButton _btnSyncSibling;
        private KDWorkButton _btnSyncSon;
        private KDWorkButton _btnSyncDescenance;
        private KDComboBox _cmbOrgType;
        private KDCheckBox _chkShowVirtualOrg;
        private KDCheckBox _chkContainsSealUpOrg;
        private OrgDimensionNode _supplyOrgs;
        private boolean isF7 = false;

        public OrgImportUI() {
            this.init();
        }

        public void setCurrent(SelSecurityObjects sos) {
            if (sos != null) {
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
                List lstSO = sos.getSecurityObjectList();
                this.setSelectedNode(root, lstSO);
            }
        }

        private boolean matchSOById(List lstSO, String id) {
            for (SecurityObject so : lstSO) {
                if (!so.getId().equals(id)) continue;
                return true;
            }
            return false;
        }

        private void setSelectedNode(DefaultKingdeeTreeNode parent, List lstSO) {
            if (this.matchSOById(lstSO, ((OrgModel)((Object)parent.getUserObject())).getId())) {
                parent.setChecked(true);
            }
            int len = parent.getChildCount();
            for (int i = 0; i < len; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                if (!node.isLeaf()) {
                    this.setSelectedNode(node, lstSO);
                    continue;
                }
                if (!this.matchSOById(lstSO, ((OrgModel)((Object)parent.getUserObject())).getId())) continue;
                node.setChecked(true);
            }
        }

        private void init() {
            this.initTree();
            KDTreeView tv = new KDTreeView(this._tree);
            tv.setTitle("\u7cfb\u7edf\u7ec4\u7ec7\u67b6\u6784");
            this._btnSyncSibling = new KDWorkButton("\u540c\u7ea7");
            this._btnSyncSon = new KDWorkButton("\u5b50\u4ee3");
            this._btnSyncDescenance = new KDWorkButton("\u540e\u4ee3");
            SyncCheckActionHandler handler = new SyncCheckActionHandler();
            this._btnSyncSibling.addActionListener((ActionListener)handler);
            this._btnSyncSon.addActionListener((ActionListener)handler);
            this._btnSyncDescenance.addActionListener((ActionListener)handler);
            this._cmbOrgType = new KDComboBox((Object[])OrgType.getAll());
            KDLabelContainer lbcOrgType = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbOrgType, (String)"\u7ec4\u7ec7\u7c7b\u578b", (int)80);
            this._chkShowVirtualOrg = new KDCheckBox("\u663e\u793a\u865a\u62df\u56e2\u961f");
            this._chkContainsSealUpOrg = new KDCheckBox("\u663e\u793a\u5c01\u5b58\u7ec4\u7ec7");
            FilterActionHandler filterActionHandler = new FilterActionHandler();
            this._cmbOrgType.addActionListener((ActionListener)filterActionHandler);
            this._chkShowVirtualOrg.addActionListener((ActionListener)filterActionHandler);
            this._chkContainsSealUpOrg.addActionListener((ActionListener)filterActionHandler);
            TableLayout2 layout = new TableLayout2(3, 5);
            layout.setColsSpacing(TableLayout2.ALL, 3);
            layout.setColSpacing(0, 20);
            layout.setRatableWidth(0, 100);
            layout.setFixedWidth(1, 100);
            layout.setFixedWidth(new int[]{2, 3, 4}, 40);
            layout.setRowsSpacing(TableLayout2.ALL, 6);
            layout.setFixedHeight(0, 20);
            layout.setRatableHeight(1, 100);
            layout.setFixedHeight(2, 20);
            this._panAll = new KDPanel((LayoutManager)layout);
            this._panAll.add((Component)lbcOrgType, (Object)TableLayout2.param((int)0, (int)0));
            this._panAll.add((Component)this._chkShowVirtualOrg, (Object)TableLayout2.param((int)0, (int)1));
            this._panAll.add((Component)this._chkContainsSealUpOrg, (Object)TableLayout2.param((int)0, (int)2, (int)0, (int)4));
            this._panAll.add((Component)tv, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)4));
            this._panAll.add((Component)new KDLabel("\u540c\u6b65\u52fe\u9009\u72b6\u6001\uff1a"), (Object)TableLayout2.param((int)2, (int)1));
            this._panAll.add((Component)this._btnSyncSibling, (Object)TableLayout2.param((int)2, (int)2));
            this._panAll.add((Component)this._btnSyncSon, (Object)TableLayout2.param((int)2, (int)3));
            this._panAll.add((Component)this._btnSyncDescenance, (Object)TableLayout2.param((int)2, (int)4));
        }

        private void initTree() {
            this._tree = new KDTree();
            this._tree.getSelectionModel().setSelectionMode(1);
            this._tree.setShowCheckBox(true);
            this._tree.setShowsRootHandles(true);
        }

        public KDPanel getCtrl() {
            return this._panAll;
        }

        public void setSupply(OrgDimensionNode moRoot) {
            this._supplyOrgs = moRoot;
            this.updateTreeCtrl();
        }

        private void updateTreeCtrl() {
            OrgModel model = this._supplyOrgs.getOrgModel();
            DefaultKingdeeTreeNode ctrlRoot = new DefaultKingdeeTreeNode();
            ctrlRoot.setText(model.getName());
            ctrlRoot.setUserObject((Object)model);
            this.createTreeCtrlNode(this._supplyOrgs, ctrlRoot);
            KingdeeTreeModel ctrlTreeModel = new KingdeeTreeModel((TreeNode)ctrlRoot);
            this._tree.setModel((TreeModel)ctrlTreeModel);
        }

        private void createTreeCtrlNode(OrgDimensionNode moParent, DefaultKingdeeTreeNode ctrlParent) {
            for (int i = 0; i < moParent.getChildCount(); ++i) {
                DefaultKingdeeTreeNode nextCtrlParent;
                OrgDimensionNode moNode = moParent.getChild(i);
                OrgModel model = moNode.getOrgModel();
                boolean isThisNodeShow = true;
                OrgType orgType = (OrgType)this._cmbOrgType.getSelectedItem();
                if (orgType != OrgType.NONE && !"true".equals(model.getExtProps(orgType))) {
                    isThisNodeShow = false;
                }
                if (isThisNodeShow && !this._chkContainsSealUpOrg.isSelected() && "true".equals(model.getExtProps("isOUSealUp"))) {
                    isThisNodeShow = false;
                }
                if (isThisNodeShow && !this._chkShowVirtualOrg.isSelected() && "true".equals(model.getExtProps("partAdmin.isVirtual"))) {
                    isThisNodeShow = false;
                }
                if (isThisNodeShow) {
                    DefaultKingdeeTreeNode ctrlNode = new DefaultKingdeeTreeNode();
                    ctrlNode.setText(model.getName());
                    ctrlNode.setUserObject((Object)model);
                    ctrlParent.add((MutableTreeNode)ctrlNode);
                    nextCtrlParent = ctrlNode;
                } else {
                    nextCtrlParent = ctrlParent;
                }
                this.createTreeCtrlNode(moNode, nextCtrlParent);
            }
        }

        public OrgDimensionNode[] getSelected() {
            ArrayList<OrgDimensionNode> result = new ArrayList<OrgDimensionNode>();
            DefaultKingdeeTreeNode ctrlRoot = (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
            Enumeration e = ctrlRoot.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultKingdeeTreeNode ctrlNode = (DefaultKingdeeTreeNode)e.nextElement();
                if (ctrlNode.getUserObject() == null || !ctrlNode.isChecked()) continue;
                result.add(this.getSelectedSubTree(ctrlNode));
            }
            return result.toArray(new OrgDimensionNode[0]);
        }

        private OrgDimensionNode getSelectedSubTree(DefaultKingdeeTreeNode ctrlNode) {
            if (!ctrlNode.isChecked()) {
                return null;
            }
            OrgModel model = (OrgModel)((Object)ctrlNode.getUserObject());
            if (!this.isF7) {
                ctrlNode.setUserObject(null);
            }
            OrgDimensionNode moNode = new OrgDimensionNode();
            moNode.setOrgModel(model);
            for (int i = 0; i < ctrlNode.getChildCount(); ++i) {
                OrgDimensionNode moChild = this.getSelectedSubTree((DefaultKingdeeTreeNode)ctrlNode.getChildAt(i));
                if (moChild == null) continue;
                moNode.addChild(moChild);
            }
            return moNode;
        }

        public void setOnlyShowControlUnitOrg() {
            this.isF7 = true;
            this._cmbOrgType.setSelectedItem((Object)OrgType.ControlUnit);
            this._cmbOrgType.setEnabled(false);
        }

        public DefaultKingdeeTreeNode getTreeRoot() {
            return (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
        }

        private class FilterActionHandler
        implements ActionListener {
            private FilterActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OrgImportUI.this.updateTreeCtrl();
            }
        }

        private class SyncCheckActionHandler
        implements ActionListener {
            private SyncCheckActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = OrgImportUI.this._tree.getSelectionPath();
                if (path == null) {
                    WindowUtil.msgboxWarning((Object)"\u8bf7\u9009\u4e2d\u76ee\u6807\u8282\u70b9\u3002", (String)"\u5bfc\u5165", (Component)OrgImportUI.this._panAll);
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                boolean isChecked = node.isChecked();
                if (e.getSource() == OrgImportUI.this._btnSyncSibling) {
                    DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
                    if (parent == null) {
                        return;
                    }
                    this.syncSon(parent, isChecked, false);
                } else if (e.getSource() == OrgImportUI.this._btnSyncSon) {
                    this.syncSon(node, isChecked, false);
                } else if (e.getSource() == OrgImportUI.this._btnSyncDescenance) {
                    this.syncSon(node, isChecked, true);
                }
                OrgImportUI.this._tree.repaint();
            }

            private void syncSon(DefaultKingdeeTreeNode node, boolean isChecked, boolean toDeepLevel) {
                int c = node.getChildCount();
                for (int i = 0; i < c; ++i) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
                    child.setChecked(isChecked);
                    if (!toDeepLevel) continue;
                    this.syncSon(child, isChecked, toDeepLevel);
                }
            }
        }
    }
}

