/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.app.schema;

import com.kingdee.eas.util.ResourceBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class SchemaManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.app.schema.SchemaManager");
    private StringBuffer s = null;
    private Map varMap = null;
    private String resName = null;
    private Locale locale;

    public SchemaManager(Map macroMap, Locale locale) {
        this.varMap = macroMap;
        this.locale = locale;
    }

    private String getRes(String key) {
        String v = ResourceBase.getString((String)this.resName, (String)key, (Locale)this.locale);
        if (v == null) {
            return "[Missing res '" + this.resName + "#" + key + "']";
        }
        return v;
    }

    private String getVar(String key) {
        String v = (String)this.varMap.get(key);
        if (v == null) {
            return "[Missing var '" + key + "']";
        }
        return v;
    }

    private String getNLSValue(String value) {
        boolean isProperty = true;
        int i = value.indexOf("#{");
        if (i == -1) {
            isProperty = false;
            i = value.indexOf("${");
        }
        if (i == -1) {
            return value;
        }
        char[] chs = value.toCharArray();
        int end = -1;
        boolean hasEndTag = false;
        int n = chs.length;
        for (int j = i; j < n; ++j) {
            if (chs[j] != '}') continue;
            end = j;
            if (j + 1 >= n || (!isProperty || chs[j + 1] != '#') && (isProperty || chs[j + 1] != '$')) break;
            hasEndTag = true;
            break;
        }
        if (end != -1) {
            String key = value.substring(i + 2, end);
            String v = null;
            v = isProperty ? this.getRes(key) : this.getVar(key);
            return value.substring(0, i) + v + value.substring(end + 1 + (hasEndTag ? 1 : 0));
        }
        return value;
    }

    private boolean transVar(Element e) throws Exception {
        List list;
        int n;
        if ("Var".equals(e.getName())) {
            this.s.append("\n" + this.getVar(e.getAttributeValue("name")));
            e.getParent().removeContent((Content)e);
            return true;
        }
        this.s.append("\n<" + e.getName());
        List attr = e.getAttributes();
        if (attr.size() > 0) {
            int n2 = attr.size();
            for (int i = 0; i < n2; ++i) {
                Attribute at = (Attribute)attr.get(i);
                this.s.append(" ").append(at.getName()).append("=\"").append(this.getNLSValue(at.getValue())).append("\"");
            }
        }
        if ((n = (list = e.getChildren()).size()) > 0) {
            this.s.append(">");
            for (int i = 0; i < list.size(); ++i) {
                Element sube = (Element)list.get(i);
                if (!this.transVar(sube)) continue;
                --i;
            }
            this.s.append("\n</" + e.getName() + ">");
        } else {
            this.s.append("/>");
        }
        return false;
    }

    public InputStream transSchema(InputStream is, String chartset) throws Exception {
        this.s = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Element root = SchemaManager.parseXML(is, chartset);
        Element res = root.getChild("Resource");
        if (res != null) {
            this.resName = res.getAttributeValue("name").trim();
            root.removeContent((Content)res);
        }
        this.transVar(root);
        return new ByteArrayInputStream(this.s.toString().getBytes("UTF-8"));
    }

    public static Element parseXML(InputStream is, String chartset) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(is);
        }
        catch (JDOMException je) {
            logger.fatal((Object)"JDOM Parser ERROR!");
            throw je;
        }
        return doc.getRootElement();
    }
}

