/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.util;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.framework.bireport.util.KDCloseableTabbedPane;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiLayoutPane
extends KDPanel {
    public static final int STYLE_PAGE = 0;
    public static final int STYLE_TILE = 1;
    private KDCloseableTabbedPane.CloseHandler closeHandler = null;
    private List compList = new ArrayList();
    private List titleList = new ArrayList();
    KDSplitPane root = null;
    KDPanel toolBar = new KDPanel();
    KDPanel contentPane = new KDPanel();
    KDRadioButton stylePage = new KDRadioButton(EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.TabLayout"));
    KDRadioButton styleTile = new KDRadioButton(EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.TileLayout"));
    KDWorkButton showFrame = new KDWorkButton(EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.NewWindow"));
    boolean isShowAtNewFrame = false;
    private int currentStyle = 0;
    PercentManager pm = new PercentManager();
    private String frameTitle = EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.Chart");
    private int lastPageIndex = 0;
    private int lastPageCount = -1;
    JFrame nestFrame = null;

    public MultiLayoutPane(KDCloseableTabbedPane.CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
        this.init();
    }

    private void init() {
        this.setLayout(new CardLayout());
        this.add((Component)this.contentPane, "");
        this.contentPane.setLayout((LayoutManager)new BorderLayout());
        this.contentPane.add((Component)this.toolBar, (Object)"North");
        this.toolBar.setLayout((LayoutManager)new FlowLayout(0, 5, 5));
        this.toolBar.add((Component)this.stylePage);
        this.toolBar.add((Component)this.styleTile);
        this.toolBar.add((Component)this.showFrame);
        this.stylePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiLayoutPane.this.reLayout(0, MultiLayoutPane.this.isShowAtNewFrame);
            }
        });
        this.styleTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiLayoutPane.this.reLayout(1, MultiLayoutPane.this.isShowAtNewFrame);
            }
        });
        this.showFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiLayoutPane.this.reLayout(MultiLayoutPane.this.currentStyle, !MultiLayoutPane.this.isShowAtNewFrame);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.stylePage);
        bg.add((AbstractButton)this.styleTile);
    }

    public void reLayout() {
        this.reLayout(this.currentStyle, this.isShowAtNewFrame);
    }

    public void reLayout(int style) {
        this.reLayout(style, this.isShowAtNewFrame);
    }

    public void reDefaultLayout() {
        this.reLayout(0, false);
    }

    private void center(JFrame f) {
        Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
        f.setBounds((dd.width - f.getWidth()) / 2, (dd.height - f.getHeight()) / 2, f.getWidth(), f.getHeight());
    }

    private void layoutNestFrame(boolean show) {
        if (this.nestFrame == null) {
            this.nestFrame = new MyNestFrame();
            this.nestFrame.getContentPane().setLayout(new CardLayout());
            this.nestFrame.setDefaultCloseOperation(2);
            this.nestFrame.setSize(600, 400);
            this.center(this.nestFrame);
            this.nestFrame.setTitle(this.frameTitle);
        }
        if (show) {
            this.nestFrame.getContentPane().add((Component)this.contentPane, "");
        } else {
            this.nestFrame.getContentPane().remove((Component)this.contentPane);
            this.add((Component)this.contentPane, "");
        }
        this.showFrame.setText(show ? EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.Restore") : EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.NewWindow"));
        this.nestFrame.setVisible(show);
    }

    public void reLayout(int style, boolean isShowAtNewFrame) {
        this.doReLayout(style, isShowAtNewFrame);
        this.contentPane.updateUI();
    }

    private void doReLayout(int style, boolean isShowAtNewFrame) {
        int n;
        if (this.isShowAtNewFrame != isShowAtNewFrame) {
            if (isShowAtNewFrame) {
                this.layoutNestFrame(true);
            } else {
                this.layoutNestFrame(false);
            }
            this.isShowAtNewFrame = isShowAtNewFrame;
        }
        this.currentStyle = style;
        switch (style) {
            case 0: {
                this.stylePage.setSelected(true);
                break;
            }
            case 1: {
                this.styleTile.setSelected(true);
            }
        }
        this.pm.clear();
        if (this.contentPane.getComponentCount() > 1) {
            this.contentPane.remove(1);
        }
        if ((n = this.compList.size()) == 0 && this.lastPageCount == n) {
            return;
        }
        if (style == 0) {
            KDCloseableTabbedPane tbl = new KDCloseableTabbedPane();
            tbl.setCloseHandler(this.closeHandler);
            tbl.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((KDCloseableTabbedPane)((Object)e.getSource())).getParent() != null) {
                        MultiLayoutPane.this.lastPageIndex = ((KDCloseableTabbedPane)((Object)e.getSource())).getSelectedIndex();
                    }
                }
            });
            for (int i = 0; i < n; ++i) {
                tbl.addTab((String)this.titleList.get(i), this.getComponentAt(i));
            }
            if (n > 0) {
                if (this.lastPageCount != n || this.lastPageIndex < 0 || this.lastPageIndex >= n) {
                    this.lastPageIndex = n - 1;
                }
                tbl.setSelectedIndex(this.lastPageIndex);
            }
            this.contentPane.add((Component)((Object)tbl), (Object)"Center");
            tbl.updateUI();
        } else {
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    int row = n / 2 + (n % 2 == 0 ? 0 : 1);
                    KDPanel jp = new KDPanel();
                    jp.setLayout((LayoutManager)new GridLayout(row, 2));
                    for (int i = 0; i < n; ++i) {
                        jp.add("", this.getComponentAt(i));
                    }
                    this.contentPane.add((Component)new JScrollPane((Component)jp), (Object)"Center");
                }
            }
        }
        this.lastPageCount = n;
    }

    public void addMultiPartComponent(String title, Component comp) {
        this.compList.add(comp);
        this.titleList.add(title);
    }

    public void clearMultiPartComponent() {
        this.compList.clear();
        this.titleList.clear();
    }

    public int getMultiPartCount() {
        return this.compList.size();
    }

    public Component getMultiPartComponent(int index) {
        return (Component)this.compList.get(index);
    }

    public int indexOfMultiPartComponent(Component comp) {
        return this.compList.indexOf(comp);
    }

    public void removeMultiPartComponent(Component comp) {
        int i = this.compList.indexOf(comp);
        if (i != -1) {
            this.compList.remove(i);
            this.titleList.remove(i);
        }
    }

    private KDSplitPane createHSplitPane() {
        KDSplitPane jsp = new KDSplitPane(1);
        jsp.setOneTouchExpandable(true);
        this.pm.layout(jsp, 0.5f);
        return jsp;
    }

    private KDSplitPane createVSplitPane() {
        KDSplitPane jsp = new KDSplitPane(0);
        jsp.setOneTouchExpandable(true);
        this.pm.layout(jsp, 0.5f);
        return jsp;
    }

    private Component getComponentAt(int i) {
        return (Component)this.compList.get(i);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.nestFrame != null && this.isShowAtNewFrame) {
            this.layoutNestFrame(b);
        }
    }

    public void dispose() {
        if (this.nestFrame != null) {
            this.nestFrame.dispose();
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        MultiLayoutPane msp = new MultiLayoutPane(new KDCloseableTabbedPane.CloseHandler(){

            @Override
            public void close(Component tabbedComponent, int tabIndex) {
            }
        });
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new CardLayout());
        f.getContentPane().add((Component)((Object)msp), "");
        f.setDefaultCloseOperation(2);
        f.setBounds(100, 100, 600, 400);
        int n = 3;
        for (int i = 0; i < n; ++i) {
            JLabel jl = new JLabel("Label-" + i);
            jl.setPreferredSize(new Dimension(100, 100));
            msp.addMultiPartComponent("yyy0" + i, jl);
            msp.addMultiPartComponent("yyy3333333333330" + i, new JLabel("k"));
        }
        msp.reDefaultLayout();
        msp.center(f);
        f.setVisible(true);
    }

    public void setFrameTitle(String frameTitle) {
        this.frameTitle = frameTitle;
        if (this.nestFrame != null) {
            this.nestFrame.setTitle(frameTitle);
        }
    }

    class PercentManager {
        private Map splitMap = new HashMap();

        PercentManager() {
        }

        public void clear() {
            this.splitMap.clear();
        }

        public PercentManager layout(KDSplitPane jsp, float percent) {
            if (!this.splitMap.containsKey(jsp)) {
                jsp.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int w;
                        KDSplitPane s = (KDSplitPane)evt.getSource();
                        int n = w = s.getOrientation() == 1 ? s.getWidth() : s.getHeight();
                        if (w > 0) {
                            float f = (float)s.getDividerLocation() / (float)(w - s.getDividerSize());
                            PercentManager.this.splitMap.put(s, new Float(f));
                        }
                    }
                });
                jsp.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        KDSplitPane jsp = (KDSplitPane)e.getSource();
                        float percent = ((Float)PercentManager.this.splitMap.get(jsp)).floatValue();
                        PercentManager.this.setDividerLocation(jsp, percent);
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }
                });
            }
            this.splitMap.put(jsp, new Float(percent));
            this.setDividerLocation(jsp, percent);
            return this;
        }

        private void setDividerLocation(KDSplitPane jsp, float percent) {
            int w;
            int n = w = jsp.getOrientation() == 1 ? jsp.getWidth() : jsp.getHeight();
            if (w > 0) {
                jsp.setDividerLocation((double)percent);
                this.splitMap.put(jsp, new Float(percent));
            }
        }
    }

    class MyNestFrame
    extends KDFrame {
        MyNestFrame() {
            this.enableEvents(64L);
        }

        protected void processWindowEvent(WindowEvent e) {
            if (e.getID() == 201) {
                MultiLayoutPane.this.reLayout(MultiLayoutPane.this.currentStyle, false);
            } else {
                super.processWindowEvent(e);
            }
        }
    }
}

