/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.client;

import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.management.SimpleLanguageCollection;
import com.kingdee.bos.metadata.access.management.SimpleSolution;
import com.kingdee.bos.metadata.access.management.SolutionSelect;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LocaleUtil {
    private static Logger logger = Logger.getLogger(LocaleUtil.class);
    private static SimpleSolution mySystemSolutionInfo = null;

    public static void setSystemSolutionInfo(SimpleSolution systemSolutionInfo) {
        mySystemSolutionInfo = systemSolutionInfo;
    }

    public static SimpleSolution getSystemSolutionInfo() {
        if (mySystemSolutionInfo == null) {
            mySystemSolutionInfo = LocaleUtil.preLoadSolution();
            logger.info((Object)"solution == null, now get the solution from remote server!");
        }
        return mySystemSolutionInfo;
    }

    public static Locale getOriginalLocale(Locale easLocale) {
        SimpleSolution solution = LocaleUtil.getSystemSolutionInfo();
        if (solution != null) {
            SimpleLanguageCollection lc = solution.getLanguages();
            for (int i = 0; i < lc.size(); ++i) {
                if (!lc.get(i).getLocale().equals(easLocale)) continue;
                return lc.get(i).getOriginalLocale();
            }
        }
        return easLocale;
    }

    private static SimpleSolution preLoadSolution() {
        SolutionSelect select = new SolutionSelect();
        try {
            select.languageSelect().select(new String[]{"postfix", "localeString"});
            return MetaDataAccessFactory.getRemoteInstance().select(select);
        }
        catch (Exception e) {
            logger.error((Object)"load solution error.", (Throwable)e);
            return null;
        }
    }

    public static Locale getEasLocale(Locale originalLocale) {
        SimpleSolution solution = LocaleUtil.getSystemSolutionInfo();
        SimpleLanguageCollection lc = solution.getLanguages();
        for (int i = 0; i < lc.size(); ++i) {
            if (!lc.get(i).getOriginalLocale().equals(originalLocale)) continue;
            return lc.get(i).getLocale();
        }
        return originalLocale;
    }
}

