/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AppToolUtils {
    private static HashMap cacheMap = new HashMap();

    public static List objAryToList(Object[] obj) {
        if (obj == null || obj.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> retList = new ArrayList<String>();
        int size = obj.length;
        for (int i = 0; i < size; ++i) {
            retList.add(StringUtils.cnulls((Object)obj[i]));
        }
        return retList;
    }

    public static String aryToStr(String[] idAry) {
        return AppToolUtils.aryToStr(idAry, true);
    }

    public static String aryToStr(String[] idAry, boolean needSeperate) {
        if (idAry == null || idAry.length == 0) {
            return AppToolUtils.aryToStr(new ArrayList());
        }
        ArrayList<String> retList = new ArrayList<String>();
        int size = idAry.length;
        for (int i = 0; i < size; ++i) {
            retList.add(idAry[i]);
        }
        return AppToolUtils.aryToStr(retList, needSeperate);
    }

    public static String aryToStr(String[] idAry, int number) {
        if (idAry == null || idAry.length == 0) {
            return AppToolUtils.aryToStr(new ArrayList());
        }
        ArrayList<String> retList = new ArrayList<String>();
        int lastAryPos = number;
        if (number >= idAry.length) {
            lastAryPos = idAry.length;
        }
        int size = lastAryPos;
        for (int i = 0; i < size; ++i) {
            retList.add(idAry[i]);
        }
        return AppToolUtils.aryToStr(retList, false);
    }

    public static String aryToStr(Object[] idAry, boolean needSeperate) {
        if (idAry == null || idAry.length == 0) {
            return AppToolUtils.aryToStr(new ArrayList());
        }
        ArrayList<String> retList = new ArrayList<String>();
        int size = idAry.length;
        for (int i = 0; i < size; ++i) {
            if (idAry[i] == null) continue;
            retList.add(idAry[i].toString());
        }
        return AppToolUtils.aryToStr(retList, needSeperate);
    }

    public static String aryToStr(Object[] idAry) {
        return AppToolUtils.aryToStr(idAry, true);
    }

    public static String aryToStr(Collection col) {
        if (col == null || col.isEmpty()) {
            return "''";
        }
        List valueList = AppToolUtils.objAryToList(col.toArray());
        return AppToolUtils.aryToStr(valueList);
    }

    public static String aryToStr(Collection col, boolean addChar) {
        if (col == null || col.isEmpty()) {
            return "''";
        }
        List valueList = AppToolUtils.objAryToList(col.toArray());
        return AppToolUtils.aryToStr(valueList, addChar);
    }

    public static String aryToStr(List idList, boolean addChar) {
        if (idList == null || idList.isEmpty()) {
            return "''";
        }
        StringBuffer receivers = new StringBuffer();
        for (Object obj : idList) {
            if (obj == null) break;
            if (addChar) {
                receivers.append("'").append(obj.toString()).append("',");
                continue;
            }
            receivers.append(obj.toString()).append(",");
        }
        String users = receivers.toString();
        if (users != null && users.trim().length() != 0 && users.endsWith(",") && users.trim().length() > 0) {
            users = users.substring(0, users.length() - 1);
        }
        return users;
    }

    public static String aryToStr(List idList) {
        return AppToolUtils.aryToStr(idList, true);
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("security.*");
        selectorItemCollection.add("person.id");
        selectorItemCollection.add("person.number");
        selectorItemCollection.add("person.name");
        selectorItemCollection.add("group.id");
        selectorItemCollection.add("group.number");
        selectorItemCollection.add("group.name");
        selectorItemCollection.add("defOrgUnit.id");
        selectorItemCollection.add("defOrgUnit.number");
        selectorItemCollection.add("defOrgUnit.name");
        selectorItemCollection.add("customerID");
        selectorItemCollection.add("supplierID");
        selectorItemCollection.add("orgRange.org.*");
        selectorItemCollection.add("orgRange.*");
        selectorItemCollection.add("CU.*");
        return selectorItemCollection;
    }

    public static SelectorItemCollection getOrgIdSelectors() {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("orgRange.org.id");
        selectorItemCollection.add("orgRange.*");
        selectorItemCollection.add("CU.*");
        return selectorItemCollection;
    }

    public static CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    public static IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(AppToolUtils.getCurrentCU().getId());
    }

    public static List orgCol2List(FullOrgUnitCollection fullOrgCol) {
        ArrayList<String> retList = new ArrayList<String>();
        if (fullOrgCol == null || fullOrgCol.isEmpty()) {
            return retList;
        }
        HashSet<String> alreadySet = new HashSet<String>();
        int size = fullOrgCol.size();
        for (int i = 0; i < size; ++i) {
            String keyStr = fullOrgCol.get(i).getId().toString();
            if (alreadySet.contains(keyStr)) continue;
            retList.add(keyStr);
            alreadySet.add(keyStr);
        }
        return retList;
    }

    public static boolean addSysOrgId(List orgIdList) {
        if (orgIdList == null) {
            orgIdList = new ArrayList<String>();
        }
        if (!orgIdList.contains("11111111-1111-1111-1111-111111111111CCE7AED4")) {
            orgIdList.add("11111111-1111-1111-1111-111111111111CCE7AED4");
            return true;
        }
        return false;
    }

    public static FullOrgUnitInfo[] transFromOrgUnitInfo(OrgUnitInfo[] orgUnitInfo) {
        if (orgUnitInfo == null || orgUnitInfo.length == 0) {
            return null;
        }
        int size = orgUnitInfo.length;
        FullOrgUnitInfo[] fullUnitInfo = new FullOrgUnitInfo[size];
        for (int i = 0; i < size; ++i) {
            fullUnitInfo[i] = orgUnitInfo[i].castToFullOrgUnitInfo();
        }
        return fullUnitInfo;
    }

    public static Collection filterSameObj(Collection col) {
        if (col == null || col.size() == 0) {
            return new ArrayList();
        }
        Iterator it = col.iterator();
        HashSet alreadySet = new HashSet();
        ArrayList retList = new ArrayList();
        while (it.hasNext()) {
            Object obj = it.next();
            if (alreadySet.contains(obj)) continue;
            retList.add(obj);
            alreadySet.add(obj);
        }
        return retList;
    }

    public static FullOrgUnitCollection filterSameOrg(FullOrgUnitCollection col) {
        if (col == null || col.isEmpty()) {
            return new FullOrgUnitCollection();
        }
        HashSet<String> alreadySet = new HashSet<String>();
        FullOrgUnitCollection retCol = new FullOrgUnitCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String keyStr = StringUtils.cnulls((Object)col.get(i).getId());
            if (alreadySet.contains(keyStr)) continue;
            retCol.add(col.get(i));
            alreadySet.add(keyStr);
        }
        return retCol;
    }

    public static List trans2List(Collection col) {
        ArrayList retList = new ArrayList();
        if (col == null || col.isEmpty()) {
            return retList;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            retList.add(it.next());
        }
        return retList;
    }

    public static EntityObjectInfo getEntity(Context ctx, BOSObjectType objectType) {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        return loader.getEntity(objectType);
    }

    public static boolean isNullList(Collection col) {
        return col == null || col.isEmpty();
    }

    public static HashMap trans2Map(Collection userOrgRangeList) {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        if (userOrgRangeList == null || userOrgRangeList.isEmpty()) {
            return retMap;
        }
        for (Object obj : userOrgRangeList) {
            retMap.put(StringUtils.cnulls(obj), Boolean.FALSE);
        }
        return retMap;
    }

    public static Set trans2Set(Collection col) {
        HashSet<String> retMap = new HashSet<String>();
        if (col == null || col.isEmpty()) {
            return retMap;
        }
        for (Object obj : col) {
            retMap.add(StringUtils.cnulls(obj));
        }
        return retMap;
    }

    public static void debugInfo(Logger logger, String debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)debugInfo);
        }
    }

    public static void setTableAutoSort(KDTable tblMain) {
        KDTSortManager sm = new KDTSortManager(tblMain);
        sm.setSortAuto(true);
        for (int index = 0; index < tblMain.getColumnCount(); ++index) {
            tblMain.getColumn(index).setSortable(true);
        }
    }

    public static FilterInfo mergerFilter(FilterInfo mainFilter, FilterInfo nextFilterInfo) throws BOSException {
        if (mainFilter == null && nextFilterInfo == null) {
            return null;
        }
        if (mainFilter == null || mainFilter.getFilterItems().size() == 0) {
            return nextFilterInfo;
        }
        if (nextFilterInfo == null || nextFilterInfo.getFilterItems().size() == 0) {
            return mainFilter;
        }
        mainFilter.mergeFilter(nextFilterInfo, "OR");
        return mainFilter;
    }
}

