/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.index.DefaultSkipListWriter;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.ep.index.FormatPostingsTermsConsumer;
import org.apache.lucene.ep.index.FormatPostingsTermsWriter;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.index.TermInfosWriter;
import org.apache.lucene.ep.store.Directory;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    final TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    final FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    public FormatPostingsFieldsWriter(SegmentWriteState state, FieldInfos fieldInfos) throws IOException {
        this.dir = state.directory;
        this.segment = state.segmentName;
        this.totalNumDocs = state.numDocs;
        this.fieldInfos = fieldInfos;
        this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, state.termIndexInterval);
        this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
        state.flushedFiles.add(state.segmentFileName("tis"));
        state.flushedFiles.add(state.segmentFileName("tii"));
        this.termsWriter = new FormatPostingsTermsWriter(state, this);
    }

    @Override
    FormatPostingsTermsConsumer addField(FieldInfo field) {
        this.termsWriter.setField(field);
        return this.termsWriter;
    }

    @Override
    void finish() throws IOException {
        this.termsOut.close();
        this.termsWriter.close();
    }
}

