/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ep.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ep.ui.autocomplete.AbstractCompletion;
import org.fife.ep.ui.autocomplete.CompletionProvider;
import org.fife.ep.ui.autocomplete.FunctionCompletion;
import org.fife.ep.ui.autocomplete.MarkupTagCompletion;
import org.fife.ep.ui.autocomplete.ParameterizedCompletion;
import org.fife.ep.ui.autocomplete.VariableCompletion;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class CompletionXMLParser
extends DefaultHandler {
    private List completions;
    private CompletionProvider provider;
    private String name;
    private String type;
    private String returnType;
    private StringBuffer returnValDesc;
    private StringBuffer desc;
    private String paramName;
    private String paramType;
    private StringBuffer paramDesc;
    private List params;
    private String definedIn;
    private boolean doingKeywords;
    private boolean inKeyword;
    private boolean gettingReturnValDesc;
    private boolean gettingDesc;
    private boolean gettingParams;
    private boolean inParam;
    private boolean gettingParamDesc;
    private char paramStartChar;
    private char paramEndChar;
    private String paramSeparator;

    public CompletionXMLParser(CompletionProvider provider) {
        this.provider = provider;
        this.completions = new ArrayList();
        this.params = new ArrayList(1);
        this.desc = new StringBuffer();
        this.paramDesc = new StringBuffer();
        this.returnValDesc = new StringBuffer();
        this.paramEndChar = '\u0000';
        this.paramStartChar = '\u0000';
        this.paramSeparator = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.gettingDesc) {
            this.desc.append(ch, start, length);
        } else if (this.gettingParamDesc) {
            this.paramDesc.append(ch, start, length);
        } else if (this.gettingReturnValDesc) {
            this.returnValDesc.append(ch, start, length);
        }
    }

    private FunctionCompletion createFunctionCompletion() {
        FunctionCompletion fc = new FunctionCompletion(this.provider, this.name, this.returnType);
        if (this.desc.length() > 0) {
            fc.setShortDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        fc.setParams(this.params);
        fc.setDefinedIn(this.definedIn);
        if (this.returnValDesc.length() > 0) {
            fc.setReturnValueDescription(this.returnValDesc.toString());
            this.returnValDesc.setLength(0);
        }
        return fc;
    }

    private MarkupTagCompletion createMarkupTagCompletion() {
        MarkupTagCompletion mc = new MarkupTagCompletion(this.provider, this.name);
        if (this.desc.length() > 0) {
            mc.setDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        mc.setAttributes(this.params);
        mc.setDefinedIn(this.definedIn);
        return mc;
    }

    private VariableCompletion createVariableCompletion() {
        VariableCompletion vc = new VariableCompletion(this.provider, this.name, this.returnType);
        if (this.desc.length() > 0) {
            vc.setShortDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        vc.setDefinedIn(this.definedIn);
        return vc;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("keywords".equals(qName)) {
            this.doingKeywords = false;
        } else if (this.doingKeywords) {
            if ("keyword".equals(qName)) {
                AbstractCompletion c = null;
                if ("function".equals(this.type)) {
                    c = this.createFunctionCompletion();
                } else if ("constant".equals(this.type)) {
                    c = this.createVariableCompletion();
                } else if ("tag".equals(this.type)) {
                    c = this.createMarkupTagCompletion();
                } else {
                    throw new InternalError("Unexpected type: " + this.type);
                }
                this.completions.add(c);
                this.inKeyword = false;
            } else if (this.inKeyword) {
                if ("returnValDesc".equals(qName)) {
                    this.gettingReturnValDesc = false;
                } else if (this.gettingParams) {
                    if ("params".equals(qName)) {
                        this.gettingParams = false;
                    } else if ("param".equals(qName)) {
                        ParameterizedCompletion.Parameter param = new ParameterizedCompletion.Parameter(this.paramType, this.paramName);
                        if (this.paramDesc.length() > 0) {
                            param.setDescription(this.paramDesc.toString());
                            this.paramDesc.setLength(0);
                        }
                        this.params.add(param);
                        this.inParam = false;
                    } else if (this.inParam && "desc".equals(qName)) {
                        this.gettingParamDesc = false;
                    }
                } else if ("desc".equals(qName)) {
                    this.gettingDesc = false;
                }
            }
        }
    }

    public List getCompletions() {
        return this.completions;
    }

    public char getParamEndChar() {
        return this.paramEndChar;
    }

    public String getParamSeparator() {
        return this.paramSeparator;
    }

    public char getParamStartChar() {
        return this.paramStartChar;
    }

    public void reset(CompletionProvider provider) {
        this.provider = provider;
        this.completions.clear();
        this.gettingParamDesc = false;
        this.inParam = false;
        this.gettingParams = false;
        this.gettingDesc = false;
        this.inKeyword = false;
        this.doingKeywords = false;
        this.paramEndChar = '\u0000';
        this.paramStartChar = '\u0000';
        this.paramSeparator = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        if ("keywords".equals(qName)) {
            this.doingKeywords = true;
        } else if (this.doingKeywords) {
            if ("keyword".equals(qName)) {
                this.name = attrs.getValue("name");
                this.type = attrs.getValue("type");
                this.returnType = attrs.getValue("returnType");
                this.params.clear();
                this.definedIn = attrs.getValue("definedIn");
                this.inKeyword = true;
            } else if (this.inKeyword) {
                if ("returnValDesc".equals(qName)) {
                    this.gettingReturnValDesc = true;
                } else if ("params".equals(qName)) {
                    this.gettingParams = true;
                } else if (this.gettingParams) {
                    if ("param".equals(qName)) {
                        this.paramName = attrs.getValue("name");
                        this.paramType = attrs.getValue("type");
                        this.inParam = true;
                    }
                    if (this.inParam && "desc".equals(qName)) {
                        this.gettingParamDesc = true;
                    }
                } else if ("desc".equals(qName)) {
                    this.gettingDesc = true;
                }
            }
        } else if ("environment".equals(qName)) {
            this.paramStartChar = attrs.getValue("paramStartChar").charAt(0);
            this.paramEndChar = attrs.getValue("paramEndChar").charAt(0);
            this.paramSeparator = attrs.getValue("paramSeparator");
        }
    }
}

