/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.DynamicMetadataProviderManager;
import com.kingdee.bos.metadata.configure.IDynamicMetadataProvider;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.app.AbstractCustomizedSchemeControllerBean;
import com.kingdee.eas.ep.app.depend.ServerCacheManager;
import com.kingdee.eas.ep.app.resource.ResourceI18nUtil;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.ep.plugin.PluginCache;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CustomizedSchemeControllerBean
extends AbstractCustomizedSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ep.app.CustomizedSchemeControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomizedSchemeInfo csInfo = this.getCustomizedSchemeInfo(ctx, pk);
        if (csInfo.isStart()) {
            throw new EPException(EPException.STARTED_SCHEME_NOT_DELETE, new Object[]{csInfo.getAlias()});
        }
        String pkStr = "'" + pk + "'";
        String sql = "delete from T_EP_CustomizedUnit where FCustomizedSchemeID is null or FCustomizedSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_CON_DynamicMetadata where FProjectID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_EditUIOrgUict where exists(select * from T_EP_EditUIConfigure where fid = T_EP_EditUIOrgUict.FConfigureID and FCustomizedSchemeID = '" + pk + "') ";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_EditUIUserOrgUict where exists(select * from T_EP_EditUIConfigure where fid = T_EP_EditUIUserOrgUict.FConfigureID and FCustomizedSchemeID = '" + pk + "') ";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_EditUIConfigure where FCustomizedSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_Sql where FCustomizedSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_CustomizedItem where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_Exception where FProject = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_LibScriptTREE where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_LibScript where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_ExtendPoint where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_ExtendPointParam where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_PlugIn where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_PlugInScript where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_DynQueryScheme where FDynSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_ep_lock where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_RuleParameter where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_Rule where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_RuleSet where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_TriggerTime where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from T_EP_Action where FSchemeID = " + pkStr;
        DbUtil.execute((Context)ctx, (String)sql);
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CustomizedSchemeInfo csInfo = (CustomizedSchemeInfo)model;
        CustomizedSchemeInfo info = this.getCustomizedSchemeInfo(ctx, pk);
        if (StringUtils.isEmpty((String)csInfo.getName()) || StringUtils.isEmpty((String)csInfo.getAlias())) {
            return;
        }
        super._update(ctx, pk, model);
        PluginCache.reload(ctx, PlugInFactory.getLocalInstance(ctx).getPlugin());
        if (csInfo.getName().equals(info.getName()) && csInfo.getAlias().equals(info.getAlias())) {
            return;
        }
        csInfo.setId(BOSUuid.read((String)pk.toString()));
        String oql = "where customizedSchemeID='" + pk + "' and nodeType = '";
        ICustomizedUnit icu = CustomizedUnitFactory.getLocalInstance(ctx);
        CoreBaseCollection units = new CoreBaseCollection();
        CustomizedUnitInfo cuInfo = null;
        try {
            cuInfo = icu.getCustomizedUnitInfo(oql + "ROOT" + "'");
            this.updateRootSchemeUnit(cuInfo, csInfo);
            units.add((CoreBaseInfo)cuInfo);
            icu.update(units);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CustomizedSchemeInfo csInfo = (CustomizedSchemeInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        csInfo.setId(BOSUuid.read((String)pk.toString()));
        ICustomizedUnit icu = CustomizedUnitFactory.getLocalInstance(ctx);
        CoreBaseCollection units = new CoreBaseCollection();
        CustomizedUnitInfo cuInfo = this.createNewUnitInfo();
        this.updateRootSchemeUnit(cuInfo, csInfo);
        units.add((CoreBaseInfo)cuInfo);
        icu.addnew(units);
        return pk;
    }

    private void updatePermissionMetadata(Context ctx, CustomizedUnitInfo permission, CustomizedSchemeInfo csInfo, String projectID) throws Exception {
        PermissionInfo permissionInfo = MetadataUtils.loadPermission((IMetaDataPK)MetaDataPK.create((String)permission.getMetaDataPK()), new Project(projectID));
        if (permissionInfo == null) {
            CustomizedUnitInfo cuInfo = this.createNewUnitInfo();
            this.updateRootSchemeUnit(cuInfo, csInfo);
            PermissionInfo pInfo = this.updatePermissionUnit(permission, csInfo, cuInfo);
            IServerMetadataStore mdstore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
            mdstore.saveMetadata((AbstractMetaDataValue)pInfo, projectID, new Project[0]);
            permissionInfo = MetadataUtils.loadPermission((IMetaDataPK)MetaDataPK.create((String)permission.getMetaDataPK()), new Project(projectID));
        }
        String newMetaDataPK = "com.kingdee.eas.ep." + csInfo.getName() + "Permission";
        MetaDataPK dataPK = MetaDataPK.create((String)newMetaDataPK);
        permissionInfo.setName(dataPK.getName());
        permissionInfo.setPackage(dataPK.getPackage());
        String bosType = permissionInfo.getBOSType().toString();
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp != null) {
            StringBuffer oql = new StringBuffer();
            oql.append("where metaDataPK='");
            oql.append(permission.getMetaDataPK());
            oql.append("' and bosType='");
            oql.append(bosType);
            oql.append("' and projectID='");
            oql.append(projectID);
            oql.append("'");
            boolean exist = dmp.exists(oql.toString());
            if (exist) {
                DynamicMetadataInfo info = dmp.getValue(oql.toString());
                info.setMetaDataPK(newMetaDataPK);
                dmp.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            }
        }
        IServerMetadataStore mdstore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        mdstore.saveMetadata((AbstractMetaDataValue)permissionInfo, projectID);
    }

    private CustomizedUnitInfo createNewUnitInfo() {
        CustomizedUnitInfo cuInfo = new CustomizedUnitInfo();
        BOSUuid id = BOSUuid.create((BOSObjectType)cuInfo.getBOSType());
        cuInfo.setId(id);
        return cuInfo;
    }

    private void updateRootSchemeUnit(CustomizedUnitInfo cuInfo, CustomizedSchemeInfo csInfo) {
        String name = csInfo.getName();
        String alias = csInfo.getAlias();
        cuInfo.setName(name);
        cuInfo.setNumber(name);
        cuInfo.setLongNumber(name);
        cuInfo.setDisplayName(name);
        cuInfo.setAlias(alias);
        cuInfo.setNodeType(NodeTypeEnum.ROOT);
        cuInfo.setLevel(1);
        cuInfo.setIsLeaf(false);
        cuInfo.setCustomizedSchemeID(csInfo.getId().toString());
    }

    private PermissionInfo updatePermissionUnit(CustomizedUnitInfo permission, CustomizedSchemeInfo csInfo, CustomizedUnitInfo cuInfo) {
        String name = csInfo.getName() + "Permission";
        String alias = csInfo.getAlias() + "\u6743\u9650";
        String longNumber = csInfo.getName() + "!" + name;
        String displayName = csInfo.getName() + "_" + name;
        PermissionInfo pInfo = new PermissionInfo();
        pInfo.setName(name);
        pInfo.setAlias(alias);
        pInfo.setPackage("com.kingdee.eas.ep");
        permission.setName(name);
        permission.setDisplayName(displayName);
        permission.setNumber(name);
        permission.setLongNumber(longNumber);
        permission.setAlias(alias);
        permission.setNodeType(NodeTypeEnum.PERMISSION);
        permission.setLevel(2);
        permission.setIsLeaf(true);
        permission.setMetaDataPK(pInfo.getFullName());
        permission.setParent(cuInfo);
        permission.setCustomizedSchemeID(csInfo.getId().toString());
        return pInfo;
    }

    private void updateExcecptionUnit(CustomizedUnitInfo exception, CustomizedSchemeInfo csInfo, CustomizedUnitInfo cuInfo) {
        String name = csInfo.getName() + "Exception";
        String longNumber = csInfo.getName() + "!" + name;
        String displayName = csInfo.getName() + "_" + name;
        exception.setName(name);
        exception.setLongNumber(longNumber);
        exception.setNumber(name);
        exception.setDisplayName(displayName);
        exception.setAlias(csInfo.getAlias() + "\u5f02\u5e38");
        exception.setNodeType(NodeTypeEnum.EXCEPTION);
        exception.setLevel(2);
        exception.setIsLeaf(true);
        exception.setMetaDataPK(exception.getName());
        exception.setParent(cuInfo);
        exception.setCustomizedSchemeID(csInfo.getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List _getDepends(Context ctx, List projectids) throws BOSException {
        ArrayList<Project> projects = new ArrayList<Project>();
        if (projectids != null) {
            Connection con = null;
            Statement state = null;
            try {
                con = this.getConnection(ctx);
                Iterator iterator = projectids.iterator();
                while (iterator.hasNext()) {
                    Project project = new Project((String)iterator.next());
                    this.searchDependsDeep(con, project, new HashSet());
                    projects.add(project);
                }
            }
            catch (Exception se) {
                logger.error((Object)"CustomizedSchemeControllerBean._getDepends fail", (Throwable)se);
            }
            finally {
                SQLUtils.cleanup(state, (Connection)con);
            }
        }
        return projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchDependsDeep(Connection con, Project project, Set hasSearchIDs) throws Exception {
        if (project == null || StringUtils.isEmpty((String)project.getId()) || hasSearchIDs.contains(project.getId())) {
            return;
        }
        hasSearchIDs.add(project.getId());
        String searchSql = "select fdepend from T_EP_CustomizedScheme where fid = ?";
        PreparedStatement state = null;
        ResultSet rs = null;
        try {
            String depend;
            state = con.prepareStatement(searchSql);
            state.setString(1, project.getId());
            rs = state.executeQuery();
            if (rs.next() && !StringUtils.isEmpty((String)(depend = rs.getString("fdepend")))) {
                String[] ids = depend.split(";");
                for (int i = 0; i < ids.length; ++i) {
                    Project child = new Project(ids[i]);
                    project.addDepend(child);
                    this.searchDependsDeep(con, child, hasSearchIDs);
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)state);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state);
    }

    @Override
    protected void _update4Used(Context ctx, String[] ids, boolean isUpdateSql) throws BOSException, EASBizException {
        try {
            CustomizedSchemeCollection col = this.getCustomizedSchemeCollection(ctx, ids);
            ArrayList<String> idList = new ArrayList<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                idList.add(col.get(i).getId().toString());
            }
            if (isUpdateSql) {
                this.beforeStart(ctx, col, idList);
            } else {
                this.beforeDisable(ctx, idList);
            }
            StringBuffer buf = new StringBuffer("UPDATE T_EP_CustomizedScheme SET FSTART = ");
            if (isUpdateSql) {
                buf.append(1);
            } else {
                buf.append(0);
            }
            buf.append(" WHERE FID IN('");
            int size2 = idList.size() - 1;
            for (int i = 0; i < size2; ++i) {
                buf.append(idList.get(i).toString()).append("','");
            }
            buf.append(idList.get(idList.size() - 1)).append("')");
            DbUtil.execute((Context)ctx, (String)buf.toString());
            ServerCacheManager.clearCache(ctx);
            if (isUpdateSql) {
                this._updateSql(ctx, idList);
            }
            this.outPutLog(ctx, col, isUpdateSql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void outPutLog(Context ctx, CustomizedSchemeCollection col, boolean isStart) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(col.get(0).getId().toString());
        String alias = isStart ? ResourceI18nUtil.getString("CustomizedScheme.enable", ctx.getOriginLocale()) : ResourceI18nUtil.getString("CustomizedScheme.disable", ctx.getOriginLocale());
        alias = alias + " : ";
        for (int i = 0; i < col.size() - 1; ++i) {
            CustomizedSchemeInfo scheme = col.get(i);
            alias = alias + scheme.getAlias() + ",";
        }
        alias = alias + col.get(col.size() - 1).getAlias() + ";";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)BOSObjectType.create((String)"2C98D651"), (IObjectPK)pk, (String)alias);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    private CustomizedSchemeCollection getCustomizedSchemeCollection(Context ctx, String[] ids) throws BOSException {
        StringBuffer buf = new StringBuffer("SELECT id,depend , alias where id in ('");
        int size = ids.length - 1;
        for (int i = 0; i < size; ++i) {
            buf.append(ids[i]);
            buf.append("','");
        }
        buf.append(ids[ids.length - 1]).append("')");
        ArrayList idList = new ArrayList();
        return this.getCustomizedSchemeCollection(ctx, buf.toString());
    }

    private void beforeStart(Context ctx, CustomizedSchemeCollection col, ArrayList startedList) throws Exception {
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String depends = col.get(i).getDepend();
            if (StringUtils.isEmpty((String)depends)) continue;
            String[] depend_ids = StringUtils.split((String)depends, (String)";");
            int length = depend_ids.length;
            for (int t = 0; t < length; ++t) {
                if (startedList.contains(depend_ids[t])) continue;
                this.beforeStart(ctx, depend_ids[t]);
            }
        }
    }

    private void beforeStart(Context ctx, String dependId) throws Exception {
        if (StringUtils.isEmpty((String)dependId) || "null".equalsIgnoreCase(dependId)) {
            return;
        }
        String sql = "SELECT FSTART FROM T_EP_CustomizedScheme WHERE  FID  = ";
        String src = sql + "'" + dependId + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)src);
        if (rows.size() < 1) {
            throw new EPException(EPException.DEPEND_SCHEME_NOT_INSTALL);
        }
        String start = "";
        while (rows.next()) {
            start = rows.getString("FSTART");
        }
        if (!"1".equals(start)) {
            throw new EPException(EPException.DEPEND_SCHEME_NOT_START);
        }
    }

    private void beforeDisable(Context ctx, ArrayList idList) throws Exception {
        if (idList == null || idList.size() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer("SELECT FID,FALIAS,FName,FDepend FROM T_EP_CustomizedScheme WHERE FStart = 1 AND FID NOT IN('");
        int size = idList.size() - 1;
        for (int i = 0; i < size; ++i) {
            buf.append(idList.get(i).toString()).append("','");
        }
        buf.append(idList.get(idList.size() - 1)).append("')");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        String depend = null;
        while (rows.next()) {
            depend = rows.getString("FDepend");
            if (StringUtils.isEmpty((String)depend) || "null".equalsIgnoreCase(depend)) continue;
            String[] split = StringUtils.split((String)depend, (String)";");
            int k = split.length;
            for (int j = 0; j < k; ++j) {
                if (!idList.contains(split[j])) continue;
                String alias = rows.getString("FALIAS");
                if (StringUtils.isEmpty((String)alias)) {
                    alias = rows.getString("FName");
                }
                throw new BOSException("\u5b58\u5728\u4f9d\u8d56\u4e8e\u6b64\u65b9\u6848\u7684\u52a8\u6001\u6269\u5c55\u65b9\u6848\u5904\u4e8e\u542f\u7528\u72b6\u6001  , \u8bf7\u5148\u53cd\u542f\u7528\u65b9\u6848   : " + alias);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void _updateSql(Context ctx, List projectID) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected byte[] _exportScheme(Context ctx, String schemeId) throws BOSException, EASBizException {
        byte[] bb = null;
        try {
            bb = EPUtils.exportScheme(ctx, schemeId);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        return bb;
    }

    @Override
    protected void _importScheme(Context ctx, byte[] schemeData) throws BOSException, EASBizException {
        try {
            EPUtils.importScheme(ctx, schemeData);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectPK _addnew2(Context ctx, IObjectValue model) throws BOSException {
        try {
            return super._addnew(ctx, model);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _saveDynQueryScheme(Context ctx, String customizedSchemeId, String dynQuerySchemeId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("SELECT 1 FROM T_EP_DynQueryScheme WHERE ");
        sb.append(" FDynSchemeID='");
        sb.append(customizedSchemeId);
        sb.append("' AND FDynQueryID='");
        sb.append(dynQuerySchemeId);
        sb.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rows.next()) {
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sb = new StringBuffer("INSERT INTO T_EP_DynQueryScheme ");
        sb.append("(FDynSchemeID,FDynQueryID) VALUES ('");
        sb.append(customizedSchemeId);
        sb.append("','");
        sb.append(dynQuerySchemeId);
        sb.append("')");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    public CustomizedSchemeCollection getCustomizedSchemeCollection(Context ctx) throws BOSException {
        ServiceContext svcCtx = this.createServiceContext(new MetaDataPK("0b844150-639b-461e-b5fc-c1c439abb8e2"), new Object[]{ctx});
        CustomizedSchemeCollection retValue = (CustomizedSchemeCollection)this._getCollection(ctx, (IServiceContext)svcCtx);
        svcCtx.setMethodReturnValue((Object)retValue);
        return retValue;
    }

    @Override
    protected byte[] _exportScheme(Context ctx, String schemeId, boolean exportLock) throws BOSException, EASBizException {
        byte[] bb = null;
        try {
            bb = EPUtils.exportScheme(ctx, schemeId, exportLock);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        return bb;
    }

    @Override
    protected byte[] _exportSchemeToSQL(Context ctx, String schemeId, String path) throws BOSException, EASBizException {
        try {
            return EPUtils.exportSchemeToSQL(ctx, schemeId, path);
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }
}

