/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.ExtendPointCollection;
import com.kingdee.eas.ep.ExtendPointFactory;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.IPlugInScript;
import com.kingdee.eas.ep.LibScriptCollection;
import com.kingdee.eas.ep.LibScriptFactory;
import com.kingdee.eas.ep.LibScriptInfo;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.PlugInInfo;
import com.kingdee.eas.ep.PlugInScriptFactory;
import com.kingdee.eas.ep.PlugInScriptInfo;
import com.kingdee.eas.ep.app.AbstractPlugInControllerBean;
import com.kingdee.eas.ep.plugin.PluginCache;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PlugInControllerBean
extends AbstractPlugInControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ep.app.PlugInControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlugInInfo plugIn = (PlugInInfo)model;
        if (StringUtils.isEmpty((String)plugIn.getSchemeID())) {
            return null;
        }
        ExtendPointInfo point = plugIn.getPoint();
        String owner = plugIn.getOwner();
        point.setSchemeID(plugIn.getSchemeID());
        if (point.getId() == null) {
            IObjectPK pk = ExtendPointFactory.getLocalInstance(ctx).addnew(point);
            point.setId(BOSUuid.read((String)pk.toString()));
        }
        this.updateScript(ctx, plugIn);
        IObjectCollection pc = this._getPlugIn(ctx, plugIn.getSchemeID(), plugIn.getOwner(), (IObjectValue)point);
        if (pc != null && pc.size() > 0) {
            PlugInInfo p = (PlugInInfo)pc.getObject(0);
            plugIn.setId(p.getId());
            ObjectUuidPK pk = new ObjectUuidPK(p.getId());
            this.update(ctx, (IObjectPK)pk, plugIn);
            return pk;
        }
        if (plugIn.getScriptBefore() == null && plugIn.getScriptAfter() == null) {
            return null;
        }
        IObjectPK pk = super._addnew(ctx, model);
        PluginCache.reload(ctx, owner, point, (PlugInCollection)this._getPlugIn(ctx, owner, (IObjectValue)point, false));
        return pk;
    }

    @Override
    protected IObjectCollection _getPlugIn(Context ctx, String schemeID, String owner, IObjectValue extendPoint) throws BOSException, EASBizException {
        ExtendPointInfo point = (ExtendPointInfo)extendPoint;
        if (point == null || StringUtils.isEmpty((String)owner)) {
            return null;
        }
        if (point.getId() == null) {
            point = ExtendPointFactory.getLocalInstance(ctx).getExtendPoint(point, schemeID);
        }
        if (point == null || point.getId() == null) {
            return null;
        }
        String scheme = null;
        scheme = StringUtils.isEmpty((String)schemeID) ? "schemeID is null" : "schemeID = '" + schemeID + "'";
        return this.getPlugInCollection(ctx, "select *,point.*,point.param.*,scriptBefore.*,scriptAfter.* where owner = '" + owner + "' and point.id = '" + point.getId() + "' and " + scheme);
    }

    @Override
    protected IObjectCollection _getPlugIn(Context ctx, String owner, IObjectValue extendPoint) throws BOSException, EASBizException {
        return this._getPlugIn(ctx, owner, extendPoint, true);
    }

    @Override
    protected IObjectCollection _getPlugIn(Context ctx, String owner, IObjectValue extendPoint, boolean userCache) throws BOSException, EASBizException {
        ExtendPointInfo point = (ExtendPointInfo)extendPoint;
        if (point == null || StringUtils.isEmpty((String)owner)) {
            return null;
        }
        PlugInCollection piCol = null;
        if (userCache) {
            piCol = PluginCache.getPlugin(ctx, owner, point);
        } else {
            ExtendPointCollection col = ExtendPointFactory.getLocalInstance(ctx).getExtendPoint(point);
            if (col == null || col.size() <= 0) {
                return null;
            }
            StringBuffer pointIds = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                if (pointIds == null) {
                    pointIds = new StringBuffer();
                } else {
                    pointIds.append(",");
                }
                pointIds.append("'");
                pointIds.append(col.get(i).getId());
                pointIds.append("'");
            }
            String scheme = "schemeID in (" + this.getEnableSchemeIDs(ctx) + ")";
            piCol = this.getPlugInCollection(ctx, "select *,point.*,point.param.*,scriptBefore.*,scriptAfter.* where owner = '" + owner + "' and point.id in (" + pointIds + ") and " + scheme);
        }
        return piCol;
    }

    @Override
    protected IObjectCollection _getPlugIn(Context ctx, String owner) throws BOSException, EASBizException {
        String scheme = "schemeID in (" + this.getEnableSchemeIDs(ctx) + ")";
        PlugInCollection collection = this.getPlugInCollection(ctx, "select *,point.*,point.param.*,scriptBefore.*,scriptAfter.* where owner = '" + owner + "' and " + scheme);
        return collection;
    }

    private String getEnableSchemeIDs(Context ctx) throws BOSException, EASBizException {
        String enableScheme = "select fid from T_EP_CustomizedScheme where FStart = 1";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)enableScheme);
        StringBuffer schemeIDs = null;
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    if (schemeIDs == null) {
                        schemeIDs = new StringBuffer();
                    } else {
                        schemeIDs.append(",");
                    }
                    schemeIDs.append("'");
                    schemeIDs.append(rowSet.getString("fid"));
                    schemeIDs.append("'");
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return schemeIDs == null ? "''" : schemeIDs.toString();
    }

    @Override
    protected IObjectCollection _getPlugin(Context ctx) throws BOSException, EASBizException {
        String scheme = "schemeID in (" + this.getEnableSchemeIDs(ctx) + ")";
        PlugInCollection col = this.getPlugInCollection(ctx, "select *,point.*,point.param.*,scriptBefore.*,scriptAfter.* where " + scheme);
        return col;
    }

    private void updateScript(Context ctx, PlugInInfo plugin) throws BOSException, EASBizException {
        PlugInScriptInfo script = plugin.getScriptBefore();
        if (script != null) {
            script.setSchemeID(plugin.getSchemeID());
        }
        plugin.setScriptBefore(this.updateScript(ctx, script));
        script = plugin.getScriptAfter();
        if (script != null) {
            script.setSchemeID(plugin.getSchemeID());
        }
        plugin.setScriptAfter(this.updateScript(ctx, script));
    }

    private PlugInScriptInfo updateScript(Context ctx, PlugInScriptInfo script) throws BOSException, EASBizException {
        if (script == null) {
            return null;
        }
        IPlugInScript iscript = PlugInScriptFactory.getLocalInstance(ctx);
        if (StringUtils.isEmpty((String)script.getContent())) {
            if (script.getId() != null) {
                String idStr = "'" + script.getId() + "'";
                String sql = "delete from T_EP_PlugInScript where fid = " + idStr;
                DbUtil.execute((Context)ctx, (String)sql);
            }
            script = null;
        } else if (script.getId() == null) {
            IObjectPK pk = iscript.addnew(script);
            script.setId(BOSUuid.read((String)pk.toString()));
        } else {
            iscript.update((IObjectPK)new ObjectUuidPK(script.getId()), script);
        }
        return script;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PlugInInfo info = (PlugInInfo)model;
        this.updateScript(ctx, info);
        if (info.getScriptBefore() == null && info.getScriptAfter() == null) {
            this._delete(ctx, pk);
        } else {
            super._update(ctx, pk, model);
        }
        ExtendPointInfo point = info.getPoint();
        String owner = info.getOwner();
        PluginCache.reload(ctx, owner, point, (PlugInCollection)this._getPlugIn(ctx, owner, (IObjectValue)point, false));
    }

    @Override
    protected IObjectCollection _getExtendPoints(Context ctx, String schemeID, String key) throws BOSException, EASBizException {
        String scheme = null;
        scheme = StringUtils.isEmpty((String)schemeID) ? "schemeID is null" : "schemeID = '" + schemeID + "'";
        ExtendPointCollection epc = new ExtendPointCollection();
        PlugInCollection pCol = this.getPlugInCollection(ctx, "select id,point.*,point.param.* where owner = '" + key + "' and " + scheme);
        if (pCol != null) {
            int size = pCol.size();
            for (int i = 0; i < size; ++i) {
                epc.add(pCol.get(i).getPoint());
            }
        }
        return epc;
    }

    @Override
    protected String _getExecuteLibScript(Context ctx, String libScriptIDs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)libScriptIDs)) {
            return null;
        }
        LibScriptCollection lsc = LibScriptFactory.getLocalInstance(ctx).getLibScriptCollection("select * where id in (" + this.getIDs(libScriptIDs) + ")");
        HashSet<String> instances = new HashSet<String>();
        StringBuffer script = new StringBuffer();
        LibScriptInfo lsi = null;
        String instance = null;
        String function = null;
        String content = null;
        int size = lsc.size();
        for (int i = 0; i < size; ++i) {
            lsi = lsc.get(i);
            instance = "$" + lsi.getNumber();
            function = lsi.getName();
            content = lsi.getContent();
            instances.add(instance);
            script.append(instance);
            script.append(".");
            script.append(function);
            script.append("=");
            int index = content.indexOf(function);
            script.append(content.substring(0, index) + content.substring(index + function.length()));
            script.append("\n");
        }
        Iterator ite = instances.iterator();
        StringBuffer is = new StringBuffer();
        while (ite.hasNext()) {
            instance = (String)ite.next();
            is.append("var ");
            is.append(instance);
            is.append("={};\n");
        }
        is.append(script);
        return is.toString();
    }

    private String getIDs(String ids) {
        StringBuffer r = null;
        String[] s = StringUtils.split((String)ids, (String)";");
        for (int i = 0; i < s.length; ++i) {
            if (r == null) {
                r = new StringBuffer();
            } else {
                r.append(",");
            }
            r.append("'");
            r.append(s[i]);
            r.append("'");
        }
        return r.toString();
    }

    @Override
    protected List _getExtendMetas(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select P.fowner , E.FInner from T_EP_PlugIn P ");
        sql.append(" inner join T_EP_ExtendPoint E on P.FPointID = E.FID ");
        sql.append(" inner join T_EP_CustomizedScheme C on P.FSchemeID = C.FID ");
        sql.append(" where C.FStart=1 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> methods = new HashSet<String>();
        HashSet<String> actions = new HashSet<String>();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    String owner = rowSet.getString("fowner");
                    int inner = rowSet.getInt("FInner");
                    if (inner == 1) {
                        methods.add(owner);
                        continue;
                    }
                    actions.add(owner);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<HashSet<String>> list = new ArrayList<HashSet<String>>(2);
        list.add(methods);
        list.add(actions);
        return list;
    }

    @Override
    protected Set _getEvents(Context ctx, String owner) throws BOSException {
        StringBuffer sql = new StringBuffer("select fname from T_EP_ExtendPoint E ");
        sql.append(" inner join T_EP_PlugIn P on E.FID = P.FPointID");
        sql.append(" where P.FOwner='" + owner + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    set.add(rowSet.getString("fname"));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return set;
    }
}

