/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.ep.index.DocFieldConsumer;
import org.apache.lucene.ep.index.DocFieldConsumerPerThread;
import org.apache.lucene.ep.index.DocFieldProcessorPerThread;
import org.apache.lucene.ep.index.DocInverterPerField;
import org.apache.lucene.ep.index.DocInverterPerThread;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.InvertedDocConsumer;
import org.apache.lucene.ep.index.InvertedDocConsumerPerField;
import org.apache.lucene.ep.index.InvertedDocEndConsumer;
import org.apache.lucene.ep.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.ep.index.SegmentWriteState;

final class DocInverter
extends DocFieldConsumer {
    final InvertedDocConsumer consumer;
    final InvertedDocEndConsumer endConsumer;

    public DocInverter(InvertedDocConsumer consumer, InvertedDocEndConsumer endConsumer) {
        this.consumer = consumer;
        this.endConsumer = endConsumer;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.consumer.setFieldInfos(fieldInfos);
        this.endConsumer.setFieldInfos(fieldInfos);
    }

    @Override
    void flush(Map threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap childThreadsAndFields = new HashMap();
        HashMap endChildThreadsAndFields = new HashMap();
        for (Map.Entry entry : threadsAndFields.entrySet()) {
            DocInverterPerThread perThread = (DocInverterPerThread)entry.getKey();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            HashSet<InvertedDocConsumerPerField> childFields = new HashSet<InvertedDocConsumerPerField>();
            HashSet<InvertedDocEndConsumerPerField> endChildFields = new HashSet<InvertedDocEndConsumerPerField>();
            while (fieldsIt.hasNext()) {
                DocInverterPerField perField = (DocInverterPerField)fieldsIt.next();
                childFields.add(perField.consumer);
                endChildFields.add(perField.endConsumer);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            endChildThreadsAndFields.put(perThread.endConsumer, endChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.endConsumer.flush(endChildThreadsAndFields, state);
    }

    @Override
    public void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        this.endConsumer.closeDocStore(state);
    }

    @Override
    void abort() {
        this.consumer.abort();
        this.endConsumer.abort();
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) {
        return new DocInverterPerThread(docFieldProcessorPerThread, this);
    }
}

