/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.ep.index.CorruptIndexException;
import org.apache.lucene.ep.index.IndexWriter;
import org.apache.lucene.ep.index.MergePolicy;
import org.apache.lucene.ep.index.SegmentInfo;
import org.apache.lucene.ep.index.SegmentInfos;

public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    long minMergeSize;
    long maxMergeSize;
    int maxMergeDocs = Integer.MAX_VALUE;
    protected boolean calibrateSizeByDeletes = false;
    private boolean useCompoundFile = true;
    private boolean useCompoundDocStore = true;

    public LogMergePolicy(IndexWriter writer) {
        super(writer);
    }

    protected boolean verbose() {
        return this.writer != null && this.writer.verbose();
    }

    private void message(String message) {
        if (this.verbose()) {
            this.writer.message("LMP: " + message);
        }
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    @Override
    public boolean useCompoundFile(SegmentInfos infos, SegmentInfo info) {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean useCompoundFile) {
        this.useCompoundFile = useCompoundFile;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    @Override
    public boolean useCompoundDocStore(SegmentInfos infos) {
        return this.useCompoundDocStore;
    }

    public void setUseCompoundDocStore(boolean useCompoundDocStore) {
        this.useCompoundDocStore = useCompoundDocStore;
    }

    public boolean getUseCompoundDocStore() {
        return this.useCompoundDocStore;
    }

    public void setCalibrateSizeByDeletes(boolean calibrateSizeByDeletes) {
        this.calibrateSizeByDeletes = calibrateSizeByDeletes;
    }

    public boolean getCalibrateSizeByDeletes() {
        return this.calibrateSizeByDeletes;
    }

    @Override
    public void close() {
    }

    protected abstract long size(SegmentInfo var1) throws IOException;

    protected long sizeDocs(SegmentInfo info) throws IOException {
        if (this.calibrateSizeByDeletes) {
            int delCount = this.writer.numDeletedDocs(info);
            return (long)info.docCount - (long)delCount;
        }
        return info.docCount;
    }

    protected long sizeBytes(SegmentInfo info) throws IOException {
        long byteSize = info.sizeInBytes();
        if (this.calibrateSizeByDeletes) {
            int delCount = this.writer.numDeletedDocs(info);
            float delRatio = info.docCount <= 0 ? 0.0f : (float)delCount / (float)info.docCount;
            return info.docCount <= 0 ? byteSize : (long)((float)byteSize * (1.0f - delRatio));
        }
        return byteSize;
    }

    private boolean isOptimized(SegmentInfos infos, int maxNumSegments, Set segmentsToOptimize) throws IOException {
        int numSegments = infos.size();
        int numToOptimize = 0;
        SegmentInfo optimizeInfo = null;
        for (int i = 0; i < numSegments && numToOptimize <= maxNumSegments; ++i) {
            SegmentInfo info = infos.info(i);
            if (!segmentsToOptimize.contains(info)) continue;
            ++numToOptimize;
            optimizeInfo = info;
        }
        return numToOptimize <= maxNumSegments && (numToOptimize != 1 || this.isOptimized(optimizeInfo));
    }

    private boolean isOptimized(SegmentInfo info) throws IOException {
        boolean hasDeletions = this.writer.numDeletedDocs(info) > 0;
        return !hasDeletions && !info.hasSeparateNorms() && info.dir == this.writer.getDirectory() && info.getUseCompoundFile() == this.useCompoundFile;
    }

    @Override
    public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos infos, int maxNumSegments, Set segmentsToOptimize) throws IOException {
        MergePolicy.MergeSpecification spec;
        assert (maxNumSegments > 0);
        if (!this.isOptimized(infos, maxNumSegments, segmentsToOptimize)) {
            int last = infos.size();
            while (last > 0) {
                SegmentInfo info;
                if (!segmentsToOptimize.contains(info = infos.info(--last))) continue;
                ++last;
                break;
            }
            if (last > 0) {
                spec = new MergePolicy.MergeSpecification();
                while (last - maxNumSegments + 1 >= this.mergeFactor) {
                    spec.add(new MergePolicy.OneMerge(infos.range(last - this.mergeFactor, last), this.useCompoundFile));
                    last -= this.mergeFactor;
                }
                if (0 == spec.merges.size()) {
                    if (maxNumSegments == 1) {
                        if (last > 1 || !this.isOptimized(infos.info(0))) {
                            spec.add(new MergePolicy.OneMerge(infos.range(0, last), this.useCompoundFile));
                        }
                    } else if (last > maxNumSegments) {
                        int finalMergeSize = last - maxNumSegments + 1;
                        long bestSize = 0L;
                        int bestStart = 0;
                        for (int i = 0; i < last - finalMergeSize + 1; ++i) {
                            long sumSize = 0L;
                            for (int j = 0; j < finalMergeSize; ++j) {
                                sumSize += this.size(infos.info(j + i));
                            }
                            if (i != 0 && (sumSize >= 2L * this.size(infos.info(i - 1)) || sumSize >= bestSize)) continue;
                            bestStart = i;
                            bestSize = sumSize;
                        }
                        spec.add(new MergePolicy.OneMerge(infos.range(bestStart, bestStart + finalMergeSize), this.useCompoundFile));
                    }
                }
            } else {
                spec = null;
            }
        } else {
            spec = null;
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMergesToExpungeDeletes(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
        int numSegments = segmentInfos.size();
        if (this.verbose()) {
            this.message("findMergesToExpungeDeletes: " + numSegments + " segments");
        }
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        int firstSegmentWithDeletions = -1;
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info = segmentInfos.info(i);
            int delCount = this.writer.numDeletedDocs(info);
            if (delCount > 0) {
                if (this.verbose()) {
                    this.message("  segment " + info.name + " has deletions");
                }
                if (firstSegmentWithDeletions == -1) {
                    firstSegmentWithDeletions = i;
                    continue;
                }
                if (i - firstSegmentWithDeletions != this.mergeFactor) continue;
                if (this.verbose()) {
                    this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive");
                }
                spec.add(new MergePolicy.OneMerge(segmentInfos.range(firstSegmentWithDeletions, i), this.useCompoundFile));
                firstSegmentWithDeletions = i;
                continue;
            }
            if (firstSegmentWithDeletions == -1) continue;
            if (this.verbose()) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive");
            }
            spec.add(new MergePolicy.OneMerge(segmentInfos.range(firstSegmentWithDeletions, i), this.useCompoundFile));
            firstSegmentWithDeletions = -1;
        }
        if (firstSegmentWithDeletions != -1) {
            if (this.verbose()) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (numSegments - 1) + " inclusive");
            }
            spec.add(new MergePolicy.OneMerge(segmentInfos.range(firstSegmentWithDeletions, numSegments), this.useCompoundFile));
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
        int numSegments = infos.size();
        if (this.verbose()) {
            this.message("findMerges: " + numSegments + " segments");
        }
        float[] levels = new float[numSegments];
        float norm = (float)Math.log(this.mergeFactor);
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info = infos.info(i);
            long size = this.size(info);
            if (size < 1L) {
                size = 1L;
            }
            levels[i] = (float)Math.log(size) / norm;
        }
        float levelFloor = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)norm);
        MergePolicy.MergeSpecification spec = null;
        int start = 0;
        while (start < numSegments) {
            int upto;
            float levelBottom;
            float maxLevel = levels[start];
            for (int i = 1 + start; i < numSegments; ++i) {
                float level = levels[i];
                if (!(level > maxLevel)) continue;
                maxLevel = level;
            }
            if (maxLevel < levelFloor) {
                levelBottom = -1.0f;
            } else {
                levelBottom = (float)((double)maxLevel - 0.75);
                if (levelBottom < levelFloor && maxLevel >= levelFloor) {
                    levelBottom = levelFloor;
                }
            }
            for (upto = numSegments - 1; upto >= start && !(levels[upto] >= levelBottom); --upto) {
            }
            if (this.verbose()) {
                this.message("  level " + levelBottom + " to " + maxLevel + ": " + (1 + upto - start) + " segments");
            }
            int end = start + this.mergeFactor;
            while (end <= 1 + upto) {
                boolean anyTooLarge = false;
                for (int i = start; i < end; ++i) {
                    SegmentInfo info = infos.info(i);
                    anyTooLarge |= this.size(info) >= this.maxMergeSize || this.sizeDocs(info) >= (long)this.maxMergeDocs;
                }
                if (!anyTooLarge) {
                    if (spec == null) {
                        spec = new MergePolicy.MergeSpecification();
                    }
                    if (this.verbose()) {
                        this.message("    " + start + " to " + end + ": add this merge");
                    }
                    spec.add(new MergePolicy.OneMerge(infos.range(start, end), this.useCompoundFile));
                } else if (this.verbose()) {
                    this.message("    " + start + " to " + end + ": contains segment over maxMergeSize or maxMergeDocs; skipping");
                }
                start = end;
                end = start + this.mergeFactor;
            }
            start = 1 + upto;
        }
        return spec;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }
}

