/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.search.Collector;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.HitCollector;
import org.apache.lucene.ep.search.HitCollectorWrapper;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.TermQuery;
import org.apache.lucene.ep.search.Weight;

final class TermScorer
extends Scorer {
    private static final float[] SIM_NORM_DECODER = Similarity.getNormDecoder();
    private Weight weight;
    private TermDocs termDocs;
    private byte[] norms;
    private float weightValue;
    private int doc = -1;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs td, Similarity similarity, byte[] norms) {
        super(similarity);
        this.weight = weight;
        this.termDocs = td;
        this.norms = norms;
        this.weightValue = weight.getValue();
        for (int i = 0; i < 32; ++i) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
        }
    }

    @Override
    public void score(HitCollector hc) throws IOException {
        this.score(new HitCollectorWrapper(hc));
    }

    @Override
    public void score(Collector c) throws IOException {
        this.score(c, Integer.MAX_VALUE, this.nextDoc());
    }

    @Override
    protected boolean score(HitCollector c, int end) throws IOException {
        return this.score(new HitCollectorWrapper(c), end, this.doc);
    }

    @Override
    protected boolean score(Collector c, int end, int firstDocID) throws IOException {
        c.setScorer(this);
        while (this.doc < end) {
            c.collect(this.doc);
            if (++this.pointer >= this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
            }
            this.doc = this.docs[this.pointer];
        }
        return true;
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    @Override
    public int nextDoc() throws IOException {
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        }
        this.doc = this.docs[this.pointer];
        return this.doc;
    }

    @Override
    public float score() {
        assert (this.doc != -1);
        int f = this.freqs[this.pointer];
        float raw = f < 32 ? this.scoreCache[f] : this.getSimilarity().tf(f) * this.weightValue;
        return this.norms == null ? raw : raw * SIM_NORM_DECODER[this.norms[this.doc] & 0xFF];
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] >= target) {
                this.doc = this.docs[this.pointer];
                return this.doc;
            }
            ++this.pointer;
        }
        boolean result = this.termDocs.skipTo(target);
        if (result) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        TermQuery query = (TermQuery)this.weight.getQuery();
        Explanation tfExplanation = new Explanation();
        int tf = 0;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] == doc) {
                tf = this.freqs[this.pointer];
            }
            ++this.pointer;
        }
        if (tf == 0 && this.termDocs.skipTo(doc) && this.termDocs.doc() == doc) {
            tf = this.termDocs.freq();
        }
        this.termDocs.close();
        tfExplanation.setValue(this.getSimilarity().tf(tf));
        tfExplanation.setDescription("tf(termFreq(" + query.getTerm() + ")=" + tf + ")");
        return tfExplanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

