/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.spans.SpanQuery;
import org.apache.lucene.ep.search.spans.Spans;
import org.apache.lucene.ep.search.spans.TermSpans;
import org.apache.lucene.ep.util.ToStringUtils;

public class SpanTermQuery
extends SpanQuery {
    protected Term term;

    public SpanTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.term);
        return terms;
    }

    @Override
    public void extractTerms(Set terms) {
        terms.add(this.term);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanTermQuery other = (SpanTermQuery)obj;
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    @Override
    public Spans getSpans(IndexReader reader) throws IOException {
        return new TermSpans(reader.termPositions(this.term), this.term);
    }
}

