/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.depend;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MetadataUtils {
    private static final Logger logger = Logger.getLogger((String)MetadataUtils.class.getName());

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitInfo biz = (BizUnitInfo)MetadataUtils.loadMD(MetaDataTypeList.BIZUNIT, pk);
                return biz;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return bizUnit;
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk, Project depend) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitInfo biz = (BizUnitInfo)MetadataUtils.loadMD(MetaDataTypeList.BIZUNIT, pk, depend);
                return biz;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return bizUnit;
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk, Project depend) {
        EntityObjectInfo entity = (EntityObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.ENTITY, pk, depend);
        return entity;
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk, Project depend) {
        BizEnumInfo bizEnum = (BizEnumInfo)MetadataUtils.loadMD(MetaDataTypeList.BIZENUM, pk, depend);
        return bizEnum;
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk, Project depend) {
        FunctionObjectInfo fun = (FunctionObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.FUNCTION, pk, depend);
        return fun;
    }

    public static QueryInfo loadQuery(IMetaDataPK pk, Project depend) {
        QueryInfo query = (QueryInfo)MetadataUtils.loadMD(MetaDataTypeList.BASEQUERY, pk, depend);
        MetadataUtils.checkQuery(query);
        return query;
    }

    private static void checkQuery(QueryInfo query) {
        if (query instanceof JoinQueryInfo) {
            int i;
            JoinQueryInfo queryInfo = (JoinQueryInfo)query;
            JoinCollection joins = queryInfo.getJoins();
            SubObjectCollection subObjs = queryInfo.getSubObjects();
            HashMap rightMap = new HashMap();
            HashMap leftMap = new HashMap();
            if (joins.size() <= 1) {
                return;
            }
            for (i = 0; i < joins.size(); ++i) {
                JoinInfo join = joins.get(i);
                if (join != null && join.getLeftObject() != null) {
                    rightMap.put(join.getLeftObject().getName().toLowerCase(), null);
                }
                if (join == null || join.getRightObject() == null) continue;
                rightMap.put(join.getRightObject().getName().toLowerCase(), null);
            }
            for (i = 0; i < subObjs.size(); ++i) {
                SubObjectInfo sub = subObjs.get(i);
                if (leftMap.containsKey(sub.getName().toLowerCase()) || rightMap.containsKey(sub.getName().toLowerCase())) continue;
                subObjs.remove(sub);
            }
        }
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk, Project depend) {
        UIObjectInfo ui = (UIObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.UIOBJECT, pk, depend);
        return ui;
    }

    public static WebUIObjectInfo loadWebUI(IMetaDataPK pk, Project depend) {
        WebUIObjectInfo ui = (WebUIObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.WEBUIOBJECT, pk, depend);
        return ui;
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk, Project depend) {
        FacadeInfo fi = (FacadeInfo)MetadataUtils.loadMD(MetaDataTypeList.FACADE, pk, depend);
        return fi;
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk, Project depend) {
        PermissionInfo pi = (PermissionInfo)MetadataUtils.loadMD(MetaDataTypeList.PERMISSION, pk, depend);
        return pi;
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk, Project depend) {
        if (depend == null) {
            return MetadataUtils.loadMD(type, pk);
        }
        if (pk != null && type != null) {
            try {
                IMetaDataLoader loader = MetadataUtils.getMDloader();
                Project.Projects projects = Project.Projects.getProjects((Project[])new Project[]{depend}, null);
                return loader.get(type, pk, projects);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public static void clearCache(BOSObjectType type) {
        IMetaDataLoader loader = MetadataUtils.getMDloader();
        if (MetaDataTypeList.WEBUIOBJECT.equals((Object)type)) {
            loader.clear(MetaDataTypeList.WEBUIOBJECT);
        } else if (MetaDataTypeList.ENTITY.equals((Object)type)) {
            loader.clear(MetaDataTypeList.ENTITY);
            loader.clear(MetaDataTypeList.DATATABLE);
            loader.clear(MetaDataTypeList.RELATIONSHIP);
        } else if (MetaDataTypeList.JOINQUERY.equals((Object)type)) {
            loader.clear(MetaDataTypeList.JOINQUERY);
        } else if (MetaDataTypeList.BASEQUERY.equals((Object)type)) {
            loader.clear(MetaDataTypeList.BASEQUERY);
        } else if (MetaDataTypeList.FUNCTION.equals((Object)type)) {
            loader.clear(MetaDataTypeList.FUNCTION);
        } else if (MetaDataTypeList.BIZENUM.equals((Object)type)) {
            loader.clear(MetaDataTypeList.BIZENUM);
        } else if (MetaDataTypeList.PACKAGE.equals((Object)type)) {
            loader.clear(MetaDataTypeList.PACKAGE);
        }
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk) {
        EntityObjectInfo entity = (EntityObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.ENTITY, pk);
        return entity;
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk) {
        BizEnumInfo bizEnum = (BizEnumInfo)MetadataUtils.loadMD(MetaDataTypeList.BIZENUM, pk);
        return bizEnum;
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk) {
        FunctionObjectInfo fun = (FunctionObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.FUNCTION, pk);
        return fun;
    }

    public static QueryInfo loadQuery(IMetaDataPK pk) {
        QueryInfo query = (QueryInfo)MetadataUtils.loadMD(MetaDataTypeList.BASEQUERY, pk);
        return query;
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk) {
        UIObjectInfo ui = (UIObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.UIOBJECT, pk);
        return ui;
    }

    public static WebUIObjectInfo loadWebUI(IMetaDataPK pk) {
        WebUIObjectInfo ui = (WebUIObjectInfo)MetadataUtils.loadMD(MetaDataTypeList.WEBUIOBJECT, pk);
        return ui;
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk) {
        FacadeInfo fi = (FacadeInfo)MetadataUtils.loadMD(MetaDataTypeList.FACADE, pk);
        return fi;
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk) {
        PermissionInfo pi = (PermissionInfo)MetadataUtils.loadMD(MetaDataTypeList.PERMISSION, pk);
        return pi;
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk) {
        if (pk != null && type != null) {
            try {
                IMetaDataLoader loader = MetadataUtils.getMDloader();
                return loader.get(type, pk);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private static IMetaDataLoader getMDloader() {
        IMetaDataLoader loader = ConfigMDUtil.isClient() ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ConfigMDUtil.getContext());
        return loader;
    }

    public static EntityObjectInfo loadMD(BOSObjectType type) {
        if (type != null) {
            try {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                return loader.loadMetameta(type);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private static void befroeSave(AbstractMetaDataValue metadata) {
        if (metadata instanceof UIObjectInfo) {
            ComponentCollection toolBars = ((UIObjectInfo)metadata).getToolbarsPanel().getComponents();
            for (int i = 0; i < toolBars.size(); ++i) {
                ComponentInfo toolBar = toolBars.get(i);
                toolBar.setParent(null);
            }
        }
    }

    private static void befroeSave(AbstractMetaDataValue[] metadata) {
        for (int i = 0; i < metadata.length; ++i) {
            MetadataUtils.befroeSave(metadata[i]);
        }
    }

    public static void saveMetadata(AbstractMetaDataValue metadata, String customizedSchemeID, Project depend) {
        MetadataUtils.befroeSave(metadata);
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        Project[] projects = new Project[]{};
        if (depend != null && depend.getDepend() != null && depend.getDepend().size() != 0) {
            projects = new Project[depend.getDepend().size()];
            projects = depend.getDepend().toArray(projects);
        }
        try {
            mdstore.saveMetadata(metadata, customizedSchemeID, projects);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void deleteMetadata(Project depend, IMetaDataPK pk, BOSObjectType type) {
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        try {
            mdstore.deleteMetadata(depend, pk, type);
        }
        catch (Exception e) {
            logger.error((Object)"MetadataUtils.deleteMetadata", (Throwable)e);
        }
    }

    public static void saveMetadata(AbstractMetaDataValue[] mds, String customizedSchemeID, Project depend) {
        MetadataUtils.befroeSave(mds);
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        Project[] projects = new Project[]{};
        if (depend != null && depend.getDepend() != null && depend.getDepend().size() != 0) {
            projects = new Project[depend.getDepend().size()];
            projects = depend.getDepend().toArray(projects);
        }
        try {
            mdstore.saveMetadata(mds, customizedSchemeID, projects);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static boolean isEmptyMD(AbstractMDValue amd) {
        if (amd == null) {
            return true;
        }
        IStateManager sm = amd.getStateManager();
        if (sm == null) {
            return true;
        }
        if (sm instanceof IProxyStateManager) {
            sm = ((IProxyStateManager)sm).getNoProxyDelegate();
        }
        return sm instanceof DynamicStateManager && ((DynamicStateManager)sm).isNull();
    }

    public static UIType getUIType(UIObjectInfo ui) {
        if (ui != null) {
            DataObjectCollection col = ui.getDataObjects();
            DataObjectInfo doInfo = null;
            for (int i = 0; i < col.size(); ++i) {
                doInfo = col.get(i);
                if (MetaDataTypeList.ENTITY.toString().equals(doInfo.getObjectType())) {
                    return UIType.EDITUI;
                }
                if (!MetaDataTypeList.JOINQUERY.toString().equals(doInfo.getObjectType())) continue;
                return UIType.LISTUI;
            }
            return MetadataUtils.getUIType(ui.getParent());
        }
        return null;
    }
}

