/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.updater;

import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class CustomizedUnitNodeInfoConverter {
    public static String coverter2xml(CustomizedUnitNodeInfo info) {
        Element cu;
        Document doc;
        if (info == null) {
            return "";
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><customizedUnit></customizedUnit>";
        SAXBuilder sb = new SAXBuilder();
        try {
            doc = sb.build((Reader)new StringReader(xml));
            cu = doc.getRootElement();
        }
        catch (Exception e) {
            return "";
        }
        Element type = new Element("type");
        type.setText(info.getType());
        cu.addContent((Content)type);
        Element uiType = new Element("uiType");
        uiType.setText(info.getUiType());
        cu.addContent((Content)uiType);
        Element templateNumber = new Element("templateNumber");
        templateNumber.setText(info.getTemplateNumber());
        cu.addContent((Content)templateNumber);
        Element packagepk = new Element("package");
        packagepk.setText(info.getPackagePK());
        cu.addContent((Content)packagepk);
        Element name = new Element("name");
        name.setText(info.getName());
        cu.addContent((Content)name);
        Element alias = new Element("alias");
        alias.setText(info.getAlias());
        cu.addContent((Content)alias);
        Element customizedType = new Element("customizedType");
        customizedType.setText(info.getCustomizedType());
        cu.addContent((Content)customizedType);
        Element entitys = new Element("entitys");
        CustomizedUnitNodeInfoConverter.createMetadataElements(entitys, info.getEntity(), "entity");
        cu.addContent((Content)entitys);
        Element facades = new Element("facades");
        CustomizedUnitNodeInfoConverter.createMetadataElements(facades, info.getFacade(), "facade");
        cu.addContent((Content)facades);
        Element enums = new Element("enums");
        CustomizedUnitNodeInfoConverter.createMetadataElements(enums, info.getEnums(), "enum");
        cu.addContent((Content)enums);
        Element querys = new Element("querys");
        CustomizedUnitNodeInfoConverter.createMetadataElements(querys, info.getQuery(), "query");
        cu.addContent((Content)querys);
        Element functions = new Element("functions");
        CustomizedUnitNodeInfoConverter.createMetadataElements(functions, info.getFunction(), "function");
        cu.addContent((Content)functions);
        Element exceptions = new Element("exceptions");
        CustomizedUnitNodeInfoConverter.createMetadataElements(exceptions, info.getException(), "exception");
        cu.addContent((Content)exceptions);
        Element uis = new Element("uis");
        cu.addContent((Content)uis);
        Element listuis = new Element("listuis");
        uis.addContent((Content)listuis);
        CustomizedUnitNodeInfoConverter.createMetadataElements(listuis, info.getUi().getListui(), "listui");
        Element edituis = new Element("edituis");
        uis.addContent((Content)edituis);
        CustomizedUnitNodeInfoConverter.createMetadataElements(edituis, info.getUi().getEditui(), "editui");
        Element otheruis = new Element("otheruis");
        uis.addContent((Content)otheruis);
        CustomizedUnitNodeInfoConverter.createMetadataElements(otheruis, info.getUi().getOtherui(), "otherui");
        Element webuis = new Element("webuis");
        cu.addContent((Content)webuis);
        Element weblistuis = new Element("weblistuis");
        webuis.addContent((Content)weblistuis);
        CustomizedUnitNodeInfoConverter.createMetadataElements(weblistuis, info.getWebUi().getListui(), "weblistui");
        Element webedituis = new Element("webedituis");
        webuis.addContent((Content)webedituis);
        CustomizedUnitNodeInfoConverter.createMetadataElements(webedituis, info.getWebUi().getEditui(), "webeditui");
        Element webotheruis = new Element("webotheruis");
        webuis.addContent((Content)webotheruis);
        CustomizedUnitNodeInfoConverter.createMetadataElements(webotheruis, info.getWebUi().getOtherui(), "webotherui");
        Element ruleSets = new Element("ruleSets");
        CustomizedUnitNodeInfoConverter.createMetadataElements(ruleSets, info.getRuleSet(), "ruleSet");
        cu.addContent((Content)ruleSets);
        Format format = Format.getRawFormat();
        format.setOmitDeclaration(true);
        format.setIndent("\t");
        XMLOutputter output = new XMLOutputter(format);
        return output.outputString(doc);
    }

    public static CustomizedUnitNodeInfo converter2Object(String xml) {
        Element webuis;
        Element cu;
        SAXBuilder sb = new SAXBuilder();
        CustomizedUnitNodeInfo cuInfo = new CustomizedUnitNodeInfo();
        try {
            Document doc = sb.build((Reader)new StringReader(xml));
            cu = doc.getRootElement();
        }
        catch (Exception e) {
            return cuInfo;
        }
        cuInfo.setType(CustomizedUnitNodeInfoConverter.getChildText(cu, "type"));
        cuInfo.setUiType(CustomizedUnitNodeInfoConverter.getChildText(cu, "uiType"));
        cuInfo.setTemplateNumber(CustomizedUnitNodeInfoConverter.getChildText(cu, "templateNumber"));
        cuInfo.setPackagePK(CustomizedUnitNodeInfoConverter.getChildText(cu, "package"));
        cuInfo.setName(CustomizedUnitNodeInfoConverter.getChildText(cu, "name"));
        cuInfo.setAlias(CustomizedUnitNodeInfoConverter.getChildText(cu, "alias"));
        cuInfo.setCustomizedType(CustomizedUnitNodeInfoConverter.getChildText(cu, "customizedType"));
        List node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "entitys", "entity");
        cuInfo.getEntity().addAll(node);
        node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "facades", "facade");
        cuInfo.getFacade().addAll(node);
        node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "enums", "enum");
        cuInfo.getEnums().addAll(node);
        node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "querys", "query");
        cuInfo.getQuery().addAll(node);
        node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "functions", "function");
        cuInfo.getFunction().addAll(node);
        node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "exceptions", "exception");
        cuInfo.getException().addAll(node);
        node = CustomizedUnitNodeInfoConverter.createMetadataList(cu, "ruleSets", "ruleSet");
        cuInfo.getRuleSet().addAll(node);
        Element uis = cu.getChild("uis");
        if (uis != null) {
            node = CustomizedUnitNodeInfoConverter.createMetadataList(uis, "listuis", "listui");
            cuInfo.getUi().getListui().addAll(node);
            node = CustomizedUnitNodeInfoConverter.createMetadataList(uis, "edituis", "editui");
            cuInfo.getUi().getEditui().addAll(node);
            node = CustomizedUnitNodeInfoConverter.createMetadataList(uis, "otheruis", "otherui");
            cuInfo.getUi().getOtherui().addAll(node);
        }
        if ((webuis = cu.getChild("webuis")) != null) {
            node = CustomizedUnitNodeInfoConverter.createMetadataList(webuis, "weblistuis", "weblistui");
            cuInfo.getWebUi().getListui().addAll(node);
            node = CustomizedUnitNodeInfoConverter.createMetadataList(webuis, "webedituis", "webeditui");
            cuInfo.getWebUi().getEditui().addAll(node);
            node = CustomizedUnitNodeInfoConverter.createMetadataList(webuis, "webotheruis", "webotherui");
            cuInfo.getWebUi().getOtherui().addAll(node);
        }
        return cuInfo;
    }

    private static void createMetadataElements(Element parent, List elements, String mdtype) {
        if (parent != null && elements != null) {
            for (CustomizedUnitNodeInfo.MetaDataInfo child : elements) {
                Element ele = new Element(mdtype);
                Element packagepk = new Element("package");
                packagepk.addContent(child.getPackage());
                Element name = new Element("name");
                name.addContent(child.getName());
                Element alias = new Element("alias");
                alias.addContent(child.getAlias());
                ele.addContent((Content)packagepk);
                ele.addContent((Content)name);
                ele.addContent((Content)alias);
                parent.addContent((Content)ele);
            }
        }
    }

    private static List createMetadataList(Element parent, String nodename, String mdtype) {
        Element node;
        ArrayList<CustomizedUnitNodeInfo.MetaDataInfo> mdList = new ArrayList<CustomizedUnitNodeInfo.MetaDataInfo>();
        if (parent != null && (node = parent.getChild(nodename)) != null) {
            List children = node.getChildren(mdtype);
            for (Element child : children) {
                CustomizedUnitNodeInfo.MetaDataInfo mdInfo = new CustomizedUnitNodeInfo.MetaDataInfo(CustomizedUnitNodeInfoConverter.getChildText(child, "package"), CustomizedUnitNodeInfoConverter.getChildText(child, "name"), CustomizedUnitNodeInfoConverter.getChildText(child, "alias"));
                mdList.add(mdInfo);
            }
        }
        return mdList;
    }

    private static String getChildText(Element parent, String name) {
        if (parent == null || StringUtils.isEmpty((String)name)) {
            return "";
        }
        Element child = parent.getChild(name);
        if (child == null) {
            return "";
        }
        return child.getTextTrim();
    }
}

