/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ConfigControllerFactory;
import org.apache.log4j.Logger;

public final class ConfigServiceUtils {
    private static final Logger logger = Logger.getLogger(ConfigServiceUtils.class);

    public static String getUserConfigData(String key) {
        try {
            return ConfigControllerFactory.getRemoteInstance().getUserConfigData(key);
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.getUserConfigData(String key)", (Throwable)e);
            return null;
        }
    }

    public static String getUserConfigData(String key, IMetaDataPK UIPK) {
        try {
            return ConfigControllerFactory.getRemoteInstance().getUserConfigData(key, UIPK.getFullName());
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.getUserConfigData(String key, IMetaDataPK UIPK)", (Throwable)e);
            return null;
        }
    }

    public static void saveUserConfigData(String key, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveUserConfigData(key, value);
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.saveUserConfigData(String key, String value)", (Throwable)e);
        }
    }

    public static void saveUserConfigData(String key, IMetaDataPK UIPK, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveUserConfigData(key, UIPK.getFullName(), value);
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.saveUserConfigData(String key, IMetaDataPK UIPK, String value)", (Throwable)e);
        }
    }

    public static String getDCConfigData(String key) {
        try {
            return ConfigControllerFactory.getRemoteInstance().getDCConfigData(key);
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.getDCConfigData(String key)", (Throwable)e);
            return null;
        }
    }

    public static String getDCConfigData(String key, CoreUI ui) {
        try {
            return ConfigControllerFactory.getRemoteInstance().getDCConfigData(key, ui.getMetaDataPK().getFullName());
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.getDCConfigData(String key, CoreUI ui)", (Throwable)e);
            return null;
        }
    }

    public static void saveDCConfigData(String key, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveDCConfigData(key, value);
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.saveDCConfigData(String key, String value)", (Throwable)e);
        }
    }

    public static void saveDCConfigData(String key, CoreUI ui, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveDCConfigData(key, ui.getMetaDataPK().getFullName(), value);
        }
        catch (BOSException e) {
            logger.error((Object)"ConfigServiceUtils.saveDCConfigData(String key, CoreUI ui, String value)", (Throwable)e);
        }
    }
}

