/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ActionRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.action.BaseAction;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.webclient.editor.webui.designer.CommonEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ContainerEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebEditPartFactory;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebPropertyDescriptorUI;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebDataBindAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebDataGridAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebEditTabPaneAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebMoveAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.layout.LayoutManager;
import com.kingdee.eas.ep.webclient.editor.webui.designer.request.SmartLayoutDirectEditRequest;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebItemCollection;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.eas.ep.webclient.util.WebUIEditorHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWebEditPartViewer
extends AbstractEditPartViewer {
    protected JMenu editEntryPro = null;
    protected LayoutManager layoutManager;

    public AbstractWebEditPartViewer(WebTreeNode node, Dimension size, WebContext context, LayoutManager layoutManager) {
        super((IContext)context);
        this.setName(node.getName());
        layoutManager.setViewer((JPanel)((Object)this));
        this.layoutManager = layoutManager;
        if (size != null) {
            this.setBounds(0, 0, size.width, size.height);
            this.initCavansSize.height = size.height;
            this.initCavansSize.width = size.width;
        }
        this.setLayout(layoutManager);
        this.add((Component)this.maskPanel);
        this.context = context;
        this.context.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.commandStack = context.getCommandStack();
        this.node = node;
        this.factory = new WebEditPartFactory(node, this);
        this.partManager = new EditPartManager();
        this.createEditPart();
        this.initPopupmenu();
        this.createActions();
    }

    protected void perform_editComponent(EditPart part) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("viewer", this);
        if (part != null) {
            uiContext.put("edit type", "edit ctrl");
            uiContext.put("item adapter", part.getModel());
        } else {
            uiContext.put("edit type", "edit viewer");
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WebPropertyDescriptorUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (Exception ex) {
            ExceptionHandler.handleError((Component)((Object)this), (Exception)ex, (String)"\u6253\u5f00\u5c5e\u6027\u9875\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    protected void initPopupmenu() {
        this.popMenu = new KDPopupMenu();
        this.showContainerPop = new JCheckBoxMenuItem("\u663e\u793a\u5bb9\u5668\u63d0\u793a");
        this.showContainerPop.setSelected(this.context.isShowContainer());
        this.showContainerPop.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ((WebContext)AbstractWebEditPartViewer.this.getContext()).setShowContainer(AbstractWebEditPartViewer.this.showContainerPop.isSelected());
            }
        });
        this.popMenu.add((JMenuItem)this.showContainerPop);
        this.popMenu.addSeparator();
        this.editEntryPro = new JMenu("\u5206\u5f55\u5c5e\u6027");
        this.popMenu.add((JMenuItem)this.editEntryPro);
    }

    public Map getItemAdapterMap() {
        return this.itemAdapterMap;
    }

    public ComponentTreeNode getNode() {
        return (WebTreeNode)this.node;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void addComponent2MaskPanel(Component comp, Object constraint) {
        this.add(comp, constraint, 0);
    }

    public void addComponent2ComponentPanel(Component comp, Object constraint) {
        int index = -1;
        Component[] cs = this.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != this.maskPanel) continue;
            index = i;
            break;
        }
        this.add(comp, constraint, index + 1);
    }

    public void removeComponent(Component comp) {
        this.remove(comp);
        this.layoutManager.removeLayoutComponent(comp);
    }

    public void createEditPart() {
        if (this.factory == null) {
            logger.info((Object)"factory is null...");
            throw new NullPointerException("factory is null...");
        }
        Iterator iter = this.node.getConfigureItems().iterator();
        while (iter.hasNext()) {
            EditPart part;
            WebItemInfoAdapter item = new WebItemInfoAdapter((WebItemInfo)iter.next());
            if (WebEditorHelper.contains(this.partManager, (WebItemInfo)item.getItem()) || (part = this.factory.createEditPart((Object)item)) == null) continue;
            this.partManager.add(part);
            this.itemAdapterMap.put(item.getItem(), item);
        }
        WebEditorHelper.retainAll(this.partManager, this.itemAdapterMap, (WebItemCollection)this.node.getConfigureItems(), this);
        this.revalidate();
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        BaseAction action = new WebDataGridAction((EditPartViewer)this);
        registry.registerAction(action);
        this.editKDTablePop = this.popMenu.add((Action)action);
        this.editKDTablePop.setText("\u7f16\u8f91\u8868\u4fe1\u606f");
        action.addRelateComponent((JComponent)this.editKDTablePop);
        action = new WebEditTabPaneAction((EditPartViewer)this);
        registry.registerAction(action);
        this.editTabPanePop = this.popMenu.add((Action)action);
        this.editTabPanePop.setText("\u7f16\u8f91\u9875\u7b7e");
        action.addRelateComponent((JComponent)this.editTabPanePop);
        action = new WebDataBindAction((EditPartViewer)this);
        registry.registerAction(action);
        this.dataBindPop = this.popMenu.add((Action)action);
        this.dataBindPop.setText("\u6570\u636e\u7ed1\u5b9a");
        action.addRelateComponent((JComponent)this.dataBindPop);
        this.moveAction = new WebMoveAction((EditPartViewer)this);
    }

    protected void updateEntryProperty() {
        this.editEntryPro.removeAll();
        CommonEditPart editPart = (CommonEditPart)this.getSelection();
        if (editPart == null) {
            this.editEntryPro.setEnabled(false);
            return;
        }
        WebItemInfoAdapter adapter = (WebItemInfoAdapter)((Object)editPart.getModel());
        if (adapter != null && adapter.getItem().getComponent() != null && ("com.kingdee.bos.ctrl.web.EditDataGrid".equalsIgnoreCase(adapter.getItem().getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equalsIgnoreCase(adapter.getItem().getComponent().getClassType()))) {
            int count = this.node.getChildCount();
            for (int i = 0; i < count; ++i) {
                WebTreeNode child = (WebTreeNode)((Object)this.node.getChildAt(i));
                if (!adapter.getName().equals(child.getName())) continue;
                WebItemCollection col = (WebItemCollection)child.getConfigureItems();
                int size = col.size();
                for (int j = 0; j < size; ++j) {
                    final WebItemInfo bi = (WebItemInfo)col.get(j);
                    JMenuItem item = new JMenuItem(StringUtils.isEmpty((String)bi.getAlias()) ? bi.getName() : bi.getAlias());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AbstractWebEditPartViewer.this.showPropertyDescriptorUI(bi);
                        }
                    });
                    this.editEntryPro.add(item);
                }
                break;
            }
            this.editEntryPro.setEnabled(true);
        } else {
            this.editEntryPro.setEnabled(false);
        }
    }

    public void showPropertyDescriptorUI(WebItemInfo item) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            uiContext.put("edit type", "edit entry pro");
            uiContext.put("viewer", this);
            uiContext.put("item", item);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WebPropertyDescriptorUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (Exception ex) {
            ExceptionHandler.handleError((Component)((Object)this), (Exception)ex, (String)"\u6253\u5f00\u5c5e\u6027\u9875\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    protected void createField(int x, int y) {
    }

    public EditPartViewer getParentViewer() {
        return (AbstractWebEditPartViewer)this.parentViewer;
    }

    public IContext getContext() {
        return (WebContext)this.context;
    }

    public List getCurrentMouseInInfo() {
        this.mouseInInfo.clear();
        EditPart part = WebEditorHelper.getEditPartByPoint(this.x, this.y, this.partManager);
        if (part != null && part.getModel() instanceof WebItemInfoAdapter) {
            WebItemInfo item = (WebItemInfo)((WebItemInfoAdapter)((Object)part.getModel())).getItem();
            ComponentInfo roundInfo = WebUIEditorHelper.getRoundedComponent(item.getComponent());
            if (roundInfo != null && "com.kingdee.bos.ctrl.web.LabelContainer".equalsIgnoreCase(roundInfo.getClassType())) {
                this.mouseInInfo.add("\u6807\u7b7e\u540d\u79f0\uff1a" + roundInfo.getName());
                this.mouseInInfo.add("\u6807\u7b7e\u6587\u5b57\uff1a" + item.getLabel());
                this.mouseInInfo.add("\u6807\u7b7e\u6587\u5b57\u957f\u5ea6\uff1a" + item.getLabelLength());
            } else if ("com.kingdee.bos.ctrl.web.Label".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Button".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.RadioButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.CheckBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Container".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Composite".equals(roundInfo.getClassType())) {
                this.mouseInInfo.add("\u6807\u7b7e\u6587\u5b57\uff1a" + item.getLabel());
            }
            Object constraint = ((WebItemInfoAdapter)((Object)part.getModel())).getConstranit();
            this.mouseInInfo.add("\u63a7\u4ef6\u540d\u79f0\uff1a" + ((WebItemInfoAdapter)((Object)part.getModel())).getName());
            this.mouseInInfo.add("\u5c5e\u4e8e\u9759\u6001\u5143\u6570\u636e\uff1a" + (item.getComponent().isConfigured() ? "\u5426" : "\u662f"));
            this.mouseInInfo.add("\u7ea6\u675f\uff1a" + constraint == null ? "" : constraint.toString());
            return this.mouseInInfo;
        }
        return this.mouseInInfo;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showcontainer")) {
            this.showContainerPop.setSelected((Boolean)evt.getNewValue());
        }
    }

    public AbstractWebEditPartViewer getSelectionContainerViewer() {
        ArrayList viewers = new ArrayList();
        WebEditorHelper.getAllViewer(viewers, (Component)this.getContext().getRootViewer());
        int size = viewers.size();
        for (int i = size - 1; i >= 0; --i) {
            AbstractWebEditPartViewer viewer = (AbstractWebEditPartViewer)((Object)viewers.get(i));
            EditPart selected = viewer.getSelection();
            if (selected instanceof ContainerEditPart) {
                ContainerEditPart container = (ContainerEditPart)selected;
                if (container.getInnerViewer() == null) continue;
                return (AbstractWebEditPartViewer)container.getInnerViewer();
            }
            if (!(selected instanceof CommonEditPart)) continue;
            return (AbstractWebEditPartViewer)selected.getViewer();
        }
        return null;
    }

    public AbstractWebEditPartViewer getMainPanelViewer() {
        AbstractWebEditPartViewer viewer = this.getViewerByNameAndClassType("rootForm", "com.kingdee.bos.ctrl.web.Form");
        if (viewer == null) {
            viewer = this.getViewerByNameAndClassType("rootFreePanel", "com.kingdee.bos.ctrl.web.FreePanel");
        }
        return viewer;
    }

    public AbstractWebEditPartViewer getViewerByNameAndClassType(String name, String classType) {
        ArrayList viewers = new ArrayList();
        WebEditorHelper.getAllViewer(viewers, (Component)this.getContext().getRootViewer());
        int size = viewers.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo cInfo;
            Object obj = ((AbstractWebEditPartViewer)((Object)viewers.get(i))).getNode().getUserObject();
            if (!(obj instanceof ComponentInfo) || !classType.equals((cInfo = (ComponentInfo)obj).getClassType()) || !cInfo.getName().equals(name)) continue;
            return (AbstractWebEditPartViewer)((Object)viewers.get(i));
        }
        return null;
    }

    public Layout getViewerLayout() {
        Object obj = this.node.getUserObject();
        if (obj instanceof ComponentInfo) {
            ComponentInfo container = (ComponentInfo)obj;
            return LayoutConverter.convertToLayoutObj((LayoutInfo)container.getLayoutInfo());
        }
        return new XYLayout();
    }

    protected Request getDirectEditRequest(EditPart source, int x, int y) {
        return new SmartLayoutDirectEditRequest(source, this, x, y);
    }
}

