/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.util;

import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class ConstraintUtil {
    public static Object clone(Object constraint) {
        if (constraint instanceof WebLayoutData) {
            return ((WebLayoutData)constraint).clone();
        }
        if (constraint instanceof SmartLayoutData) {
            return ((SmartLayoutData)constraint).clone();
        }
        if (constraint instanceof Integer) {
            return new Integer((Integer)constraint);
        }
        return constraint;
    }

    public static Object createConstraint(ComponentInfo parent, Dimension size) {
        return ConstraintUtil.createConstraint(parent, size, new Point(30, 60));
    }

    public static Object createConstraint(ComponentInfo parent, Dimension size, Point point) {
        if (size == null) {
            size = new Dimension(270, 21);
        }
        if (parent != null) {
            LayoutInfo layout = parent.getLayoutInfo();
            if (layout == null) {
                return null;
            }
            String layoutType = layout.getType();
            if ("SmartLayout".equalsIgnoreCase(layoutType)) {
                return new SmartLayoutData(point.x, point.y, size.width, size.height, 0);
            }
            if ("WebLayout".equalsIgnoreCase(layoutType)) {
                return new WebLayoutData(WebLayoutData.Unit.absolute((int)size.width), size.height);
            }
            if ("WebToolBarLayout".equalsIgnoreCase(layoutType)) {
                ComponentCollection col = parent.getComponents();
                int max = 0;
                int len = col.size();
                for (int i = 0; i < len; ++i) {
                    Object cons = col.get(i).getConstraint();
                    if (!(cons instanceof Integer) || (Integer)cons <= max) continue;
                    max = (Integer)cons;
                }
                return new Integer(max + 1);
            }
        }
        return null;
    }

    public static Object createConstraint(ComponentInfo parent, Object oldConstraint) {
        Dimension size = null;
        if (oldConstraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)oldConstraint;
            size = new Dimension(sld.width, sld.height);
        } else if (oldConstraint instanceof Rectangle) {
            size = new Dimension(((Rectangle)oldConstraint).getSize());
        } else if (oldConstraint instanceof WebLayoutData) {
            WebLayoutData wld = (WebLayoutData)oldConstraint;
            size = wld.width.isPercentage ? new Dimension(170, wld.height) : new Dimension((int)wld.width.number, wld.height);
        }
        return ConstraintUtil.createConstraint(parent, size, new Point(10, 10));
    }

    public static Object createConstraint(ComponentInfo parent, Object oldConstraint, Point suggestPlace) {
        Dimension size = null;
        if (oldConstraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)oldConstraint;
            size = new Dimension(sld.width, sld.height);
        } else if (oldConstraint instanceof Rectangle) {
            size = new Dimension(((Rectangle)oldConstraint).getSize());
        } else if (oldConstraint instanceof WebLayoutData) {
            WebLayoutData wld = (WebLayoutData)oldConstraint;
            size = wld.width.isPercentage ? new Dimension(170, wld.height) : new Dimension((int)wld.width.number, wld.height);
        }
        return ConstraintUtil.createConstraint(parent, size, suggestPlace);
    }

    public static Dimension translateConstraint2Dimension(Object constraint, Dimension parentSize) {
        if (constraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)constraint;
            return new Dimension(sld.width, sld.height);
        }
        if (constraint instanceof Rectangle) {
            return new Dimension(((Rectangle)constraint).getSize());
        }
        if (constraint instanceof WebLayoutData) {
            WebLayoutData wld = (WebLayoutData)constraint;
            if (wld.width.isPercentage) {
                return new Dimension((int)((float)parentSize.width * wld.width.number), wld.height);
            }
            return new Dimension((int)wld.width.number, wld.height);
        }
        return new Dimension(0, 0);
    }

    public static Rectangle translateConstraint2Rectangle(Object constraint, Dimension parentSize) {
        if (constraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)constraint;
            return new Rectangle(sld.x, sld.y, sld.width, sld.height);
        }
        if (constraint instanceof Rectangle) {
            return new Rectangle((Rectangle)constraint);
        }
        if (constraint instanceof WebLayoutData) {
            WebLayoutData wld = (WebLayoutData)constraint;
            if (wld.width.isPercentage) {
                return new Rectangle((int)((float)parentSize.width * wld.width.number), wld.height);
            }
            return new Rectangle((int)wld.width.number, wld.height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static void resetConstraintByRectangle(Object constraint, Rectangle rect) {
        if (constraint == null || rect == null) {
            return;
        }
        if (constraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)constraint;
            sld.x = rect.x;
            sld.y = rect.y;
            sld.width = rect.width;
            sld.height = rect.height;
        } else if (constraint instanceof Rectangle) {
            ((Rectangle)constraint).setBounds(rect);
        } else if (constraint instanceof WebLayoutData) {
            WebLayoutData.Unit width;
            WebLayoutData wld = (WebLayoutData)constraint;
            wld.width = width = WebLayoutData.Unit.parse((String)String.valueOf(rect.width));
            wld.height = rect.height;
        }
    }

    public static boolean isConstraintDifferent(Object constraint, Rectangle rect, Dimension parentSize) {
        if (constraint == null || rect == null) {
            return false;
        }
        if (constraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)constraint;
            if (sld.x != rect.x || sld.y != rect.y || sld.width != rect.width || sld.height != rect.height) {
                return true;
            }
        } else {
            if (constraint instanceof Rectangle) {
                return !((Rectangle)constraint).equals(rect);
            }
            if (constraint instanceof WebLayoutData) {
                WebLayoutData wld = (WebLayoutData)constraint;
                Rectangle size = ConstraintUtil.translateConstraint2Rectangle(wld, parentSize);
                if (size.width != rect.width || size.height != rect.height) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getStoreConstraint(Object constraint) {
        if (constraint instanceof SmartLayoutData) {
            SmartLayoutData sld = (SmartLayoutData)constraint;
            return "SmartLayoutData$" + sld.toString();
        }
        if (constraint instanceof WebLayoutData) {
            WebLayoutData wld = (WebLayoutData)constraint;
            return "WebLayoutData$" + wld.toString();
        }
        if (constraint instanceof Integer) {
            return "WebToolBarLayoutData$" + constraint.toString();
        }
        return "";
    }
}

