/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.util;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ui.WebButton;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ui.WebSeparator;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Hashtable;

public final class ModelUtils {
    private static HashSet notAllowPercentage = new HashSet();
    private static HashSet notAllowHeight = new HashSet();
    private static HashSet notAllowMove = new HashSet();
    private static HashSet allowToolBarComponent = new HashSet();
    private static Hashtable defaultSize;
    public static final String DATABASE_EDITUI = "dataBase_EditUI";
    public static final String DATABASE_LISTUI = "dataBase_ListUI";
    public static final String TREEBASE_EDITUI = "treeBase_EditUI";
    public static final String TREEBASE_LISTUI = "treeBase_ListUI";
    public static final String TREEDETAIL_EDITUI = "treeDetail_EditUI";
    public static final String TREEDETAIL_LISTUI = "treeDetail_ListUI";
    public static final String BILL_EDITUI = "bill_EditUI";
    public static final String BILL_LISTUI = "bill_ListUI";
    private static final String FRAMEWORK_BILLEDITUI = "com.kingdee.eas.framework.web.BillEditUI";
    private static final String FRAMEWORK_BILLLISTUI = "com.kingdee.eas.framework.web.BillListUI";
    private static final String FRAMEWORK_EDITUI = "com.kingdee.eas.framework.web.EditUI";
    private static final String FRAMEWORK_LISTUI = "com.kingdee.eas.framework.web.ListUI";
    private static final String FRAMEWORK_TREEBASEEDITUI = "com.kingdee.eas.framework.web.TreeBaseEditUI";
    private static final String FRAMEWORK_TREEBASELISTUI = "com.kingdee.eas.framework.web.TreeBaseListUI";
    private static final String FRAMEWORK_TREEDETAILEDITUI = "com.kingdee.eas.framework.web.TreeDetailEditUI";
    private static final String FRAMEWORK_TREEDETAILLISTUI = "com.kingdee.eas.framework.web.TreeDetailListUI";

    private ModelUtils() {
    }

    public static boolean allowWidthPercentage(String classType) {
        return !notAllowPercentage.contains(classType);
    }

    public static boolean allowHeight(String classType) {
        return !notAllowHeight.contains(classType);
    }

    public static boolean allowMove(String classType) {
        return !notAllowMove.contains(classType);
    }

    public static boolean allowToolBarComponent(String classType) {
        return allowToolBarComponent.contains(classType);
    }

    public static Dimension getDefaultSize(String controlType) {
        Object obj = defaultSize.get(controlType);
        if (obj == null) {
            return new Dimension(270, 19);
        }
        return (Dimension)obj;
    }

    public static String getUIType(WebUIObjectInfo uiModel) {
        if (uiModel == null) {
            return null;
        }
        for (WebUIObjectInfo parent = uiModel.getParent(); parent != null; parent = parent.getParent()) {
            String fullName = parent.getFullName();
            if (FRAMEWORK_BILLEDITUI.equals(fullName)) {
                return BILL_EDITUI;
            }
            if (FRAMEWORK_BILLLISTUI.equals(fullName)) {
                return BILL_LISTUI;
            }
            if (FRAMEWORK_EDITUI.equals(fullName)) {
                return DATABASE_EDITUI;
            }
            if (FRAMEWORK_LISTUI.equals(fullName)) {
                return DATABASE_LISTUI;
            }
            if (FRAMEWORK_TREEBASEEDITUI.equals(fullName)) {
                return TREEBASE_EDITUI;
            }
            if (FRAMEWORK_TREEBASELISTUI.equals(fullName)) {
                return TREEBASE_LISTUI;
            }
            if (FRAMEWORK_TREEDETAILEDITUI.equals(fullName)) {
                return TREEDETAIL_EDITUI;
            }
            if (!FRAMEWORK_TREEDETAILLISTUI.equals(fullName)) continue;
            return TREEDETAIL_LISTUI;
        }
        return null;
    }

    public static boolean isListUI(WebUIObjectInfo uiModel) {
        String uiType = ModelUtils.getUIType(uiModel);
        return BILL_EDITUI.equals(uiType) || DATABASE_EDITUI.equals(uiType) || TREEBASE_EDITUI.equals(uiType) || TREEDETAIL_EDITUI.equals(uiType);
    }

    public static boolean isEditUI(WebUIObjectInfo uiModel) {
        String uiType = ModelUtils.getUIType(uiModel);
        return BILL_EDITUI.equals(uiType) || DATABASE_EDITUI.equals(uiType) || TREEBASE_EDITUI.equals(uiType) || TREEDETAIL_EDITUI.equals(uiType);
    }

    static {
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.Button");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.LabelContainer");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.TextField");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.TextArea");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.ComboBox");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.EnumCombo");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.CheckBox");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.CalcNumberField");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.DateTimeField");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.DateField");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.TimeField");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.DrawImage");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.CheckBox");
        notAllowPercentage.add("com.kingdee.bos.ctrl.web.SimpleHtmlEditor");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.ComboBox");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.EnumCombo");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.ToolBar");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.CalcNumberField");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.DateTimeField");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.DateField");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.TimeField");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.CheckBox");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.TitleSection");
        notAllowHeight.add("com.kingdee.bos.ctrl.web.Line");
        notAllowMove.add("com.kingdee.bos.ctrl.web.Form");
        allowToolBarComponent.add("com.kingdee.bos.ctrl.web.Button");
        allowToolBarComponent.add("com.kingdee.bos.ctrl.web.Separator");
        allowToolBarComponent.add("com.kingdee.bos.ctrl.web.ComboBox");
        allowToolBarComponent.add("com.kingdee.bos.ctrl.web.EnumCombo");
        defaultSize = new Hashtable();
        defaultSize.put(WebButton.class.getName(), new Dimension(73, 21));
        defaultSize.put(KDComboBox.class.getName(), new Dimension(170, 19));
        defaultSize.put(WebSeparator.class.getName(), new Dimension(8, 15));
    }
}

