/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.ep.analysis.Analyzer;
import org.apache.lucene.ep.analysis.KeywordTokenizer;
import org.apache.lucene.ep.analysis.TokenStream;
import org.apache.lucene.ep.analysis.Tokenizer;

public class KeywordAnalyzer
extends Analyzer {
    public KeywordAnalyzer() {
        this.setOverridesTokenStreamMethod(KeywordAnalyzer.class);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new KeywordTokenizer(reader);
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        Tokenizer tokenizer = (Tokenizer)this.getPreviousTokenStream();
        if (tokenizer == null) {
            tokenizer = new KeywordTokenizer(reader);
            this.setPreviousTokenStream(tokenizer);
        } else {
            tokenizer.reset(reader);
        }
        return tokenizer;
    }
}

