/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.index.TermEnum;

public abstract class AbstractAllTermDocs
implements TermDocs {
    protected int maxDoc;
    protected int doc = -1;

    protected AbstractAllTermDocs(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    @Override
    public void seek(Term term) throws IOException {
        if (term != null) {
            throw new UnsupportedOperationException();
        }
        this.doc = -1;
    }

    @Override
    public void seek(TermEnum termEnum) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public int freq() {
        return 1;
    }

    @Override
    public boolean next() throws IOException {
        return this.skipTo(this.doc + 1);
    }

    @Override
    public int read(int[] docs, int[] freqs) throws IOException {
        int length = docs.length;
        int i = 0;
        while (i < length && this.doc < this.maxDoc) {
            if (!this.isDeleted(this.doc)) {
                docs[i] = this.doc;
                freqs[i] = 1;
                ++i;
            }
            ++this.doc;
        }
        return i;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        this.doc = target;
        while (this.doc < this.maxDoc) {
            if (!this.isDeleted(this.doc)) {
                return true;
            }
            ++this.doc;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public abstract boolean isDeleted(int var1);
}

