/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.ep.index.DocFieldConsumer;
import org.apache.lucene.ep.index.DocFieldConsumerPerField;
import org.apache.lucene.ep.index.DocFieldConsumerPerThread;
import org.apache.lucene.ep.index.DocFieldConsumersPerField;
import org.apache.lucene.ep.index.DocFieldConsumersPerThread;
import org.apache.lucene.ep.index.DocFieldProcessorPerThread;
import org.apache.lucene.ep.index.DocumentsWriter;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.util.ArrayUtil;

final class DocFieldConsumers
extends DocFieldConsumer {
    final DocFieldConsumer one;
    final DocFieldConsumer two;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    int allocCount;

    public DocFieldConsumers(DocFieldConsumer one, DocFieldConsumer two) {
        this.one = one;
        this.two = two;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.one.setFieldInfos(fieldInfos);
        this.two.setFieldInfos(fieldInfos);
    }

    @Override
    public void flush(Map threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap oneThreadsAndFields = new HashMap();
        HashMap twoThreadsAndFields = new HashMap();
        for (Map.Entry entry : threadsAndFields.entrySet()) {
            DocFieldConsumersPerThread perThread = (DocFieldConsumersPerThread)entry.getKey();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            HashSet<DocFieldConsumerPerField> oneFields = new HashSet<DocFieldConsumerPerField>();
            HashSet<DocFieldConsumerPerField> twoFields = new HashSet<DocFieldConsumerPerField>();
            while (fieldsIt.hasNext()) {
                DocFieldConsumersPerField perField = (DocFieldConsumersPerField)fieldsIt.next();
                oneFields.add(perField.one);
                twoFields.add(perField.two);
            }
            oneThreadsAndFields.put(perThread.one, oneFields);
            twoThreadsAndFields.put(perThread.two, twoFields);
        }
        this.one.flush(oneThreadsAndFields, state);
        this.two.flush(twoThreadsAndFields, state);
    }

    @Override
    public void closeDocStore(SegmentWriteState state) throws IOException {
        try {
            this.one.closeDocStore(state);
        }
        finally {
            this.two.closeDocStore(state);
        }
    }

    @Override
    public void abort() {
        try {
            this.one.abort();
        }
        finally {
            this.two.abort();
        }
    }

    @Override
    public boolean freeRAM() {
        boolean any = this.one.freeRAM();
        return any |= this.two.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) throws IOException {
        return new DocFieldConsumersPerThread(docFieldProcessorPerThread, this, this.one.addThread(docFieldProcessorPerThread), this.two.addThread(docFieldProcessorPerThread));
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.getNextSize(this.allocCount)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    synchronized void freePerDoc(PerDoc perDoc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = perDoc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        DocumentsWriter.DocWriter one;
        DocumentsWriter.DocWriter two;

        PerDoc() {
        }

        @Override
        public long sizeInBytes() {
            return this.one.sizeInBytes() + this.two.sizeInBytes();
        }

        @Override
        public void finish() throws IOException {
            try {
                try {
                    this.one.finish();
                }
                finally {
                    this.two.finish();
                }
            }
            finally {
                DocFieldConsumers.this.freePerDoc(this);
            }
        }

        @Override
        public void abort() {
            try {
                try {
                    this.one.abort();
                }
                finally {
                    this.two.abort();
                }
            }
            finally {
                DocFieldConsumers.this.freePerDoc(this);
            }
        }
    }
}

