/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.document.CompressionTools;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.Fieldable;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.FieldsReader;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.IndexInput;
import org.apache.lucene.ep.store.IndexOutput;
import org.apache.lucene.ep.store.RAMOutputStream;

final class FieldsWriter {
    static final byte FIELD_IS_TOKENIZED = 1;
    static final byte FIELD_IS_BINARY = 2;
    static final byte FIELD_IS_COMPRESSED = 4;
    static final int FORMAT = 0;
    static final int FORMAT_VERSION_UTF8_LENGTH_IN_BYTES = 1;
    static final int FORMAT_CURRENT = 1;
    private FieldInfos fieldInfos;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;
    private boolean doClose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsWriter(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        boolean success = false;
        String fieldsName = segment + "." + "fdt";
        try {
            this.fieldsStream = d.createOutput(fieldsName);
            this.fieldsStream.writeInt(1);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
                try {
                    d.deleteFile(fieldsName);
                }
                catch (Throwable throwable) {}
            }
        }
        success = false;
        String indexName = segment + "." + "fdx";
        try {
            this.indexStream = d.createOutput(indexName);
            this.indexStream.writeInt(1);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
                try {
                    d.deleteFile(fieldsName);
                }
                catch (Throwable throwable) {}
                try {
                    d.deleteFile(indexName);
                }
                catch (Throwable throwable) {}
            }
        }
        this.doClose = true;
    }

    FieldsWriter(IndexOutput fdx, IndexOutput fdt, FieldInfos fn) {
        this.fieldInfos = fn;
        this.fieldsStream = fdt;
        this.indexStream = fdx;
        this.doClose = false;
    }

    void setFieldsStream(IndexOutput stream) {
        this.fieldsStream = stream;
    }

    void flushDocument(int numStoredFields, RAMOutputStream buffer) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(numStoredFields);
        buffer.writeTo(this.fieldsStream);
    }

    void skipDocument() throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(0);
    }

    void flush() throws IOException {
        this.indexStream.flush();
        this.fieldsStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws IOException {
        block19: {
            if (this.doClose) {
                try {
                    if (this.fieldsStream == null) break block19;
                    try {
                        this.fieldsStream.close();
                    }
                    finally {
                        this.fieldsStream = null;
                    }
                }
                catch (IOException ioe) {
                    try {}
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw ioe;
                }
                finally {
                    if (this.indexStream != null) {
                        try {
                            this.indexStream.close();
                        }
                        finally {
                            this.indexStream = null;
                        }
                    }
                }
            }
        }
    }

    final void writeField(FieldInfo fi, Fieldable field) throws IOException {
        boolean disableCompression = field instanceof FieldsReader.FieldForMerge;
        this.fieldsStream.writeVInt(fi.number);
        byte bits = 0;
        if (field.isTokenized()) {
            bits = (byte)(bits | 1);
        }
        if (field.isBinary()) {
            bits = (byte)(bits | 2);
        }
        if (field.isCompressed()) {
            bits = (byte)(bits | 4);
        }
        this.fieldsStream.writeByte(bits);
        if (field.isCompressed()) {
            int offset;
            int len;
            byte[] data;
            if (disableCompression) {
                data = field.getBinaryValue();
                assert (data != null);
                len = field.getBinaryLength();
                offset = field.getBinaryOffset();
            } else {
                if (field.isBinary()) {
                    data = CompressionTools.compress(field.getBinaryValue(), field.getBinaryOffset(), field.getBinaryLength());
                } else {
                    byte[] x = field.stringValue().getBytes("UTF-8");
                    data = CompressionTools.compress(x, 0, x.length);
                }
                len = data.length;
                offset = 0;
            }
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, offset, len);
        } else if (field.isBinary()) {
            byte[] data = field.getBinaryValue();
            int len = field.getBinaryLength();
            int offset = field.getBinaryOffset();
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, offset, len);
        } else {
            this.fieldsStream.writeString(field.stringValue());
        }
    }

    final void addRawDocuments(IndexInput stream, int[] lengths, int numDocs) throws IOException {
        long position;
        long start = position = this.fieldsStream.getFilePointer();
        for (int i = 0; i < numDocs; ++i) {
            this.indexStream.writeLong(position);
            position += (long)lengths[i];
        }
        this.fieldsStream.copyBytes(stream, position - start);
        assert (this.fieldsStream.getFilePointer() == position);
    }

    final void addDocument(Document doc) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int storedCount = 0;
        for (Fieldable field : doc.getFields()) {
            if (!field.isStored()) continue;
            ++storedCount;
        }
        this.fieldsStream.writeVInt(storedCount);
        for (Fieldable field : doc.getFields()) {
            if (!field.isStored()) continue;
            this.writeField(this.fieldInfos.fieldInfo(field.name()), field);
        }
    }
}

