/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.FieldSelector;
import org.apache.lucene.ep.document.FieldSelectorResult;
import org.apache.lucene.ep.index.CompoundFileWriter;
import org.apache.lucene.ep.index.CorruptIndexException;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.FieldsReader;
import org.apache.lucene.ep.index.FieldsWriter;
import org.apache.lucene.ep.index.FormatPostingsDocsConsumer;
import org.apache.lucene.ep.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.ep.index.FormatPostingsFieldsWriter;
import org.apache.lucene.ep.index.FormatPostingsPositionsConsumer;
import org.apache.lucene.ep.index.FormatPostingsTermsConsumer;
import org.apache.lucene.ep.index.IndexFileNames;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.IndexWriter;
import org.apache.lucene.ep.index.MergePolicy;
import org.apache.lucene.ep.index.SegmentMergeInfo;
import org.apache.lucene.ep.index.SegmentMergeQueue;
import org.apache.lucene.ep.index.SegmentReader;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.index.TermFreqVector;
import org.apache.lucene.ep.index.TermPositions;
import org.apache.lucene.ep.index.TermVectorsReader;
import org.apache.lucene.ep.index.TermVectorsWriter;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.IndexInput;
import org.apache.lucene.ep.store.IndexOutput;

final class SegmentMerger {
    static final byte[] NORMS_HEADER = new byte[]{78, 82, 77, -1};
    private Directory directory;
    private String segment;
    private int termIndexInterval = 128;
    private List readers = new ArrayList();
    private FieldInfos fieldInfos;
    private int mergedDocs;
    private final CheckAbort checkAbort;
    private boolean mergeDocStores;
    private static final int MAX_RAW_MERGE_DOCS = 4192;
    private SegmentReader[] matchingSegmentReaders;
    private int[] rawDocLengths;
    private int[] rawDocLengths2;
    private SegmentMergeQueue queue = null;
    boolean omitTermFreqAndPositions;
    private byte[] payloadBuffer;
    private int[][] docMaps;
    private int[] delCounts;

    SegmentMerger(Directory dir, String name) {
        this.directory = dir;
        this.segment = name;
        this.checkAbort = new CheckAbort(null, null){

            @Override
            public void work(double units) throws MergePolicy.MergeAbortedException {
            }
        };
    }

    SegmentMerger(IndexWriter writer, String name, MergePolicy.OneMerge merge) {
        this.directory = writer.getDirectory();
        this.segment = name;
        this.checkAbort = merge != null ? new CheckAbort(merge, this.directory) : new CheckAbort(null, null){

            @Override
            public void work(double units) throws MergePolicy.MergeAbortedException {
            }
        };
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    boolean hasProx() {
        return this.fieldInfos.hasProx();
    }

    final void add(IndexReader reader) {
        this.readers.add(reader);
    }

    final IndexReader segmentReader(int i) {
        return (IndexReader)this.readers.get(i);
    }

    final int merge() throws CorruptIndexException, IOException {
        return this.merge(true);
    }

    final int merge(boolean mergeDocStores) throws CorruptIndexException, IOException {
        this.mergeDocStores = mergeDocStores;
        this.mergedDocs = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (mergeDocStores && this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        return this.mergedDocs;
    }

    final void closeReaders() throws IOException {
        Iterator iter = this.readers.iterator();
        while (iter.hasNext()) {
            ((IndexReader)iter.next()).close();
        }
    }

    final List createCompoundFile(String fileName) throws IOException {
        int i;
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, fileName, this.checkAbort);
        ArrayList<String> files = new ArrayList<String>(IndexFileNames.COMPOUND_EXTENSIONS.length + 1);
        for (i = 0; i < IndexFileNames.COMPOUND_EXTENSIONS.length; ++i) {
            String ext = IndexFileNames.COMPOUND_EXTENSIONS[i];
            if (ext.equals("prx") && !this.hasProx() || !this.mergeDocStores && (ext.equals("fdt") || ext.equals("fdx"))) continue;
            files.add(this.segment + "." + ext);
        }
        for (i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            files.add(this.segment + "." + "nrm");
            break;
        }
        if (this.fieldInfos.hasVectors() && this.mergeDocStores) {
            for (i = 0; i < IndexFileNames.VECTOR_EXTENSIONS.length; ++i) {
                files.add(this.segment + "." + IndexFileNames.VECTOR_EXTENSIONS[i]);
            }
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
        return files;
    }

    private void addIndexed(IndexReader reader, FieldInfos fInfos, Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean storePayloads, boolean omitTFAndPositions) throws IOException {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String field;
            fInfos.add(field, true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector, !reader.hasNorms(field = (String)i.next()), storePayloads, omitTFAndPositions);
        }
    }

    private void setMatchingSegmentReaders() {
        int numReaders = this.readers.size();
        this.matchingSegmentReaders = new SegmentReader[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            if (!(reader instanceof SegmentReader)) continue;
            SegmentReader segmentReader = (SegmentReader)reader;
            boolean same = true;
            FieldInfos segmentFieldInfos = segmentReader.fieldInfos();
            int numFieldInfos = segmentFieldInfos.size();
            for (int j = 0; same && j < numFieldInfos; ++j) {
                same = this.fieldInfos.fieldName(j).equals(segmentFieldInfos.fieldName(j));
            }
            if (!same) continue;
            this.matchingSegmentReaders[i] = segmentReader;
        }
        this.rawDocLengths = new int[4192];
        this.rawDocLengths2 = new int[4192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws CorruptIndexException, IOException {
        if (!this.mergeDocStores) {
            SegmentReader sr = (SegmentReader)this.readers.get(this.readers.size() - 1);
            this.fieldInfos = (FieldInfos)sr.core.fieldInfos.clone();
        } else {
            this.fieldInfos = new FieldInfos();
        }
        for (IndexReader reader : this.readers) {
            if (reader instanceof SegmentReader) {
                SegmentReader segmentReader = (SegmentReader)reader;
                FieldInfos readerFieldInfos = segmentReader.fieldInfos();
                int numReaderFieldInfos = readerFieldInfos.size();
                for (int j = 0; j < numReaderFieldInfos; ++j) {
                    FieldInfo fi = readerFieldInfos.fieldInfo(j);
                    this.fieldInfos.add(fi.name, fi.isIndexed, fi.storeTermVector, fi.storePositionWithTermVector, fi.storeOffsetWithTermVector, !reader.hasNorms(fi.name), fi.storePayloads, fi.omitTermFreqAndPositions);
                }
                continue;
            }
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET), true, true, true, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION), true, true, false, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET), true, false, true, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR), true, false, false, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.OMIT_TERM_FREQ_AND_POSITIONS), false, false, false, false, true);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.STORES_PAYLOADS), false, false, false, true, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.INDEXED), false, false, false, false, false);
            this.fieldInfos.add(reader.getFieldNames(IndexReader.FieldOption.UNINDEXED), false);
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        int docCount = 0;
        this.setMatchingSegmentReaders();
        if (this.mergeDocStores) {
            FieldSelector fieldSelectorMerge = new FieldSelector(){

                @Override
                public FieldSelectorResult accept(String fieldName) {
                    return FieldSelectorResult.LOAD_FOR_MERGE;
                }
            };
            try (FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);){
                int idx = 0;
                for (IndexReader reader : this.readers) {
                    FieldsReader fieldsReader;
                    SegmentReader matchingSegmentReader = this.matchingSegmentReaders[idx++];
                    FieldsReader matchingFieldsReader = null;
                    if (matchingSegmentReader != null && (fieldsReader = matchingSegmentReader.getFieldsReader()) != null && fieldsReader.canReadRawDocs()) {
                        matchingFieldsReader = fieldsReader;
                    }
                    if (reader.hasDeletions()) {
                        docCount += this.copyFieldsWithDeletions(fieldSelectorMerge, fieldsWriter, reader, matchingFieldsReader);
                        continue;
                    }
                    docCount += this.copyFieldsNoDeletions(fieldSelectorMerge, fieldsWriter, reader, matchingFieldsReader);
                }
            }
            String fileName = this.segment + "." + "fdx";
            long fdxFileLength = this.directory.fileLength(fileName);
            if (4L + (long)docCount * 8L != fdxFileLength) {
                throw new RuntimeException("mergeFields produced an invalid result: docCount is " + docCount + " but fdx file size is " + fdxFileLength + " file=" + fileName + " file exists?=" + this.directory.fileExists(fileName) + "; now aborting this merge to prevent index corruption");
            }
        } else {
            Iterator iter = this.readers.iterator();
            while (iter.hasNext()) {
                docCount += ((IndexReader)iter.next()).numDocs();
            }
        }
        return docCount;
    }

    private int copyFieldsWithDeletions(FieldSelector fieldSelectorMerge, FieldsWriter fieldsWriter, IndexReader reader, FieldsReader matchingFieldsReader) throws IOException, MergePolicy.MergeAbortedException, CorruptIndexException {
        int docCount = 0;
        int maxDoc = reader.maxDoc();
        if (matchingFieldsReader != null) {
            int j = 0;
            while (j < maxDoc) {
                if (reader.isDeleted(j)) {
                    ++j;
                    continue;
                }
                int start = j;
                int numDocs = 0;
                do {
                    ++numDocs;
                    if (++j >= maxDoc) break;
                    if (!reader.isDeleted(j)) continue;
                    ++j;
                    break;
                } while (numDocs < 4192);
                IndexInput stream = matchingFieldsReader.rawDocs(this.rawDocLengths, start, numDocs);
                fieldsWriter.addRawDocuments(stream, this.rawDocLengths, numDocs);
                docCount += numDocs;
                this.checkAbort.work(300 * numDocs);
            }
        } else {
            for (int j = 0; j < maxDoc; ++j) {
                if (reader.isDeleted(j)) continue;
                Document doc = reader.document(j, fieldSelectorMerge);
                fieldsWriter.addDocument(doc);
                ++docCount;
                this.checkAbort.work(300.0);
            }
        }
        return docCount;
    }

    private int copyFieldsNoDeletions(FieldSelector fieldSelectorMerge, FieldsWriter fieldsWriter, IndexReader reader, FieldsReader matchingFieldsReader) throws IOException, MergePolicy.MergeAbortedException, CorruptIndexException {
        int docCount;
        int maxDoc = reader.maxDoc();
        if (matchingFieldsReader != null) {
            int len;
            for (docCount = 0; docCount < maxDoc; docCount += len) {
                len = Math.min(4192, maxDoc - docCount);
                IndexInput stream = matchingFieldsReader.rawDocs(this.rawDocLengths, docCount, len);
                fieldsWriter.addRawDocuments(stream, this.rawDocLengths, len);
                this.checkAbort.work(300 * len);
            }
        } else {
            while (docCount < maxDoc) {
                Document doc = reader.document(docCount, fieldSelectorMerge);
                fieldsWriter.addDocument(doc);
                this.checkAbort.work(300.0);
                ++docCount;
            }
        }
        return docCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectors() throws IOException {
        try (TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);){
            int idx = 0;
            Iterator iter = this.readers.iterator();
            while (iter.hasNext()) {
                IndexReader reader;
                TermVectorsReader vectorsReader;
                SegmentReader matchingSegmentReader = this.matchingSegmentReaders[idx++];
                TermVectorsReader matchingVectorsReader = null;
                if (matchingSegmentReader != null && (vectorsReader = matchingSegmentReader.getTermVectorsReaderOrig()) != null && vectorsReader.canReadRawDocs()) {
                    matchingVectorsReader = vectorsReader;
                }
                if ((reader = (IndexReader)iter.next()).hasDeletions()) {
                    this.copyVectorsWithDeletions(termVectorsWriter, matchingVectorsReader, reader);
                    continue;
                }
                this.copyVectorsNoDeletions(termVectorsWriter, matchingVectorsReader, reader);
            }
        }
        String fileName = this.segment + "." + "tvx";
        long tvxSize = this.directory.fileLength(fileName);
        if (4L + (long)this.mergedDocs * 16L != tvxSize) {
            throw new RuntimeException("mergeVectors produced an invalid result: mergedDocs is " + this.mergedDocs + " but tvx size is " + tvxSize + " file=" + fileName + " file exists?=" + this.directory.fileExists(fileName) + "; now aborting this merge to prevent index corruption");
        }
    }

    private void copyVectorsWithDeletions(TermVectorsWriter termVectorsWriter, TermVectorsReader matchingVectorsReader, IndexReader reader) throws IOException, MergePolicy.MergeAbortedException {
        int maxDoc = reader.maxDoc();
        if (matchingVectorsReader != null) {
            int docNum = 0;
            while (docNum < maxDoc) {
                if (reader.isDeleted(docNum)) {
                    ++docNum;
                    continue;
                }
                int start = docNum;
                int numDocs = 0;
                do {
                    ++numDocs;
                    if (++docNum >= maxDoc) break;
                    if (!reader.isDeleted(docNum)) continue;
                    ++docNum;
                    break;
                } while (numDocs < 4192);
                matchingVectorsReader.rawDocs(this.rawDocLengths, this.rawDocLengths2, start, numDocs);
                termVectorsWriter.addRawDocuments(matchingVectorsReader, this.rawDocLengths, this.rawDocLengths2, numDocs);
                this.checkAbort.work(300 * numDocs);
            }
        } else {
            for (int docNum = 0; docNum < maxDoc; ++docNum) {
                if (reader.isDeleted(docNum)) continue;
                TermFreqVector[] vectors = reader.getTermFreqVectors(docNum);
                termVectorsWriter.addAllDocVectors(vectors);
                this.checkAbort.work(300.0);
            }
        }
    }

    private void copyVectorsNoDeletions(TermVectorsWriter termVectorsWriter, TermVectorsReader matchingVectorsReader, IndexReader reader) throws IOException, MergePolicy.MergeAbortedException {
        int maxDoc = reader.maxDoc();
        if (matchingVectorsReader != null) {
            int len;
            for (int docCount = 0; docCount < maxDoc; docCount += len) {
                len = Math.min(4192, maxDoc - docCount);
                matchingVectorsReader.rawDocs(this.rawDocLengths, this.rawDocLengths2, docCount, len);
                termVectorsWriter.addRawDocuments(matchingVectorsReader, this.rawDocLengths, this.rawDocLengths2, len);
                this.checkAbort.work(300 * len);
            }
        } else {
            for (int docNum = 0; docNum < maxDoc; ++docNum) {
                TermFreqVector[] vectors = reader.getTermFreqVectors(docNum);
                termVectorsWriter.addAllDocVectors(vectors);
                this.checkAbort.work(300.0);
            }
        }
    }

    private final void mergeTerms() throws CorruptIndexException, IOException {
        SegmentWriteState state = new SegmentWriteState(null, this.directory, this.segment, null, this.mergedDocs, 0, this.termIndexInterval);
        FormatPostingsFieldsWriter consumer = new FormatPostingsFieldsWriter(state, this.fieldInfos);
        try {
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos(consumer);
        }
        finally {
            ((FormatPostingsFieldsConsumer)consumer).finish();
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos(FormatPostingsFieldsConsumer consumer) throws CorruptIndexException, IOException {
        int base = 0;
        int readerCount = this.readers.size();
        for (int i = 0; i < readerCount; ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            TermEnum termEnum = reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            int[] docMap = smi.getDocMap();
            if (docMap != null) {
                if (this.docMaps == null) {
                    this.docMaps = new int[readerCount][];
                    this.delCounts = new int[readerCount];
                }
                this.docMaps[i] = docMap;
                this.delCounts[i] = smi.reader.maxDoc() - smi.reader.numDocs();
            }
            base += reader.numDocs();
            assert (reader.numDocs() == reader.maxDoc() - smi.delCount);
            if (smi.next()) {
                this.queue.add(smi);
                continue;
            }
            smi.close();
        }
        SegmentMergeInfo[] match = new SegmentMergeInfo[this.readers.size()];
        String currentField = null;
        FormatPostingsTermsConsumer termsConsumer = null;
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            if (currentField != term.field) {
                currentField = term.field;
                if (termsConsumer != null) {
                    termsConsumer.finish();
                }
                FieldInfo fieldInfo = this.fieldInfos.fieldInfo(currentField);
                termsConsumer = consumer.addField(fieldInfo);
                this.omitTermFreqAndPositions = fieldInfo.omitTermFreqAndPositions;
            }
            int df = this.appendPostings(termsConsumer, match, matchSize);
            this.checkAbort.work((double)df / 3.0);
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match[--matchSize]).next()) {
                    this.queue.add(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    int[][] getDocMaps() {
        return this.docMaps;
    }

    int[] getDelCounts() {
        return this.delCounts;
    }

    private final int appendPostings(FormatPostingsTermsConsumer termsConsumer, SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        FormatPostingsDocsConsumer docConsumer = termsConsumer.addTerm(smis[0].term.text);
        int df = 0;
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.getPositions();
            assert (postings != null);
            int base = smi.base;
            int[] docMap = smi.getDocMap();
            postings.seek(smi.termEnum);
            while (postings.next()) {
                ++df;
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                int freq = postings.freq();
                FormatPostingsPositionsConsumer posConsumer = docConsumer.addDoc(doc += base, freq);
                if (this.omitTermFreqAndPositions) continue;
                for (int j = 0; j < freq; ++j) {
                    int position = postings.nextPosition();
                    int payloadLength = postings.getPayloadLength();
                    if (payloadLength > 0) {
                        if (this.payloadBuffer == null || this.payloadBuffer.length < payloadLength) {
                            this.payloadBuffer = new byte[payloadLength];
                        }
                        postings.getPayload(this.payloadBuffer, 0);
                    }
                    posConsumer.addPosition(position, this.payloadBuffer, 0, payloadLength);
                }
                posConsumer.finish();
            }
        }
        docConsumer.finish();
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms() throws IOException {
        byte[] normBuffer = null;
        try (IndexOutput output = null;){
            int numFieldInfos = this.fieldInfos.size();
            for (int i = 0; i < numFieldInfos; ++i) {
                FieldInfo fi = this.fieldInfos.fieldInfo(i);
                if (!fi.isIndexed || fi.omitNorms) continue;
                if (output == null) {
                    output = this.directory.createOutput(this.segment + "." + "nrm");
                    output.writeBytes(NORMS_HEADER, NORMS_HEADER.length);
                }
                for (IndexReader reader : this.readers) {
                    int maxDoc = reader.maxDoc();
                    if (normBuffer == null || normBuffer.length < maxDoc) {
                        normBuffer = new byte[maxDoc];
                    }
                    reader.norms(fi.name, normBuffer, 0);
                    if (!reader.hasDeletions()) {
                        output.writeBytes(normBuffer, maxDoc);
                    } else {
                        for (int k = 0; k < maxDoc; ++k) {
                            if (reader.isDeleted(k)) continue;
                            output.writeByte(normBuffer[k]);
                        }
                    }
                    this.checkAbort.work(maxDoc);
                }
            }
        }
    }

    static class CheckAbort {
        private double workCount;
        private MergePolicy.OneMerge merge;
        private Directory dir;

        public CheckAbort(MergePolicy.OneMerge merge, Directory dir) {
            this.merge = merge;
            this.dir = dir;
        }

        public void work(double units) throws MergePolicy.MergeAbortedException {
            this.workCount += units;
            if (this.workCount >= 10000.0) {
                this.merge.checkAborted(this.dir);
                this.workCount = 0.0;
            }
        }
    }
}

