/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.ep.index.IndexCommit;
import org.apache.lucene.ep.index.IndexCommitPoint;
import org.apache.lucene.ep.index.IndexDeletionPolicy;
import org.apache.lucene.ep.store.Directory;

public class SnapshotDeletionPolicy
implements IndexDeletionPolicy {
    private IndexCommit lastCommit;
    private IndexDeletionPolicy primary;
    private String snapshot;

    public SnapshotDeletionPolicy(IndexDeletionPolicy primary) {
        this.primary = primary;
    }

    @Override
    public synchronized void onInit(List commits) throws IOException {
        this.primary.onInit(this.wrapCommits(commits));
        this.lastCommit = (IndexCommit)commits.get(commits.size() - 1);
    }

    @Override
    public synchronized void onCommit(List commits) throws IOException {
        this.primary.onCommit(this.wrapCommits(commits));
        this.lastCommit = (IndexCommit)commits.get(commits.size() - 1);
    }

    public synchronized IndexCommitPoint snapshot() {
        if (this.lastCommit == null) {
            throw new IllegalStateException("no index commits to snapshot !");
        }
        if (this.snapshot != null) {
            throw new IllegalStateException("snapshot is already set; please call release() first");
        }
        this.snapshot = this.lastCommit.getSegmentsFileName();
        return this.lastCommit;
    }

    public synchronized void release() {
        if (this.snapshot == null) {
            throw new IllegalStateException("snapshot was not set; please call snapshot() first");
        }
        this.snapshot = null;
    }

    private List wrapCommits(List commits) {
        int count = commits.size();
        ArrayList<MyCommitPoint> myCommits = new ArrayList<MyCommitPoint>(count);
        for (int i = 0; i < count; ++i) {
            myCommits.add(new MyCommitPoint((IndexCommit)commits.get(i)));
        }
        return myCommits;
    }

    private class MyCommitPoint
    extends IndexCommit {
        IndexCommit cp;

        MyCommitPoint(IndexCommit cp) {
            this.cp = cp;
        }

        @Override
        public String getSegmentsFileName() {
            return this.cp.getSegmentsFileName();
        }

        @Override
        public Collection getFileNames() throws IOException {
            return this.cp.getFileNames();
        }

        @Override
        public Directory getDirectory() {
            return this.cp.getDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            SnapshotDeletionPolicy snapshotDeletionPolicy = SnapshotDeletionPolicy.this;
            synchronized (snapshotDeletionPolicy) {
                if (SnapshotDeletionPolicy.this.snapshot == null || !SnapshotDeletionPolicy.this.snapshot.equals(this.getSegmentsFileName())) {
                    this.cp.delete();
                }
            }
        }

        @Override
        public boolean isDeleted() {
            return this.cp.isDeleted();
        }

        @Override
        public long getVersion() {
            return this.cp.getVersion();
        }

        @Override
        public long getGeneration() {
            return this.cp.getGeneration();
        }

        @Override
        public Map getUserData() throws IOException {
            return this.cp.getUserData();
        }

        @Override
        public boolean isOptimized() {
            return this.cp.isOptimized();
        }
    }
}

