/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.DocIdSet;
import org.apache.lucene.ep.search.DocIdSetIterator;
import org.apache.lucene.ep.search.FieldCache;
import org.apache.lucene.ep.search.Filter;
import org.apache.lucene.ep.util.OpenBitSet;

public class FieldCacheTermsFilter
extends Filter {
    private String field;
    private String[] terms;

    public FieldCacheTermsFilter(String field, String[] terms) {
        this.field = field;
        this.terms = terms;
    }

    public FieldCache getFieldCache() {
        return FieldCache.DEFAULT;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        return new FieldCacheTermsFilterDocIdSet(this.getFieldCache().getStringIndex(reader, this.field));
    }

    protected class FieldCacheTermsFilterDocIdSet
    extends DocIdSet {
        private FieldCache.StringIndex fcsi;
        private OpenBitSet openBitSet;

        public FieldCacheTermsFilterDocIdSet(FieldCache.StringIndex fcsi) {
            this.fcsi = fcsi;
            this.openBitSet = new OpenBitSet(this.fcsi.lookup.length);
            for (int i = 0; i < FieldCacheTermsFilter.this.terms.length; ++i) {
                int termNumber = this.fcsi.binarySearchLookup(FieldCacheTermsFilter.this.terms[i]);
                if (termNumber <= 0) continue;
                this.openBitSet.fastSet(termNumber);
            }
        }

        @Override
        public DocIdSetIterator iterator() {
            return new FieldCacheTermsFilterDocIdSetIterator();
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        protected class FieldCacheTermsFilterDocIdSetIterator
        extends DocIdSetIterator {
            private int doc = -1;

            protected FieldCacheTermsFilterDocIdSetIterator() {
            }

            @Override
            public int doc() {
                return this.doc;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public boolean next() {
                return this.nextDoc() != Integer.MAX_VALUE;
            }

            @Override
            public int nextDoc() {
                try {
                    while (!FieldCacheTermsFilterDocIdSet.this.openBitSet.fastGet(((FieldCacheTermsFilterDocIdSet)FieldCacheTermsFilterDocIdSet.this).fcsi.order[++this.doc])) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }

            @Override
            public boolean skipTo(int target) {
                return this.advance(target) != Integer.MAX_VALUE;
            }

            @Override
            public int advance(int target) {
                try {
                    this.doc = target;
                    while (!FieldCacheTermsFilterDocIdSet.this.openBitSet.fastGet(((FieldCacheTermsFilterDocIdSet)FieldCacheTermsFilterDocIdSet.this).fcsi.order[this.doc])) {
                        ++this.doc;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }
        }
    }
}

