/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.FieldCache;
import org.apache.lucene.ep.search.ScoreCachingWrappingScorer;
import org.apache.lucene.ep.search.Scorer;

public abstract class FieldComparator {
    protected static final int binarySearch(String[] a, String key) {
        return FieldComparator.binarySearch(a, key, 0, a.length - 1);
    }

    protected static final int binarySearch(String[] a, String key, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            String midVal = a[mid];
            int cmp = midVal != null ? midVal.compareTo(key) : -1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public abstract int compare(int var1, int var2);

    public abstract void setBottom(int var1);

    public abstract int compareBottom(int var1) throws IOException;

    public abstract void copy(int var1, int var2) throws IOException;

    public abstract void setNextReader(IndexReader var1, int var2) throws IOException;

    public void setScorer(Scorer scorer) {
    }

    public abstract Comparable value(int var1);

    public static final class StringValComparator
    extends FieldComparator {
        private String[] values;
        private String[] currentReaderValues;
        private final String field;
        private String bottom;

        StringValComparator(int numHits, String field) {
            this.values = new String[numHits];
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareBottom(int doc) {
            String val2 = this.currentReaderValues[doc];
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.bottom.compareTo(val2);
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(reader, this.field);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return this.values[slot];
        }
    }

    public static final class StringOrdValComparator
    extends FieldComparator {
        private final int[] ords;
        private final String[] values;
        private final int[] readerGen;
        private int currentReaderGen = -1;
        private String[] lookup;
        private int[] order;
        private final String field;
        private int bottomSlot = -1;
        private int bottomOrd;
        private String bottomValue;
        private final boolean reversed;
        private final int sortPos;

        public StringOrdValComparator(int numHits, String field, int sortPos, boolean reversed) {
            this.ords = new int[numHits];
            this.values = new String[numHits];
            this.readerGen = new int[numHits];
            this.sortPos = sortPos;
            this.reversed = reversed;
            this.field = field;
        }

        @Override
        public int compare(int slot1, int slot2) {
            int cmp;
            if (this.readerGen[slot1] == this.readerGen[slot2] && (cmp = this.ords[slot1] - this.ords[slot2]) != 0) {
                return cmp;
            }
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            int order = this.order[doc];
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            String val2 = this.lookup[order];
            if (this.bottomValue == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.bottomValue.compareTo(val2);
        }

        private void convert(int slot) {
            this.readerGen[slot] = this.currentReaderGen;
            int index = 0;
            String value = this.values[slot];
            if (value == null) {
                this.ords[slot] = 0;
                return;
            }
            if (this.sortPos == 0 && this.bottomSlot != -1 && this.bottomSlot != slot) {
                assert (this.bottomOrd < this.lookup.length);
                index = this.reversed ? StringOrdValComparator.binarySearch(this.lookup, value, this.bottomOrd, this.lookup.length - 1) : StringOrdValComparator.binarySearch(this.lookup, value, 0, this.bottomOrd);
            } else {
                index = StringOrdValComparator.binarySearch(this.lookup, value);
            }
            if (index < 0) {
                index = -index - 2;
            }
            this.ords[slot] = index;
        }

        @Override
        public void copy(int slot, int doc) {
            int ord;
            this.ords[slot] = ord = this.order[doc];
            assert (ord >= 0);
            this.values[slot] = this.lookup[ord];
            this.readerGen[slot] = this.currentReaderGen;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            FieldCache.StringIndex currentReaderValues = FieldCache.DEFAULT.getStringIndex(reader, this.field);
            ++this.currentReaderGen;
            this.order = currentReaderValues.order;
            this.lookup = currentReaderValues.lookup;
            assert (this.lookup.length > 0);
            if (this.bottomSlot != -1) {
                this.convert(this.bottomSlot);
                this.bottomOrd = this.ords[this.bottomSlot];
            }
        }

        @Override
        public void setBottom(int bottom) {
            this.bottomSlot = bottom;
            if (this.readerGen[bottom] != this.currentReaderGen) {
                this.convert(this.bottomSlot);
            }
            this.bottomOrd = this.ords[bottom];
            assert (this.bottomOrd >= 0);
            assert (this.bottomOrd < this.lookup.length);
            this.bottomValue = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return this.values[slot];
        }

        public String[] getValues() {
            return this.values;
        }

        public int getBottomSlot() {
            return this.bottomSlot;
        }

        public String getField() {
            return this.field;
        }
    }

    public static final class StringComparatorLocale
    extends FieldComparator {
        private final String[] values;
        private String[] currentReaderValues;
        private final String field;
        final Collator collator;
        private String bottom;

        StringComparatorLocale(int numHits, String field, Locale locale) {
            this.values = new String[numHits];
            this.field = field;
            this.collator = Collator.getInstance(locale);
        }

        @Override
        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(val1, val2);
        }

        @Override
        public int compareBottom(int doc) {
            String val2 = this.currentReaderValues[doc];
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(this.bottom, val2);
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(reader, this.field);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return this.values[slot];
        }
    }

    public static final class ShortComparator
    extends FieldComparator {
        private final short[] values;
        private short[] currentReaderValues;
        private final String field;
        private FieldCache.ShortParser parser;
        private short bottom;

        ShortComparator(int numHits, String field, FieldCache.Parser parser) {
            this.values = new short[numHits];
            this.field = field;
            this.parser = (FieldCache.ShortParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.values[slot1] - this.values[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            return this.bottom - this.currentReaderValues[doc];
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getShorts(reader, this.field, this.parser);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Short(this.values[slot]);
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator {
        private final float[] scores;
        private float bottom;
        private Scorer scorer;

        RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            float score1 = this.scores[slot1];
            float score2 = this.scores[slot2];
            return score1 > score2 ? -1 : (score1 < score2 ? 1 : 0);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            float score = this.scorer.score();
            return this.bottom > score ? -1 : (this.bottom < score ? 1 : 0);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.scores[slot] = this.scorer.score();
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) {
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.scores[bottom];
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = new ScoreCachingWrappingScorer(scorer);
        }

        @Override
        public Comparable value(int slot) {
            return new Float(this.scores[slot]);
        }
    }

    public static final class LongComparator
    extends FieldComparator {
        private final long[] values;
        private long[] currentReaderValues;
        private final String field;
        private FieldCache.LongParser parser;
        private long bottom;

        LongComparator(int numHits, String field, FieldCache.Parser parser) {
            this.values = new long[numHits];
            this.field = field;
            this.parser = (FieldCache.LongParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            long v1 = this.values[slot1];
            long v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            long v2 = this.currentReaderValues[doc];
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getLongs(reader, this.field, this.parser);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Long(this.values[slot]);
        }
    }

    public static final class IntComparator
    extends FieldComparator {
        private final int[] values;
        private int[] currentReaderValues;
        private final String field;
        private FieldCache.IntParser parser;
        private int bottom;

        IntComparator(int numHits, String field, FieldCache.Parser parser) {
            this.values = new int[numHits];
            this.field = field;
            this.parser = (FieldCache.IntParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            int v1 = this.values[slot1];
            int v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            int v2 = this.currentReaderValues[doc];
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getInts(reader, this.field, this.parser);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Integer(this.values[slot]);
        }
    }

    public static final class FloatComparator
    extends FieldComparator {
        private final float[] values;
        private float[] currentReaderValues;
        private final String field;
        private FieldCache.FloatParser parser;
        private float bottom;

        FloatComparator(int numHits, String field, FieldCache.Parser parser) {
            this.values = new float[numHits];
            this.field = field;
            this.parser = (FieldCache.FloatParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            float v1 = this.values[slot1];
            float v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            float v2 = this.currentReaderValues[doc];
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getFloats(reader, this.field, this.parser);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Float(this.values[slot]);
        }
    }

    public static final class DoubleComparator
    extends FieldComparator {
        private final double[] values;
        private double[] currentReaderValues;
        private final String field;
        private FieldCache.DoubleParser parser;
        private double bottom;

        DoubleComparator(int numHits, String field, FieldCache.Parser parser) {
            this.values = new double[numHits];
            this.field = field;
            this.parser = (FieldCache.DoubleParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            double v1 = this.values[slot1];
            double v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compareBottom(int doc) {
            double v2 = this.currentReaderValues[doc];
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getDoubles(reader, this.field, this.parser);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Double(this.values[slot]);
        }
    }

    public static final class DocComparator
    extends FieldComparator {
        private final int[] docIDs;
        private int docBase;
        private int bottom;

        DocComparator(int numHits) {
            this.docIDs = new int[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.docIDs[slot1] - this.docIDs[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            return this.bottom - (this.docBase + doc);
        }

        @Override
        public void copy(int slot, int doc) {
            this.docIDs[slot] = this.docBase + doc;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) {
            this.docBase = docBase;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.docIDs[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Integer(this.docIDs[slot]);
        }
    }

    public static final class ByteComparator
    extends FieldComparator {
        private final byte[] values;
        private byte[] currentReaderValues;
        private final String field;
        private FieldCache.ByteParser parser;
        private byte bottom;

        ByteComparator(int numHits, String field, FieldCache.Parser parser) {
            this.values = new byte[numHits];
            this.field = field;
            this.parser = (FieldCache.ByteParser)parser;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.values[slot1] - this.values[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            return this.bottom - this.currentReaderValues[doc];
        }

        @Override
        public void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getBytes(reader, this.field, this.parser);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public Comparable value(int slot) {
            return new Byte(this.values[slot]);
        }
    }
}

