/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.DocIdSet;
import org.apache.lucene.ep.search.DocIdSetIterator;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Filter;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.Weight;
import org.apache.lucene.ep.util.ToStringUtils;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        final Similarity similarity = this.query.getSimilarity(searcher);
        return new Weight(){
            private float value;

            @Override
            public float getValue() {
                return this.value;
            }

            @Override
            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            @Override
            public void normalize(float v) {
                weight.normalize(v);
                this.value = weight.getValue() * FilteredQuery.this.getBoost();
            }

            @Override
            public Explanation explain(IndexReader ir, int i) throws IOException {
                Filter f;
                DocIdSet docIdSet;
                DocIdSetIterator docIdSetIterator;
                Explanation inner = weight.explain(ir, i);
                if (FilteredQuery.this.getBoost() != 1.0f) {
                    Explanation preBoost = inner;
                    inner = new Explanation(inner.getValue() * FilteredQuery.this.getBoost(), "product of:");
                    inner.addDetail(new Explanation(FilteredQuery.this.getBoost(), "boost"));
                    inner.addDetail(preBoost);
                }
                DocIdSetIterator docIdSetIterator2 = docIdSetIterator = (docIdSet = (f = FilteredQuery.this.filter).getDocIdSet(ir)) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : docIdSet.iterator();
                if (docIdSetIterator == null) {
                    docIdSetIterator = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
                if (docIdSetIterator.advance(i) == i) {
                    return inner;
                }
                Explanation result = new Explanation(0.0f, "failure to match filter: " + f.toString());
                result.addDetail(inner);
                return result;
            }

            @Override
            public Query getQuery() {
                return FilteredQuery.this;
            }

            @Override
            public Scorer scorer(IndexReader indexReader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
                final Scorer scorer = weight.scorer(indexReader, true, false);
                if (scorer == null) {
                    return null;
                }
                DocIdSet docIdSet = FilteredQuery.this.filter.getDocIdSet(indexReader);
                if (docIdSet == null) {
                    return null;
                }
                final DocIdSetIterator docIdSetIterator = docIdSet.iterator();
                if (docIdSetIterator == null) {
                    return null;
                }
                return new Scorer(similarity){
                    private int doc;
                    {
                        super(similarity);
                        this.doc = -1;
                    }

                    private int advanceToCommon(int scorerDoc, int disiDoc) throws IOException {
                        while (scorerDoc != disiDoc) {
                            if (scorerDoc < disiDoc) {
                                scorerDoc = scorer.advance(disiDoc);
                                continue;
                            }
                            disiDoc = docIdSetIterator.advance(scorerDoc);
                        }
                        return scorerDoc;
                    }

                    @Override
                    public boolean next() throws IOException {
                        return this.nextDoc() != Integer.MAX_VALUE;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        int scorerDoc;
                        int disiDoc = docIdSetIterator.nextDoc();
                        this.doc = disiDoc != Integer.MAX_VALUE && (scorerDoc = scorer.nextDoc()) != Integer.MAX_VALUE && this.advanceToCommon(scorerDoc, disiDoc) != Integer.MAX_VALUE ? scorer.docID() : Integer.MAX_VALUE;
                        return this.doc;
                    }

                    @Override
                    public int doc() {
                        return scorer.doc();
                    }

                    @Override
                    public int docID() {
                        return this.doc;
                    }

                    @Override
                    public boolean skipTo(int i) throws IOException {
                        return this.advance(i) != Integer.MAX_VALUE;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        int scorerDoc;
                        int disiDoc = docIdSetIterator.advance(target);
                        this.doc = disiDoc != Integer.MAX_VALUE && (scorerDoc = scorer.advance(disiDoc)) != Integer.MAX_VALUE && this.advanceToCommon(scorerDoc, disiDoc) != Integer.MAX_VALUE ? scorer.docID() : Integer.MAX_VALUE;
                        return this.doc;
                    }

                    @Override
                    public float score() throws IOException {
                        return FilteredQuery.this.getBoost() * scorer.score();
                    }

                    @Override
                    public Explanation explain(int i) throws IOException {
                        Explanation exp = scorer.explain(i);
                        if (docIdSetIterator.advance(i) == i) {
                            exp.setDescription("allowed by filter: " + exp.getDescription());
                            exp.setValue(FilteredQuery.this.getBoost() * exp.getValue());
                        } else {
                            exp.setDescription("removed by filter: " + exp.getDescription());
                            exp.setValue(0.0f);
                        }
                        return exp;
                    }
                };
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            FilteredQuery clone = (FilteredQuery)this.clone();
            clone.query = rewritten;
            return clone;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void extractTerms(Set terms) {
        this.getQuery().extractTerms(terms);
    }

    @Override
    public String toString(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)o;
            return this.query.equals(fq.query) && this.filter.equals(fq.filter) && this.getBoost() == fq.getBoost();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

