/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.FieldDoc;
import org.apache.lucene.ep.search.FieldSortedHitQueue;
import org.apache.lucene.ep.search.ScoreDoc;
import org.apache.lucene.ep.search.Sort;
import org.apache.lucene.ep.search.TopDocCollector;
import org.apache.lucene.ep.search.TopDocs;
import org.apache.lucene.ep.search.TopFieldDocs;

public class TopFieldDocCollector
extends TopDocCollector {
    private FieldDoc reusableFD;

    public TopFieldDocCollector(IndexReader reader, Sort sort, int numHits) throws IOException {
        super(new FieldSortedHitQueue(reader, sort.fields, numHits));
    }

    @Override
    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            if (this.reusableFD == null) {
                this.reusableFD = new FieldDoc(doc, score);
            } else {
                this.reusableFD.score = score;
                this.reusableFD.doc = doc;
            }
            this.reusableFD = (FieldDoc)this.hq.insertWithOverflow(this.reusableFD);
        }
    }

    @Override
    public TopDocs topDocs() {
        FieldSortedHitQueue fshq = (FieldSortedHitQueue)this.hq;
        ScoreDoc[] scoreDocs = new ScoreDoc[fshq.size()];
        for (int i = fshq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = fshq.fillFields((FieldDoc)fshq.pop());
        }
        return new TopFieldDocs(this.totalHits, scoreDocs, fshq.getFields(), fshq.getMaxScore());
    }
}

