/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.TermDocs;
import org.apache.lucene.ep.search.ComplexExplanation;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.Weight;
import org.apache.lucene.ep.search.function.DocValues;
import org.apache.lucene.ep.search.function.ValueSource;
import org.apache.lucene.ep.util.ToStringUtils;

public class ValueSourceQuery
extends Query {
    ValueSource valSrc;

    public ValueSourceQuery(ValueSource valSrc) {
        this.valSrc = valSrc;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    @Override
    public void extractTerms(Set terms) {
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new ValueSourceWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return this.valSrc.toString() + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueSourceQuery other = (ValueSourceQuery)o;
        return this.getBoost() == other.getBoost() && this.valSrc.equals(other.valSrc);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.valSrc.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    private class ValueSourceScorer
    extends Scorer {
        private final ValueSourceWeight weight;
        private final float qWeight;
        private final DocValues vals;
        private final TermDocs termDocs;
        private int doc;

        private ValueSourceScorer(Similarity similarity, IndexReader reader, ValueSourceWeight w) throws IOException {
            super(similarity);
            this.doc = -1;
            this.weight = w;
            this.qWeight = w.getValue();
            this.vals = ValueSourceQuery.this.valSrc.getValues(reader);
            this.termDocs = reader.termDocs(null);
        }

        @Override
        public boolean next() throws IOException {
            return this.termDocs.next();
        }

        @Override
        public int nextDoc() throws IOException {
            this.doc = this.termDocs.next() ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        @Override
        public int doc() {
            return this.termDocs.doc();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public float score() throws IOException {
            return this.qWeight * this.vals.floatVal(this.termDocs.doc());
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            return this.termDocs.skipTo(target);
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = this.termDocs.skipTo(target) ? this.termDocs.doc() : Integer.MAX_VALUE;
            return this.doc;
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            ComplexExplanation result = new ComplexExplanation(true, sc, ValueSourceQuery.this.toString() + ", product of:");
            result.addDetail(this.vals.explain(doc));
            result.addDetail(new Explanation(ValueSourceQuery.this.getBoost(), "boost"));
            result.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result;
        }
    }

    class ValueSourceWeight
    extends Weight {
        Similarity similarity;
        float queryNorm;
        float queryWeight;

        public ValueSourceWeight(Searcher searcher) {
            this.similarity = ValueSourceQuery.this.getSimilarity(searcher);
        }

        @Override
        public Query getQuery() {
            return ValueSourceQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ValueSourceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new ValueSourceScorer(this.similarity, reader, this);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new ValueSourceScorer(this.similarity, reader, this).explain(doc);
        }
    }
}

