/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.Weight;
import org.apache.lucene.ep.search.spans.SpanQuery;
import org.apache.lucene.ep.search.spans.Spans;
import org.apache.lucene.ep.util.ToStringUtils;

public class FieldMaskingSpanQuery
extends SpanQuery {
    private SpanQuery maskedQuery;
    private String field;

    public FieldMaskingSpanQuery(SpanQuery maskedQuery, String maskedField) {
        this.maskedQuery = maskedQuery;
        this.field = maskedField;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public SpanQuery getMaskedQuery() {
        return this.maskedQuery;
    }

    @Override
    public Spans getSpans(IndexReader reader) throws IOException {
        return this.maskedQuery.getSpans(reader);
    }

    @Override
    public Collection getTerms() {
        return this.maskedQuery.getTerms();
    }

    @Override
    public void extractTerms(Set terms) {
        this.maskedQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return this.maskedQuery.createWeight(searcher);
    }

    @Override
    public Similarity getSimilarity(Searcher searcher) {
        return this.maskedQuery.getSimilarity(searcher);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        FieldMaskingSpanQuery clone = null;
        SpanQuery rewritten = (SpanQuery)this.maskedQuery.rewrite(reader);
        if (rewritten != this.maskedQuery) {
            clone = (FieldMaskingSpanQuery)this.clone();
            clone.maskedQuery = rewritten;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("mask(");
        buffer.append(this.maskedQuery.toString(field));
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        buffer.append(" as ");
        buffer.append(this.field);
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FieldMaskingSpanQuery)) {
            return false;
        }
        FieldMaskingSpanQuery other = (FieldMaskingSpanQuery)o;
        return this.getField().equals(other.getField()) && this.getBoost() == other.getBoost() && this.getMaskedQuery().equals(other.getMaskedQuery());
    }

    @Override
    public int hashCode() {
        return this.getMaskedQuery().hashCode() ^ this.getField().hashCode() ^ Float.floatToRawIntBits(this.getBoost());
    }
}

