/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.spans.SpanQuery;
import org.apache.lucene.ep.search.spans.Spans;
import org.apache.lucene.ep.util.ToStringUtils;

public class SpanFirstQuery
extends SpanQuery
implements Cloneable {
    private SpanQuery match;
    private int end;

    public SpanFirstQuery(SpanQuery match, int end) {
        this.match = match;
        this.end = end;
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    @Override
    public Collection getTerms() {
        return this.match.getTerms();
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public Object clone() {
        SpanFirstQuery spanFirstQuery = new SpanFirstQuery((SpanQuery)this.match.clone(), this.end);
        spanFirstQuery.setBoost(this.getBoost());
        return spanFirstQuery;
    }

    @Override
    public void extractTerms(Set terms) {
        this.match.extractTerms(terms);
    }

    @Override
    public Spans getSpans(final IndexReader reader) throws IOException {
        return new Spans(){
            private Spans spans;
            {
                this.spans = SpanFirstQuery.this.match.getSpans(reader);
            }

            @Override
            public boolean next() throws IOException {
                while (this.spans.next()) {
                    if (this.end() > SpanFirstQuery.this.end) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean skipTo(int target) throws IOException {
                if (!this.spans.skipTo(target)) {
                    return false;
                }
                return this.spans.end() <= SpanFirstQuery.this.end || this.next();
            }

            @Override
            public int doc() {
                return this.spans.doc();
            }

            @Override
            public int start() {
                return this.spans.start();
            }

            @Override
            public int end() {
                return this.spans.end();
            }

            @Override
            public Collection getPayload() throws IOException {
                ArrayList result = null;
                if (this.spans.isPayloadAvailable()) {
                    result = new ArrayList(this.spans.getPayload());
                }
                return result;
            }

            @Override
            public boolean isPayloadAvailable() {
                return this.spans.isPayloadAvailable();
            }

            public String toString() {
                return "spans(" + SpanFirstQuery.this.toString() + ")";
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanFirstQuery clone = null;
        SpanQuery rewritten = (SpanQuery)this.match.rewrite(reader);
        if (rewritten != this.match) {
            clone = (SpanFirstQuery)this.clone();
            clone.match = rewritten;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanFirstQuery)) {
            return false;
        }
        SpanFirstQuery other = (SpanFirstQuery)o;
        return this.end == other.end && this.match.equals(other.match) && this.getBoost() == other.getBoost();
    }

    @Override
    public int hashCode() {
        int h = this.match.hashCode();
        h ^= h << 8 | h >>> 25;
        return h ^= Float.floatToRawIntBits(this.getBoost()) ^ this.end;
    }
}

