/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ep.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.fife.ep.ui.autocomplete.Completion;
import org.fife.ep.ui.autocomplete.FunctionCompletion;
import org.fife.ep.ui.autocomplete.MarkupTagCompletion;
import org.fife.ep.ui.autocomplete.ParameterizedCompletion;
import org.fife.ep.ui.autocomplete.VariableCompletion;

public class CompletionCellRenderer
extends DefaultListCellRenderer {
    private Color altBG;
    private Font font;

    public CompletionCellRenderer() {
        this.setDisplayFont(new Font("Monospaced", 0, 12));
        this.setAlternateBackground(new Color(240, 240, 240));
    }

    public Color getAlternateBackground() {
        return this.altBG;
    }

    public Font getDisplayFont() {
        return this.font;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        this.setFont(this.font);
        if (value instanceof FunctionCompletion) {
            FunctionCompletion fc = (FunctionCompletion)value;
            this.prepareForFunctionCompletion(list, fc, index, selected, hasFocus);
        } else if (value instanceof VariableCompletion) {
            VariableCompletion vc = (VariableCompletion)value;
            this.prepareForVariableCompletion(list, vc, index, selected, hasFocus);
        } else if (value instanceof MarkupTagCompletion) {
            MarkupTagCompletion mtc = (MarkupTagCompletion)value;
            this.prepareForMarkupTagCompletion(list, mtc, index, selected, hasFocus);
        } else {
            Completion c = (Completion)value;
            this.prepareForOtherCompletion(list, c, index, selected, hasFocus);
        }
        if (!selected && (index & 1) == 0 && this.altBG != null) {
            this.setBackground(this.altBG);
        }
        return this;
    }

    protected void prepareForFunctionCompletion(JList list, FunctionCompletion fc, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer("<html><b><em>");
        sb.append(fc.getName());
        sb.append("</em></b>");
        sb.append(fc.getProvider().getParameterListStart());
        int paramCount = fc.getParamCount();
        for (int i = 0; i < paramCount; ++i) {
            ParameterizedCompletion.Parameter param = fc.getParam(i);
            String type = param.getType();
            String name = param.getName();
            if (type != null) {
                if (!selected) {
                    sb.append("<font color='#aa0077'>");
                }
                sb.append(type);
                if (!selected) {
                    sb.append("</font>");
                }
                if (name != null) {
                    sb.append(' ');
                }
            }
            if (name != null) {
                sb.append(name);
            }
            if (i >= paramCount - 1) continue;
            sb.append(fc.getProvider().getParameterListSeparator());
        }
        sb.append(fc.getProvider().getParameterListEnd());
        sb.append(" : ");
        if (!selected) {
            sb.append("<font color='#a0a0ff'>");
        }
        sb.append(fc.getType());
        if (!selected) {
            sb.append("</font>");
        }
        this.setText(sb.toString());
    }

    protected void prepareForMarkupTagCompletion(JList list, MarkupTagCompletion mc, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer("<html><b><em>");
        sb.append(mc.getName());
        sb.append("</em></b>");
        this.setText(sb.toString());
    }

    protected void prepareForOtherCompletion(JList list, Completion c, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer("<html><b><em>");
        sb.append(c.getInputText());
        sb.append("</em></b>");
        this.setText(sb.toString());
    }

    protected void prepareForVariableCompletion(JList list, VariableCompletion vc, int index, boolean selected, boolean hasFocus) {
        StringBuffer sb = new StringBuffer("<html><b><em>");
        sb.append(vc.getName());
        sb.append("</em></b>");
        if (vc.getType() != null) {
            sb.append(" : ");
            if (!selected) {
                sb.append("<font color='#a0a0ff'>");
            }
            sb.append(vc.getType());
            if (!selected) {
                sb.append("</font>");
            }
        }
        this.setText(sb.toString());
    }

    public void setAlternateBackground(Color altBG) {
        this.altBG = altBG;
    }

    public void setDisplayFont(Font font) {
        this.font = font;
    }
}

