/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.debug;

import com.kingdee.eas.ep.debug.DebugRemoteContext;
import com.kingdee.eas.ep.lightRemote.RemoteContext;
import com.kingdee.eas.ep.lightRemote.RemoteServer;
import java.io.IOException;
import java.net.Socket;

public class DebugServer
extends RemoteServer {
    private static DebugServer runningServer = null;
    private static boolean flag = false;

    public static boolean isFlag() {
        return flag;
    }

    public static void setFlag(boolean flag) {
        DebugServer.flag = flag;
        if (!flag) {
            DebugServer.shutdownServer();
        }
    }

    public static synchronized DebugServer getRunningServer() {
        return runningServer;
    }

    public static synchronized void shutdownServer() {
        if (runningServer != null) {
            runningServer.close();
            runningServer = null;
        }
    }

    public static synchronized void startServer(int port) throws IOException {
        if (flag) {
            throw new IOException("DebugServer has disabled ,if you want use this service, enable in JMX .");
        }
        if (runningServer != null) {
            throw new IOException("DebugServer already running.");
        }
        runningServer = new DebugServer(port);
        runningServer.start();
    }

    @Override
    protected void finalClose() {
        if (runningServer == this) {
            DebugServer.shutdownServer();
        }
    }

    public static void startServer() throws IOException {
        DebugServer.startServer(10080);
    }

    private DebugServer(int port) throws IOException {
        super(port);
    }

    @Override
    public String toString() {
        return "kdscript debug server";
    }

    @Override
    protected RemoteContext createContext(Socket sock) throws Exception {
        return new DebugRemoteContext(sock);
    }
}

