/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.ep.document.Document;
import org.apache.lucene.ep.document.Fieldable;
import org.apache.lucene.ep.index.CorruptIndexException;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.store.Directory;
import org.apache.lucene.ep.store.IndexInput;
import org.apache.lucene.ep.store.IndexOutput;
import org.apache.lucene.ep.util.StringHelper;

final class FieldInfos
implements Cloneable {
    public static final int FORMAT_PRE = -1;
    public static final int FORMAT_START = -2;
    static final int CURRENT_FORMAT = -2;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 4;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 8;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    private final ArrayList byNumber;
    private final HashMap byName;
    private int format;

    FieldInfos() {
        this.byNumber = new ArrayList();
        this.byName = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory d, String name) throws IOException {
        block8: {
            this.byNumber = new ArrayList();
            this.byName = new HashMap();
            try (IndexInput input = d.openInput(name);){
                try {
                    this.read(input, name);
                }
                catch (IOException ioe) {
                    if (this.format == -1) {
                        input.seek(0L);
                        input.setModifiedUTF8StringsMode();
                        this.byNumber.clear();
                        this.byName.clear();
                        try {
                            this.read(input, name);
                            break block8;
                        }
                        catch (Throwable t) {
                            throw ioe;
                        }
                    }
                    throw ioe;
                }
            }
        }
    }

    public synchronized Object clone() {
        FieldInfos fis = new FieldInfos();
        int numField = this.byNumber.size();
        for (int i = 0; i < numField; ++i) {
            FieldInfo fi = (FieldInfo)((FieldInfo)this.byNumber.get(i)).clone();
            fis.byNumber.add(fi);
            fis.byName.put(fi.name, fi);
        }
        return fis;
    }

    public synchronized void add(Document doc) {
        List fields = doc.getFields();
        for (Fieldable field : fields) {
            this.add(field.name(), field.isIndexed(), field.isTermVectorStored(), field.isStorePositionWithTermVector(), field.isStoreOffsetWithTermVector(), field.getOmitNorms(), false, field.getOmitTf());
        }
    }

    boolean hasProx() {
        int numFields = this.byNumber.size();
        for (int i = 0; i < numFields; ++i) {
            FieldInfo fi = this.fieldInfo(i);
            if (!fi.isIndexed || fi.omitTermFreqAndPositions) continue;
            return true;
        }
        return false;
    }

    public synchronized void addIndexed(Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector);
        }
    }

    public synchronized void add(Collection names, boolean isIndexed) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), isIndexed);
        }
    }

    public synchronized void add(String name, boolean isIndexed) {
        this.add(name, isIndexed, false, false, false, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector) {
        this.add(name, isIndexed, storeTermVector, false, false, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, false, false);
    }

    public synchronized FieldInfo add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, boolean omitTermFreqAndPositions) {
        FieldInfo fi = this.fieldInfo(name);
        if (fi == null) {
            return this.addInternal(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        }
        fi.update(isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        return fi;
    }

    private FieldInfo addInternal(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, boolean omitTermFreqAndPositions) {
        name = StringHelper.intern(name);
        FieldInfo fi = new FieldInfo(name, isIndexed, this.byNumber.size(), storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        this.byNumber.add(fi);
        this.byName.put(name, fi);
        return fi;
    }

    public int fieldNumber(String fieldName) {
        FieldInfo fi = this.fieldInfo(fieldName);
        return fi != null ? fi.number : -1;
    }

    public FieldInfo fieldInfo(String fieldName) {
        return (FieldInfo)this.byName.get(fieldName);
    }

    public String fieldName(int fieldNumber) {
        FieldInfo fi = this.fieldInfo(fieldNumber);
        return fi != null ? fi.name : "";
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        return fieldNumber >= 0 ? (FieldInfo)this.byNumber.get(fieldNumber) : null;
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean hasVectors = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            hasVectors = true;
            break;
        }
        return hasVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory d, String name) throws IOException {
        try (IndexOutput output = d.createOutput(name);){
            this.write(output);
        }
    }

    public void write(IndexOutput output) throws IOException {
        output.writeVInt(-2);
        output.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fi = this.fieldInfo(i);
            byte bits = 0;
            if (fi.isIndexed) {
                bits = (byte)(bits | 1);
            }
            if (fi.storeTermVector) {
                bits = (byte)(bits | 2);
            }
            if (fi.storePositionWithTermVector) {
                bits = (byte)(bits | 4);
            }
            if (fi.storeOffsetWithTermVector) {
                bits = (byte)(bits | 8);
            }
            if (fi.omitNorms) {
                bits = (byte)(bits | 0x10);
            }
            if (fi.storePayloads) {
                bits = (byte)(bits | 0x20);
            }
            if (fi.omitTermFreqAndPositions) {
                bits = (byte)(bits | 0x40);
            }
            output.writeString(fi.name);
            output.writeByte(bits);
        }
    }

    private void read(IndexInput input, String fileName) throws IOException {
        int firstInt = input.readVInt();
        this.format = firstInt < 0 ? firstInt : -1;
        if (this.format != -1 & this.format != -2) {
            throw new CorruptIndexException("unrecognized format " + this.format + " in file \"" + fileName + "\"");
        }
        int size = this.format == -1 ? firstInt : input.readVInt();
        for (int i = 0; i < size; ++i) {
            String name = StringHelper.intern(input.readString());
            byte bits = input.readByte();
            boolean isIndexed = (bits & 1) != 0;
            boolean storeTermVector = (bits & 2) != 0;
            boolean storePositionsWithTermVector = (bits & 4) != 0;
            boolean storeOffsetWithTermVector = (bits & 8) != 0;
            boolean omitNorms = (bits & 0x10) != 0;
            boolean storePayloads = (bits & 0x20) != 0;
            boolean omitTermFreqAndPositions = (bits & 0x40) != 0;
            this.addInternal(name, isIndexed, storeTermVector, storePositionsWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, omitTermFreqAndPositions);
        }
        if (input.getFilePointer() != input.length()) {
            throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input.getFilePointer() + " vs size " + input.length());
        }
    }
}

