/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.ep.search.Collector;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.HitCollector;
import org.apache.lucene.ep.search.HitCollectorWrapper;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.util.ScorerDocQueue;

class DisjunctionSumScorer
extends Scorer {
    private final int nrScorers;
    protected final List subScorers;
    private final int minimumNrMatchers;
    private ScorerDocQueue scorerDocQueue;
    private int currentDoc = -1;
    protected int nrMatchers = -1;
    private float currentScore = Float.NaN;

    public DisjunctionSumScorer(List subScorers, int minimumNrMatchers) throws IOException {
        super(null);
        this.nrScorers = subScorers.size();
        if (minimumNrMatchers <= 0) {
            throw new IllegalArgumentException("Minimum nr of matchers must be positive");
        }
        if (this.nrScorers <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.minimumNrMatchers = minimumNrMatchers;
        this.subScorers = subScorers;
        this.initScorerDocQueue();
    }

    public DisjunctionSumScorer(List subScorers) throws IOException {
        this(subScorers, 1);
    }

    private void initScorerDocQueue() throws IOException {
        Iterator si = this.subScorers.iterator();
        this.scorerDocQueue = new ScorerDocQueue(this.nrScorers);
        while (si.hasNext()) {
            Scorer se = (Scorer)si.next();
            if (se.nextDoc() == Integer.MAX_VALUE) continue;
            this.scorerDocQueue.insert(se);
        }
    }

    @Override
    public void score(HitCollector hc) throws IOException {
        this.score(new HitCollectorWrapper(hc));
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        while (this.nextDoc() != Integer.MAX_VALUE) {
            collector.collect(this.currentDoc);
        }
    }

    @Override
    protected boolean score(HitCollector hc, int max) throws IOException {
        return this.score(new HitCollectorWrapper(hc), max, this.docID());
    }

    @Override
    protected boolean score(Collector collector, int max, int firstDocID) throws IOException {
        collector.setScorer(this);
        while (this.currentDoc < max) {
            collector.collect(this.currentDoc);
            if (this.nextDoc() != Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.scorerDocQueue.size() < this.minimumNrMatchers || !this.advanceAfterCurrent()) {
            this.currentDoc = Integer.MAX_VALUE;
        }
        return this.currentDoc;
    }

    protected boolean advanceAfterCurrent() throws IOException {
        do {
            this.currentDoc = this.scorerDocQueue.topDoc();
            this.currentScore = this.scorerDocQueue.topScore();
            this.nrMatchers = 1;
            while ((this.scorerDocQueue.topNextAndAdjustElsePop() || this.scorerDocQueue.size() != 0) && this.scorerDocQueue.topDoc() == this.currentDoc) {
                this.currentScore += this.scorerDocQueue.topScore();
                ++this.nrMatchers;
            }
            if (this.nrMatchers < this.minimumNrMatchers) continue;
            return true;
        } while (this.scorerDocQueue.size() >= this.minimumNrMatchers);
        return false;
    }

    @Override
    public float score() throws IOException {
        return this.currentScore;
    }

    @Override
    public int doc() {
        return this.currentDoc;
    }

    @Override
    public int docID() {
        return this.currentDoc;
    }

    public int nrMatchers() {
        return this.nrMatchers;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.scorerDocQueue.size() < this.minimumNrMatchers) {
            this.currentDoc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (target <= this.currentDoc) {
            return this.currentDoc;
        }
        do {
            if (this.scorerDocQueue.topDoc() < target) continue;
            return this.advanceAfterCurrent() ? this.currentDoc : (this.currentDoc = Integer.MAX_VALUE);
        } while (this.scorerDocQueue.topSkipToAndAdjustElsePop(target) || this.scorerDocQueue.size() >= this.minimumNrMatchers);
        this.currentDoc = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        Iterator ssi = this.subScorers.iterator();
        float sumScore = 0.0f;
        int nrMatches = 0;
        while (ssi.hasNext()) {
            Explanation es = ((Scorer)ssi.next()).explain(doc);
            if (es.getValue() > 0.0f) {
                sumScore += es.getValue();
                ++nrMatches;
            }
            res.addDetail(es);
        }
        if (this.nrMatchers >= this.minimumNrMatchers) {
            res.setValue(sumScore);
            res.setDescription("sum over at least " + this.minimumNrMatchers + " of " + this.subScorers.size() + ":");
        } else {
            res.setValue(0.0f);
            res.setDescription(nrMatches + " match(es) but at least " + this.minimumNrMatchers + " of " + this.subScorers.size() + " needed");
        }
        return res;
    }
}

