/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.FilteredTermEnum;
import org.apache.lucene.ep.search.MultiTermQuery;
import org.apache.lucene.ep.search.PrefixTermEnum;
import org.apache.lucene.ep.util.ToStringUtils;

public class PrefixQuery
extends MultiTermQuery {
    private Term prefix;

    public PrefixQuery(Term prefix) {
        super(prefix);
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new PrefixTermEnum(reader, this.prefix);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.prefix.field().equals(field)) {
            buffer.append(this.prefix.field());
            buffer.append(":");
        }
        buffer.append(this.prefix.text());
        buffer.append('*');
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixQuery other = (PrefixQuery)obj;
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }
}

