/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermPositions;
import org.apache.lucene.ep.search.ExactPhraseScorer;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Searcher;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.SloppyPhraseScorer;
import org.apache.lucene.ep.search.TermQuery;
import org.apache.lucene.ep.search.Weight;
import org.apache.lucene.ep.util.ToStringUtils;

public class PhraseQuery
extends Query {
    private String field;
    private ArrayList terms = new ArrayList(4);
    private ArrayList positions = new ArrayList(4);
    private int maxPosition = 0;
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = (Integer)this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(term, position);
    }

    public void add(Term term, int position) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.add(term);
        this.positions.add(new Integer(position));
        if (position > this.maxPosition) {
            this.maxPosition = position;
        }
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            result[i] = (Integer)this.positions.get(i);
        }
        return result;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        if (this.terms.size() == 1) {
            Term term = (Term)this.terms.get(0);
            TermQuery termQuery = new TermQuery(term);
            termQuery.setBoost(this.getBoost());
            return ((Query)termQuery).createWeight(searcher);
        }
        return new PhraseWeight(searcher);
    }

    @Override
    public void extractTerms(Set queryTerms) {
        queryTerms.addAll(this.terms);
    }

    @Override
    public String toString(String f) {
        int i;
        StringBuffer buffer = new StringBuffer();
        if (this.field != null && !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        String[] pieces = new String[this.maxPosition + 1];
        for (i = 0; i < this.terms.size(); ++i) {
            int pos = (Integer)this.positions.get(i);
            String s = pieces[pos];
            s = s == null ? ((Term)this.terms.get(i)).text() : s + "|" + ((Term)this.terms.get(i)).text();
            pieces[pos] = s;
        }
        for (i = 0; i < pieces.length; ++i) {
            String s;
            if (i > 0) {
                buffer.append(' ');
            }
            if ((s = pieces[i]) == null) {
                buffer.append('?');
                continue;
            }
            buffer.append(s);
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PhraseQuery)) {
            return false;
        }
        PhraseQuery other = (PhraseQuery)o;
        return this.getBoost() == other.getBoost() && this.slop == other.slop && this.terms.equals(other.terms) && this.positions.equals(other.positions);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.slop ^ this.terms.hashCode() ^ this.positions.hashCode();
    }

    private class PhraseWeight
    extends Weight {
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public PhraseWeight(Searcher searcher) throws IOException {
            this.similarity = PhraseQuery.this.getSimilarity(searcher);
            this.idfExp = this.similarity.idfExplain(PhraseQuery.this.terms, searcher);
            this.idf = this.idfExp.getIdf();
        }

        public String toString() {
            return "weight(" + PhraseQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return PhraseQuery.this;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * PhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (PhraseQuery.this.terms.size() == 0) {
                return null;
            }
            TermPositions[] tps = new TermPositions[PhraseQuery.this.terms.size()];
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                TermPositions p = reader.termPositions((Term)PhraseQuery.this.terms.get(i));
                if (p == null) {
                    return null;
                }
                tps[i] = p;
            }
            if (PhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, tps, PhraseQuery.this.getPositions(), this.similarity, reader.norms(PhraseQuery.this.field));
            }
            return new SloppyPhraseScorer(this, tps, PhraseQuery.this.getPositions(), this.similarity, PhraseQuery.this.slop, reader.norms(PhraseQuery.this.field));
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            StringBuffer docFreqs = new StringBuffer();
            StringBuffer query = new StringBuffer();
            query.append('\"');
            docFreqs.append(this.idfExp.explain());
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                if (i != 0) {
                    query.append(" ");
                }
                Term term = (Term)PhraseQuery.this.terms.get(i);
                query.append(term.text());
            }
            query.append('\"');
            Explanation idfExpl = new Explanation(this.idf, "idf(" + PhraseQuery.this.field + ":" + docFreqs + ")");
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(PhraseQuery.this.getBoost(), "boost");
            if (PhraseQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(idfExpl);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
            result.addDetail(queryExpl);
            Explanation fieldExpl = new Explanation();
            fieldExpl.setDescription("fieldWeight(" + PhraseQuery.this.field + ":" + query + " in " + doc + "), product of:");
            Scorer scorer = this.scorer(reader, true, false);
            if (scorer == null) {
                return new Explanation(0.0f, "no matching docs");
            }
            Explanation tfExpl = scorer.explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(idfExpl);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(PhraseQuery.this.field);
            float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 1.0f;
            fieldNormExpl.setValue(fieldNorm);
            fieldNormExpl.setDescription("fieldNorm(field=" + PhraseQuery.this.field + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
            result.addDetail(fieldExpl);
            result.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result;
        }
    }
}

