/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.ep.util.AverageGuessMemoryModel;
import org.apache.lucene.ep.util.MemoryModel;

public final class RamUsageEstimator {
    private MemoryModel memoryModel;
    private final Map seen;
    private int refSize;
    private int arraySize;
    private int classSize;
    private boolean checkInterned;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public RamUsageEstimator() {
        this(new AverageGuessMemoryModel());
    }

    public RamUsageEstimator(boolean checkInterned) {
        this(new AverageGuessMemoryModel(), checkInterned);
    }

    public RamUsageEstimator(MemoryModel memoryModel) {
        this(memoryModel, true);
    }

    public RamUsageEstimator(MemoryModel memoryModel, boolean checkInterned) {
        this.memoryModel = memoryModel;
        this.checkInterned = checkInterned;
        this.seen = new IdentityHashMap(64);
        this.refSize = memoryModel.getReferenceSize();
        this.arraySize = memoryModel.getArraySize();
        this.classSize = memoryModel.getClassSize();
    }

    public long estimateRamUsage(Object obj) {
        long size = this.size(obj);
        this.seen.clear();
        return size;
    }

    private long size(Object obj) {
        Class<?> clazz;
        if (obj == null) {
            return 0L;
        }
        if (this.checkInterned && obj instanceof String && obj == ((String)obj).intern()) {
            return 0L;
        }
        if (this.seen.containsKey(obj)) {
            return 0L;
        }
        this.seen.put(obj, null);
        if (clazz.isArray()) {
            return this.sizeOfArray(obj);
        }
        long size = 0L;
        for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                if (fields[i].getType().isPrimitive()) {
                    size += (long)this.memoryModel.getPrimitiveSize(fields[i].getType());
                    continue;
                }
                size += (long)this.refSize;
                fields[i].setAccessible(true);
                try {
                    Object value = fields[i].get(obj);
                    if (value == null) continue;
                    size += this.size(value);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return size += (long)this.classSize;
    }

    private long sizeOfArray(Object obj) {
        int len = Array.getLength(obj);
        if (len == 0) {
            return 0L;
        }
        long size = this.arraySize;
        Class<?> arrayElementClazz = obj.getClass().getComponentType();
        if (arrayElementClazz.isPrimitive()) {
            size += (long)(len * this.memoryModel.getPrimitiveSize(arrayElementClazz));
        } else {
            for (int i = 0; i < len; ++i) {
                size += (long)this.refSize + this.size(Array.get(obj, i));
            }
        }
        return size;
    }

    public static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(df.format((float)bytes / 1.0737418E9f)) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(df.format((float)bytes / 1048576.0f)) + " MB" : (bytes / 1024L > 0L ? String.valueOf(df.format((float)bytes / 1024.0f)) + " KB" : String.valueOf(bytes) + " bytes"));
        return newSizeAndUnits;
    }
}

