/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.kcclight;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.kcclight.KccLightUrlContants;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class KccLightAPIInvokeUtil {
    private static final Logger logger = Logger.getLogger(KccLightAPIInvokeUtil.class);
    private static ConcurrentHashMap<String, AccessTokenInfo> accessTokenMap = new ConcurrentHashMap();

    public static String pushTodoMessage(String eid, String accountId, String msg) throws Exception {
        String accessToken = KccLightAPIInvokeUtil.getAccessToken(eid, accountId);
        String apiSecret = XTServiceConfig.getInstance().getKccAPIConfig("apiSecret");
        String url = KccLightUrlContants.PUSH_TODO_URL + "&client_secret=" + Base64.decodeToString((String)apiSecret);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Bearer " + accessToken);
        return HttpClientUtil.doPost(url, msg, headMap, "UTF-8");
    }

    public static String pushNoticeMessage(String eid, String accountId, String msg) throws Exception {
        String accessToken = KccLightAPIInvokeUtil.getAccessToken(eid, accountId);
        String apiSecret = XTServiceConfig.getInstance().getKccAPIConfig("apiSecret");
        String url = KccLightUrlContants.PUSH_NOTICE_URL + "&client_secret=" + Base64.decodeToString((String)apiSecret);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Bearer " + accessToken);
        return HttpClientUtil.doPost(url, msg, headMap, "UTF-8");
    }

    public static String updateTodoMessage(String eid, String accountId, String msg) throws Exception {
        String accessToken = KccLightAPIInvokeUtil.getAccessToken(eid, accountId);
        String apiSecret = XTServiceConfig.getInstance().getKccAPIConfig("apiSecret");
        String url = KccLightUrlContants.UPDATE_TODO_URL + "&client_secret=" + Base64.decodeToString((String)apiSecret);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Bearer " + accessToken);
        return HttpClientUtil.doPost(url, msg, headMap, "UTF-8");
    }

    public static String getAccessToken(String eid, String accountId) {
        AccessTokenInfo accessTokenInfo;
        block9: {
            long curTime;
            long passTime;
            accessTokenInfo = null;
            if (StringUtils.isEmpty((String)accountId)) {
                throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, accountId);
            }
            if (accessTokenMap.get(accountId) != null && !StringUtils.isEmpty((String)(accessTokenInfo = accessTokenMap.get(accountId)).accessToken) && (passTime = (curTime = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) / 1000L < accessTokenInfo.expireTime) {
                return accessTokenInfo.accessToken;
            }
            String entryRole = XTServiceConfig.getInstance().getKccLightConfig(eid, "entryRole");
            String secret = XTServiceConfig.getInstance().getKccLightConfig(eid, "secret");
            String apiSecret = XTServiceConfig.getInstance().getKccAPIConfig("apiSecret");
            if (StringUtils.isEmpty((String)secret)) {
                logger.error((Object)"===  KccLightLogin getAccessToken no AppSecret ===");
                throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOAPPSECRET, null, secret);
            }
            String url = KccLightUrlContants.GET_ACCESSTOKEN_URL + "&client_secret=" + Base64.decodeToString((String)apiSecret);
            try {
                if (accessTokenInfo == null) {
                    accessTokenInfo = new AccessTokenInfo();
                }
                accessTokenInfo.accessTokenTime = System.currentTimeMillis();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("eid", eid);
                param.put("accountId", accountId);
                param.put("entryRole", Integer.parseInt(entryRole));
                param.put("secret", secret);
                param.put("erpRole", 4);
                param.put("timestamp", System.currentTimeMillis());
                String KccLightResult = HttpClientUtil.doPost(url, JSON.toJSONString(param), null, "UTF-8");
                logger.error((Object)("KccLightLogin getAccessToken result:" + KccLightResult));
                if (StringUtils.isEmpty((String)KccLightResult)) break block9;
                JSONObject reObj = JSON.parseObject((String)KccLightResult);
                if (reObj.containsKey((Object)"success") && reObj.getBoolean("success").booleanValue()) {
                    JSONObject dataObject = reObj.getJSONObject("data");
                    accessTokenInfo.accessToken = dataObject.getString("accessToken");
                    accessTokenInfo.expireTime = Long.parseLong(dataObject.getString("expireIn"));
                    accessTokenMap.put(accountId, accessTokenInfo);
                    break block9;
                }
                String message = reObj.containsKey((Object)"description") ? reObj.getString("description") : reObj.getString("message");
                throw new WorkflowException(WorkflowErrorEnums.CONNET_KCCLIGHTTOKENURL_EXCEPTION, null, reObj.getString("message"));
            }
            catch (WorkflowException e) {
                logger.error((Object)"KccLightLogin getAccessToken Exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"KccLightLogin getAccessToken Exception", (Throwable)e);
                throw new WorkflowException(WorkflowErrorEnums.CONNET_KCCLIGHTTOKENURL_EXCEPTION, null, e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)accessTokenInfo.accessToken)) {
            throw new WorkflowException(WorkflowErrorEnums.CONNET_KCCLIGHTTOKENURL_EXCEPTION, null, accountId);
        }
        return accessTokenInfo.accessToken;
    }

    public static String refreshAccessToken(String eid, String accountId) {
        accessTokenMap.remove(accountId);
        return KccLightAPIInvokeUtil.getAccessToken(eid, accountId);
    }

    private static class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 7000L;

        private AccessTokenInfo() {
        }
    }
}

