/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.kcclight;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.lightapp.kcclight.KccLightAPIInvokeUtil;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.TransferUserIdToXtIdUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class KccLightMessagePusher
implements IMessagePusher {
    private static final Logger logger = Logger.getLogger(KccLightMessagePusher.class);
    private String messageType;

    public KccLightMessagePusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> messageList) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String entryRole = XTServiceConfig.getInstance().getKccLightConfig(eid, "entryRole");
        for (IMessageAdapter adapter : messageList) {
            Map<String, Object> contMap = adapter.getContent();
            String assignid = (String)contMap.get("assignId");
            String userId = (String)contMap.get("receiver");
            String procinstid = (String)contMap.get("procinstid");
            String msgStr = this.creatTodoMsgStr(ctx, adapter, contMap, entryRole);
            logger.error((Object)("KccLightMessagePusher todoMsg:" + msgStr));
            if (msgStr == null) continue;
            try {
                String accountId = eid + "-" + dbCode;
                String pushRe = "1".equals(entryRole) ? KccLightAPIInvokeUtil.pushNoticeMessage(eid, accountId, msgStr) : KccLightAPIInvokeUtil.pushTodoMessage(eid, accountId, msgStr);
                boolean shouldSendAgain = this.checkShouldSendAgain(pushRe);
                if (shouldSendAgain) {
                    KccLightAPIInvokeUtil.refreshAccessToken(eid, accountId);
                    pushRe = "1".equals(entryRole) ? KccLightAPIInvokeUtil.pushNoticeMessage(eid, accountId, msgStr) : KccLightAPIInvokeUtil.pushTodoMessage(eid, accountId, msgStr);
                }
                logger.error((Object)("KccLightMessagePusher todoMsg pushRe:" + pushRe));
                this.savePushedMsg(ctx, 0, entryRole, assignid, userId, procinstid, pushRe);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private boolean checkShouldSendAgain(String pushResult) {
        try {
            if (!StringUtils.isEmpty((String)pushResult) && pushResult.contains("errorCode") && pushResult.contains("message")) {
                JSONObject pushResultObject = JSON.parseObject((String)pushResult);
                boolean success = pushResultObject.getBooleanValue("success");
                Integer errorCode = pushResultObject.getInteger("errorCode");
                if (!success && errorCode == 90012) {
                    logger.error((Object)("KccLightMessagePusher checkShouldSendAgain pushResult : " + pushResult));
                    logger.error((Object)"KccLightMessagePusher checkShouldSendAgain : true");
                    return true;
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)("KccLightMessagePusher checkShouldSendAgain error:" + e.getMessage()), e);
        }
        return false;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String entryRole = XTServiceConfig.getInstance().getKccLightConfig(eid, "entryRole");
        for (IMessageAdapter adapter : messageList) {
            Map<String, Object> contMap = adapter.getContent();
            String assignid = (String)contMap.get("assignId");
            String userId = (String)contMap.get("receiver");
            String procinstid = (String)contMap.get("procinstid");
            String msgStr = this.creatNoticeMsgStr(ctx, adapter, contMap, entryRole);
            logger.error((Object)("KccLightMessagePusher noticeMsg:" + msgStr));
            if (msgStr == null) continue;
            try {
                String accountId = eid + "-" + dbCode;
                String pushRe = KccLightAPIInvokeUtil.pushNoticeMessage(eid, accountId, msgStr);
                boolean shouldSendAgain = this.checkShouldSendAgain(pushRe);
                if (shouldSendAgain) {
                    KccLightAPIInvokeUtil.refreshAccessToken(eid, accountId);
                    pushRe = KccLightAPIInvokeUtil.pushNoticeMessage(eid, accountId, msgStr);
                }
                this.savePushedMsg(ctx, 0, entryRole, assignid, userId, procinstid, pushRe);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String creatNoticeMsgStr(Context ctx, IMessageAdapter adapter, Map<String, Object> contMap, String entryRole) {
        String url = (String)contMap.get("url");
        Map<String, Object> msgMap = this.creatMsgStr(ctx, adapter, contMap, entryRole);
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        HashMap linksMap = new HashMap();
        HashMap<String, Object> linkMap = new HashMap<String, Object>();
        msgMap.put("content", contentMap);
        int msgType = 3;
        boolean islink = true;
        if (StringUtils.isEmpty((String)url)) {
            msgType = 1;
            islink = false;
        }
        linksMap.put("link", linkMap);
        linkMap.put("query", this.changgeToKccLightLink(url));
        linkMap.put("isLink", islink);
        contentMap.put("bizId", contMap.get("assignId"));
        contentMap.put("content", contMap.get("text"));
        contentMap.put("title", contMap.get("wxtitle"));
        contentMap.put("links", linksMap);
        contentMap.put("msgType", msgType);
        return JSON.toJSONString(msgMap);
    }

    private String creatTodoMsgStr(Context ctx, IMessageAdapter adapter, Map<String, Object> contMap, String entryRole) {
        String url = (String)contMap.get("url");
        Map<String, Object> msgMap = this.creatMsgStr(ctx, adapter, contMap, entryRole);
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        HashMap linksMap = new HashMap();
        HashMap<String, Object> linkMap = new HashMap<String, Object>();
        msgMap.put("content", contentMap);
        contentMap.put("bizId", contMap.get("assignId"));
        contentMap.put("content", contMap.get("text"));
        contentMap.put("title", contMap.get("itemtitle"));
        contentMap.put("links", linksMap);
        contentMap.put("option", new HashMap());
        contentMap.put("msgType", 3);
        linksMap.put("link", linkMap);
        linkMap.put("query", this.changgeToKccLightLink(url));
        linkMap.put("isLink", true);
        return JSON.toJSONString(msgMap);
    }

    private Map<String, Object> creatMsgStr(Context ctx, IMessageAdapter adapter, Map<String, Object> contMap, String entryRole) {
        String userMapTble = this.getUserMapTableByEntryRole(entryRole);
        List<String> personIds = TransferUserIdToXtIdUtil.transferWithList4KccLight(ctx, userMapTble, adapter.getUsers());
        String touser = "";
        for (int i = 0; i < personIds.size(); ++i) {
            touser = i == 0 ? personIds.get(i) : touser + "|" + personIds.get(i);
        }
        if (StringUtils.isEmpty((String)touser)) {
            return null;
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        HashMap optionMap = new HashMap();
        msgMap.put("appId", "10748");
        long timestamp = System.currentTimeMillis();
        SecureRandom secureRandom = new SecureRandom();
        int noce = secureRandom.nextInt(Integer.MAX_VALUE);
        msgMap.put("nonce", noce + "");
        msgMap.put("timestamp", timestamp);
        msgMap.put("toUser", touser);
        msgMap.put("option", optionMap);
        return msgMap;
    }

    private String changgeToKccLightLink(String originalURL) {
        if (StringUtils.isEmpty((String)originalURL)) {
            return null;
        }
        return originalURL.replaceAll("(http|https):\\/\\/[^\\/]*", "");
    }

    private void savePushedMsg(Context ctx, int type, String entryRole, String assignid, String userId, String procinstid, String pushResult) {
        if (!StringUtils.isEmpty((String)pushResult) && pushResult.contains("success")) {
            String msgTable = this.getMsgTableByEntryRole(entryRole);
            JSONObject pushResultObject = JSON.parseObject((String)pushResult);
            if (pushResultObject.getBoolean("success").booleanValue()) {
                String msgid = this.getAppResponseMsgId(entryRole, pushResultObject);
                if (msgid == null) {
                    msgid = assignid;
                    logger.error((Object)("KccLightMessagePusher pushResult:" + pushResultObject.getJSONObject("data")));
                }
                try {
                    String sql = " insert into " + msgTable + " (msgid,fassignid,fuserid,procinstid) values(?,?,?,?)";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{msgid, assignid, userId, procinstid});
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    this.insertEror(ctx, entryRole, assignid, userId, "0", e.getMessage());
                }
            } else {
                logger.error((Object)("KccLightMessagePusher pushResult:" + pushResult));
                String errorCode = pushResultObject.getInteger("errorCode") + "";
                String message = pushResultObject.getString("message");
                this.insertEror(ctx, entryRole, assignid, userId, errorCode, message);
            }
        } else {
            logger.error((Object)("KccLightMessagePusher pushResult:" + pushResult));
            this.insertEror(ctx, entryRole, assignid, userId, "1", pushResult);
        }
    }

    private void insertEror(Context ctx, String entryRole, String assignid, String userId, String errorCode, String errormsg) {
        String errorTable = this.getMsgErrorTableByEntryRole(entryRole);
        errormsg = errormsg != null && errormsg.length() > 200 ? errormsg.substring(0, 199) : errormsg;
        try {
            String sql = " insert into " + errorTable + "(msgid,fassignid,fuserid,errorcode,errormsg,sendtime) values(?,?,?,?,?,getdate())";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"", assignid, userId, errorCode, errormsg});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private String getAppResponseMsgId(String entryRole, JSONObject pushResultObject) {
        String msgid = null;
        try {
            JSONObject dataJsonObject = pushResultObject.getJSONObject("data");
            String response = dataJsonObject.getJSONArray("details").getJSONObject(0).getString("response");
            JSONObject appReJSONObj = JSON.parseObject((String)response);
            if ("1".equals(entryRole) && appReJSONObj.getInteger("errcode") == 0) {
                msgid = appReJSONObj.getString("msgid");
            }
            if ("2".equals(entryRole) && appReJSONObj.getInteger("errcode") == 0) {
                msgid = appReJSONObj.getString("record_id");
                String string = msgid = StringUtils.isEmpty((String)msgid) ? appReJSONObj.getString("record_id") : msgid;
            }
            if ("3".equals(entryRole) && "0".equals(appReJSONObj.getString("code"))) {
                JSONObject wlDataJsonObject = appReJSONObj.getJSONObject("data");
                msgid = wlDataJsonObject.getString("taskId");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msgid;
    }

    private String getUserMapTableByEntryRole(String entryRole) {
        String tableName = "T_PM_EASXTUSERMAP";
        tableName = "1".equals(entryRole) ? "T_PM_EASWXUSERMAP" : tableName;
        tableName = "2".equals(entryRole) ? "T_PM_EASDTUSERMAP" : tableName;
        tableName = "3".equals(entryRole) ? "T_PM_EASWLUSERMAP" : tableName;
        return tableName;
    }

    private String getMsgTableByEntryRole(String entryRole) {
        String tableName = "T_ASSIGN_XTMSG";
        tableName = "1".equals(entryRole) ? "T_ASSIGN_WXMSG" : tableName;
        tableName = "2".equals(entryRole) ? "T_ASSIGN_DTMSG" : tableName;
        tableName = "3".equals(entryRole) ? "T_ASSIGN_WLMSG" : tableName;
        return tableName;
    }

    private String getMsgErrorTableByEntryRole(String entryRole) {
        String tableName = "T_ASSIGN_XTMSGERROR";
        tableName = "1".equals(entryRole) ? "T_ASSIGN_WXMSGERROR" : tableName;
        tableName = "2".equals(entryRole) ? "T_ASSIGN_DTMSGERROR" : tableName;
        tableName = "3".equals(entryRole) ? "T_ASSIGN_WLMSGERROR" : tableName;
        return tableName;
    }
}

