/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.DeadlineDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.monitor.BillDigestFactory;
import com.kingdee.bos.workflow.monitor.SummaryProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.lightapp.pa.api.AbstractYZJMessage;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.pa.common.MessageSectionFactory;
import com.kingdee.lightapp.pa.common.TodoMessage;
import com.kingdee.lightapp.util.TransferUserIdToXtIdUtil;
import com.kingdee.lightapp.xt.YZJFlowCenterMouldHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowCenterTodoMessage
extends AbstractYZJMessage {
    private Logger logger = Logger.getLogger((String)TodoMessage.class.getName());
    private ArrayList<HashMap<String, Object>> fieldList = new ArrayList();
    private String allFieldsKeysStr = "";

    public FlowCenterTodoMessage(Context ctx, String eid, IMessageAdapter adapter) throws Exception {
        super(adapter);
        if (adapter == null) {
            throw new NullPointerException("adapter is null");
        }
        Map<String, Object> bodyPackage = adapter.getContent();
        String sendUserId = (String)bodyPackage.get("sendId");
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(sendUserId);
        userIdList.addAll(adapter.getUsers());
        Map<String, String> openIdMap = TransferUserIdToXtIdUtil.transferWithMap4YZJ(ctx, userIdList);
        String sendOpenId = openIdMap.get(sendUserId);
        String reciverUserid = adapter.getUsers().get(0);
        String reciverOpenid = openIdMap.get(reciverUserid);
        if (StringUtils.isEmpty((String)reciverOpenid)) {
            throw new Exception("nouser");
        }
        String assignid = (String)bodyPackage.get("assignId");
        String billID = (String)bodyPackage.get("billID");
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo assignment = svc.getAssignmentById(assignid);
        billID = StringUtils.isEmpty((String)billID) ? assignment.getBizObjectIds() : billID;
        this.initField(ctx, billID, assignid);
        ProcessInstInfo processInstInfo = svc.getProcessInstInfo(assignment.getProcInstId());
        String proInstTopic = processInstInfo.getInstTopic(new Locale("L2"));
        String actInstId = assignment.getActInstId();
        String topParentFlowId = this.getParentProInstId(svc, processInstInfo);
        int urgency = this.calculateUrgency(svc, actInstId);
        int ttl = this.getdDeadLine(svc, assignid);
        this.logger.error((Object)("FlowCenterTodoMessage urgency\uff1a" + urgency + " ttl\uff1a" + ttl));
        if (adapter.isNeedSendXT()) {
            this.content = MessageSectionFactory.getInstance().getMessageHeadNew("flowcenter", eid);
            HashMap<String, Object> contentMap = new HashMap<String, Object>();
            contentMap.put("typeId", this.getMouldTypeId(ctx, billID, sendOpenId));
            contentMap.put("approver", reciverOpenid);
            contentMap.put("openid", sendOpenId);
            contentMap.put("reciverId", reciverOpenid);
            contentMap.put("appid", bodyPackage.get("appid"));
            contentMap.put("url", bodyPackage.get("url"));
            contentMap.put("passUrl", bodyPackage.get("passUrl"));
            contentMap.put("text", bodyPackage.get("text"));
            contentMap.put("eid", eid);
            contentMap.put("itemtitle", bodyPackage.get("itemtitle"));
            contentMap.put("assignId", assignid);
            contentMap.put("ttl", ttl);
            contentMap.put("urgency", urgency);
            contentMap.put("procDefName", proInstTopic);
            contentMap.put("activityName", assignment.getActDefName(new Locale("L2")));
            contentMap.put("flowId", assignment.getProcInstId());
            contentMap.put("topParentFlowId", topParentFlowId);
            contentMap.put("activityId", actInstId);
            contentMap.put("billdNumber", this.gitBilldNumber(ctx, billID));
            contentMap.put("fieldList", this.fieldList);
            this.content.makeContent(contentMap);
        }
    }

    private void initField(Context ctx, String billID, String assignID) throws BOSException {
        SummaryProxy summary = BillDigestFactory.getLocalInstance((Context)ctx).getSummaryByUUIDAndDigType(billID, 2, assignID);
        if (summary != null && summary.getItems() != null) {
            List items = summary.getItems();
            for (Object[] objects : items) {
                String name = (String)objects[0];
                Object value = objects[1];
                HashMap<String, Object> field = new HashMap<String, Object>();
                field.put("name", name);
                field.put("value", value);
                this.allFieldsKeysStr = this.allFieldsKeysStr + "|" + name;
                this.fieldList.add(field);
            }
        }
    }

    private String getParentProInstId(IEnactmentService svc, ProcessInstInfo processInstInfo) {
        String procInstId = processInstInfo.getProcInstId();
        String parentProcInstId = processInstInfo.getParentProcInstId();
        int count = 0;
        while (count < 10 && !StringUtils.isEmpty((String)parentProcInstId)) {
            ++count;
            procInstId = parentProcInstId;
            try {
                processInstInfo = svc.getProcessInstInfo(procInstId);
                parentProcInstId = processInstInfo.getParentProcInstId();
            }
            catch (Exception e) {
                this.logger.error((Object)"getParentProInstId for yzj procInstId error!", (Throwable)e);
            }
        }
        return procInstId;
    }

    private String gitBilldNumber(Context ctx, String billID) {
        String number = "";
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("number");
            number = (String)BotpHelper.getObjectById((Context)ctx, (String)billID, (SelectorItemCollection)selectors).get("number");
        }
        catch (Exception e) {
            this.logger.error((Object)"gitBilldNumber for yzj error!", (Throwable)e);
        }
        return number;
    }

    private int calculateUrgency(IEnactmentService svc, String actInstId) throws WfException, WfKpdlParseException {
        int urgency = 1;
        try {
            ActivityInstInfo aii = svc.getActivityInstByActInstId(actInstId);
            ActivityDef ad = svc.getActDefByActInstInfo(aii);
            int pri = ad.getActivityHeader().getpriority();
            if (pri == 1) {
                urgency = 2;
            } else if (pri == 2) {
                urgency = 3;
            } else if (pri > 2) {
                urgency = 4;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"calculateUrgency for yzj error!", (Throwable)e);
        }
        return urgency;
    }

    private int getdDeadLine(IEnactmentService svc, String assignid) throws WfException {
        int ttl = 0;
        Map activityInfoMap = svc.getActivityDefAndActivityInstInfo(assignid);
        ManpowerActivityDef activityDef = (ManpowerActivityDef)activityInfoMap.get("ACTIVITYDEF");
        DeadlineCollection deadlines = activityDef.getDeadlines();
        List list = deadlines.toList();
        for (Object object : list) {
            DeadlineDef deadline = (DeadlineDef)object;
            if (!"ConservationDay".equals(deadline.getTimeMode()) || !deadline.getEventPolicy().isUseActivityParticipants()) continue;
            String deadlineCondition = deadline.getDeadlineCondition();
            int parseDead = this.parseDeadlineCondition(deadlineCondition);
            ttl = parseDead > ttl ? parseDead : ttl;
        }
        return ttl;
    }

    private int parseDeadlineCondition(String condition) {
        int interval = 0;
        if (condition != null) {
            String[] time = StringUtils.split((String)condition, (String)"/");
            int conditionLength = time.length;
            if (time != null && (conditionLength == 5 || conditionLength == 6)) {
                try {
                    Calendar c = Calendar.getInstance();
                    long l = c.getTime().getTime();
                    int year = 0;
                    c.add(1, year);
                    int month = Integer.parseInt(time[conditionLength - 5]);
                    c.add(2, month);
                    int date = Integer.parseInt(time[conditionLength - 4]);
                    c.add(5, date);
                    int hour = Integer.parseInt(time[conditionLength - 3]);
                    c.add(10, hour);
                    int min = Integer.parseInt(time[conditionLength - 2]);
                    c.add(12, min);
                    int sec = Integer.parseInt(time[conditionLength - 1]);
                    c.add(13, sec);
                    Date date1 = c.getTime();
                    interval = (int)((date1.getTime() - l) / 1000L / 60L);
                }
                catch (NumberFormatException e) {
                    this.logger.error((Object)"\u671f\u9650\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef!", (Throwable)e);
                }
            }
        }
        return interval;
    }

    private String getMouldTypeId(Context ctx, String billID, String sendOpenId) throws Exception {
        String fieldMD5String;
        if (StringUtils.isEmpty((String)billID)) {
            throw new Exception("\u5de5\u4f5c\u6d41\u8282\u70b9\u672a\u914d\u7f6e\u4e1a\u52a1\u5355\u636e\u5185\u7801");
        }
        String bosType = BOSUuid.read((String)billID).getType().toString();
        YZJFlowCenterMouldHandler instance = YZJFlowCenterMouldHandler.getInstance();
        String typeId = instance.getMouldTypeId(ctx, bosType, fieldMD5String = MD5Util.getMD5String((String)this.allFieldsKeysStr));
        if (StringUtils.isEmpty((String)typeId)) {
            typeId = instance.initMould(ctx, billID, sendOpenId, this.fieldList);
        }
        return typeId;
    }
}

