/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.util;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class RSAUtils {
    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        return kpg.genKeyPair();
    }

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static PublicKey restorePublicKey(byte[] bytes) throws Exception {
        X509EncodedKeySpec pkcs = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(pkcs);
    }

    public static byte[] encrypt(byte[] src, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return cipher.doFinal(src);
    }

    public static byte[] deEncrypt(byte[] dest, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return cipher.doFinal(dest);
    }

    public static byte[] encryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        SecretKeySpec sKey = new SecretKeySpec(secretKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        cipher.init(1, sKey);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = cipher.doFinal();
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }

    public static byte[] deEncryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(2, key);
        byte[] secretKeyData = new byte[128];
        System.arraycopy(data, 0, secretKeyData, 0, secretKeyData.length);
        byte[] cipherData = new byte[data.length - secretKeyData.length];
        System.arraycopy(data, secretKeyData.length, cipherData, 0, cipherData.length);
        byte[] secretKey = rsa.doFinal(secretKeyData);
        SecretKeySpec sKey = new SecretKeySpec(secretKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        cipher.init(1, sKey);
        byte[] deciphedData = cipher.doFinal();
        return deciphedData;
    }

    public static byte[] sign(byte[] src, PrivateKey prvKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initSign(prvKey);
        sig.update(src);
        return sig.sign();
    }

    public static boolean verifySign(byte[] src, byte[] dest, PublicKey pubKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify(pubKey);
        sig.update(src);
        return sig.verify(dest);
    }
}

