/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHAUtil {
    private static final char[] TOHEX = "0123456789abcdef".toCharArray();
    public static final String UTF8 = "UTF8";

    public static String sha1Hash(String tohash) {
        byte[] b = null;
        try {
            b = tohash.getBytes("UTF-8");
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            b = sha1.digest(b);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        return SHAUtil.byteToHex(b);
    }

    public static String sha256Hash(String tohash) {
        byte[] b = null;
        try {
            b = tohash.getBytes("UTF-8");
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            b = sha256.digest(b);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        return SHAUtil.byteToHex(b);
    }

    public static String byteToHex(byte[] base) {
        if (base != null) {
            char[] c = new char[base.length * 2];
            int i = 0;
            byte[] byArray = base;
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                int b;
                int j2 = b = byArray[j];
                c[i++] = TOHEX[(j2 += 128) / 16];
                c[i++] = TOHEX[j2 % 16];
            }
            return new String(c);
        }
        return null;
    }
}

