/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.util.image;

import com.kingdee.lightapp.util.image.IImageByteConverter;
import com.kingdee.lightapp.util.image.ImageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileImageByteConverter
implements IImageByteConverter {
    private File file = null;
    private String format = "";
    private String name = "";

    @Override
    public void setPath(String path) {
        if (path.substring(0, 7).equalsIgnoreCase("file://")) {
            path = path.substring(7, path.length());
        }
        this.file = new File(path);
        if (this.file != null) {
            int i;
            this.name = this.file.getName();
            if (this.name != null && this.name.length() > 0 && (i = this.name.lastIndexOf(46)) > -1 && i < this.name.length() - 1) {
                this.format = this.name.substring(i + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getByte(String format) {
        byte[] data = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            if (fis != null) {
                try {
                    int len = fis.available();
                    data = new byte[len];
                    fis.read(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!format.equals(this.format)) {
                data = ImageUtil.convert(data, format);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

