/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.workflow.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.monitor.BillDigestFactory;
import com.kingdee.bos.workflow.monitor.IBillDigest;
import com.kingdee.bos.workflow.monitor.SummaryProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.YZJInvokeUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJFlowCenterMouldHandler;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class YZJFlowCenterHisProcessUtil {
    private static Logger logger = Logger.getLogger(YZJFlowCenterHisProcessUtil.class);
    private static SimpleDateFormat STANDARDSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String SYNURL = "/gateway/flowcenter/native/syncByAct?accessToken=";
    private static String DELETEDATAURL = "/gateway/flowcenter/native/deleteDataByFlowInstId?accessToken=";

    public static String initAllFlowCenterMoulds(Context ctx, String startTime) throws Exception {
        ArrayList<HashMap<String, Object>> needInitList = new ArrayList<HashMap<String, Object>>();
        ArrayList hasInitList = new ArrayList();
        String sql = "SELECT D.FBILLBOSTYPE,COUNT(P.FPROCINSTID) FLOWCOUNT,MAX(P.FPROCINSTID) PROCINSTID FROM T_WFR_PROCDEF D,T_WFR_PROCINST P WHERE D.FPROCDEFID = P.FPROCDEFID  AND D.FBILLBOSTYPE IS NOT NULL AND D.FBILLBOSTYPE != 'NOBOSTYPE' ";
        if (!StringUtils.isEmpty((String)startTime)) {
            STANDARDSDF.parse(startTime);
            sql = sql + " AND P.FCREATEDTIME > {TS '" + startTime + "'} ";
        }
        sql = sql + " GROUP BY D.FBILLBOSTYPE ORDER BY FLOWCOUNT DESC ";
        IEnactmentService enactService = EnactmentServiceFactory.createEnactService((Context)ctx);
        IBillDigest digestInstance = BillDigestFactory.getLocalInstance((Context)ctx);
        IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (countRowSet.next()) {
            String bosTypeStr = countRowSet.getString("FBILLBOSTYPE");
            String procinstid = countRowSet.getString("PROCINSTID");
            if (StringUtils.isEmpty((String)bosTypeStr)) continue;
            HashMap<String, Object> initParamMap = new HashMap<String, Object>();
            BOSObjectType bosObjectType = BOSObjectType.create((String)bosTypeStr);
            String bosTypeName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosObjectType).getAlias();
            if (StringUtils.isEmpty((String)bosTypeName)) continue;
            ArrayList field4MouldList = new ArrayList();
            String allFieldsKeysStr = "";
            try {
                List items;
                String billId = enactService.getBizObjIdByProcessInstanceId(procinstid);
                initParamMap.put("billId", billId);
                SummaryProxy summary = digestInstance.getSummaryByUUIDAndDigType(billId, 2, "");
                if (summary != null && (items = summary.getItems()) != null) {
                    for (Object[] objects : items) {
                        String name = (String)objects[0];
                        HashMap<String, String> field = new HashMap<String, String>();
                        field.put("name", name);
                        field4MouldList.add(field);
                        allFieldsKeysStr = allFieldsKeysStr + "|" + name;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("get bill info error:" + e.getMessage()), (Throwable)e);
            }
            String fieldMD5String = MD5Util.getMD5String((String)allFieldsKeysStr);
            String mouldTypeId = YZJFlowCenterMouldHandler.getInstance().getMouldTypeId(ctx, bosTypeStr, fieldMD5String);
            String initOpenId = YZJFlowCenterHisProcessUtil.getInitMouldOpenId(ctx, sql);
            initParamMap.put("bosType", bosTypeStr);
            initParamMap.put("bosTypeName", bosTypeName);
            initParamMap.put("initOpenId", initOpenId);
            initParamMap.put("field4MouldList", field4MouldList);
            if (StringUtils.isEmpty((String)mouldTypeId)) {
                needInitList.add(initParamMap);
                continue;
            }
            hasInitList.add(initParamMap);
        }
        logger.error((Object)("YZJFlowCenterHisProcessUtil has init mould info " + JSON.toJSONString(hasInitList)));
        logger.error((Object)("YZJFlowCenterHisProcessUtil need init mould info " + JSON.toJSONString(needInitList)));
        return YZJFlowCenterHisProcessUtil.initMould(ctx, needInitList);
    }

    private static String initMould(Context ctx, ArrayList<HashMap<String, Object>> needInitList) throws Exception {
        ArrayList<String> successList = new ArrayList<String>();
        for (HashMap<String, Object> paramMap : needInitList) {
            String billId = (String)paramMap.get("billId");
            String bosTypeName = (String)paramMap.get("bosTypeName");
            String initOpenId = (String)paramMap.get("initOpenId");
            ArrayList field4MouldList = (ArrayList)paramMap.get("field4MouldList");
            if (StringUtils.isEmpty((String)initOpenId)) {
                logger.error((Object)("YZJFlowCenterHisProcessUtil \uff1a" + bosTypeName + "\uff0c\u6a21\u677f\u521d\u59cb\u5316\u5931\u8d25\uff0c\u521d\u59cb\u5316\u7528\u6237\u4e3a\u7a7a"));
            }
            try {
                YZJFlowCenterMouldHandler.getInstance().initMould(ctx, billId, initOpenId, field4MouldList);
                successList.add(bosTypeName);
            }
            catch (Exception e) {
                logger.error((Object)("YZJFlowCenterHisProcessUtil \uff1a" + bosTypeName + "\uff0c\u6a21\u677f\u521d\u59cb\u5316\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
        String successStr = JSON.toJSONString(successList);
        logger.error((Object)("\u521d\u59cb\u5316\u6a21\u677f\u6210\u529f\u5355\u636e\uff1a " + successStr));
        return successStr;
    }

    private static String getInitMouldOpenId(Context ctx, String billId) throws BOSException, SQLException {
        String sql = "SELECT top 1 u.fxtid openid FROM t_wfr_assign ass ,t_pm_easxtusermap u where ass.FPERSONUSERID = u.fuserid and u.fxtid is not null and ass.FBIZOBJID = ? order by ass.FCREATEDTIME desc";
        IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        if (countRowSet.next()) {
            return countRowSet.getString("openid");
        }
        sql = "SELECT top 1 u.fxtid openid FROM t_wfr_assign ass ,t_pm_easxtusermap u where ass.FPERSONUSERID = u.fuserid and u.fxtid is not null order by ass.FCREATEDTIME desc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.next()) {
            return rowSet.getString("openid");
        }
        return null;
    }

    public static String syncAllProcInst(Context ctx, String startTime, String endTime) throws Exception {
        long begin = System.currentTimeMillis();
        String qryBaseProcInstSql = "SELECT P.FPROCINSTID,P.FCREATEDTIME,P.FSTATE,U.FNUMBER FROM T_WFR_PROCINST P,T_PM_USER U WHERE P.FINITIATORID = U.FID  AND P.FPARENTPROCINSTID IS NULL AND P.FSTATE IN ('open.running','closed.completed','open.not_running.suspended')  AND NOT EXISTS (SELECT 1 FROM T_ASSIGN_XTMSG M WHERE M.PROCINSTID = P.FPROCINSTID AND M.INFO = 'syn_procinst_done' )  AND NOT EXISTS (SELECT 1 FROM T_ASSIGN_XTMSGHST MH WHERE MH.PROCINSTID = P.FPROCINSTID AND MH.INFO = 'syn_procinst_done' ) ";
        if (StringUtils.isEmpty((String)startTime)) {
            return "\u8bf7\u8f93\u5165\u5f00\u59cb\u65f6\u95f4\uff01";
        }
        STANDARDSDF.parse(startTime);
        qryBaseProcInstSql = qryBaseProcInstSql + " AND P.FCREATEDTIME >= {TS '" + startTime + "'} ";
        if (!StringUtils.isEmpty((String)endTime)) {
            STANDARDSDF.parse(endTime);
            qryBaseProcInstSql = qryBaseProcInstSql + " AND P.FCREATEDTIME < {TS '" + endTime + "'} ";
        }
        qryBaseProcInstSql = qryBaseProcInstSql + " ORDER BY P.FCREATEDTIME DESC ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)qryBaseProcInstSql);
        while (rowSet.next()) {
            String procinstId = rowSet.getString("FPROCINSTID");
            String procinsCreatedTime = rowSet.getString("FCREATEDTIME");
            String procinsCreator = rowSet.getString("FNUMBER");
            String procinsState = "open.running".equals(rowSet.getString("FSTATE")) ? "RUNNING" : "FINISH";
            ArrayList<String> procinstIdList = new ArrayList<String>();
            procinstIdList.add(procinstId);
            ArrayList<String> childProcinstIdList = YZJFlowCenterHisProcessUtil.getAllChildProcinstId(ctx, procinstIdList);
            for (int count = 0; childProcinstIdList.size() > 0 && count < 10; ++count) {
                childProcinstIdList = YZJFlowCenterHisProcessUtil.getAllChildProcinstId(ctx, childProcinstIdList);
                procinstIdList.addAll(childProcinstIdList);
            }
            HashMap<String, ArrayList<String[]>> doneActWithAssignArrMap = YZJFlowCenterHisProcessUtil.getActinstAssign(ctx, procinstIdList, "DONE");
            HashMap<String, ArrayList<String[]>> todoActWithAssignArrMap = YZJFlowCenterHisProcessUtil.getActinstAssign(ctx, procinstIdList, "DOING");
            YZJFlowCenterHisProcessUtil.syncProcinstActinstToYzj(ctx, procinstId, procinsCreator, procinsCreatedTime, procinsState, doneActWithAssignArrMap, "DONE");
            YZJFlowCenterHisProcessUtil.syncProcinstActinstToYzj(ctx, procinstId, procinsCreator, procinsCreatedTime, procinsState, todoActWithAssignArrMap, "DOING");
        }
        long end = System.currentTimeMillis();
        return "done!spend time(s):" + (double)(end - begin) / 1000.0;
    }

    private static void syncProcinstActinstToYzj(Context ctx, String topProcInstId, String procinsCreator, String procinsCreatedTime, String procinsState, Map<String, ArrayList<String[]>> actWithAssignArrMap, String todoFlag) throws Exception {
        Set<String> actWithAssignKeySet = actWithAssignArrMap.keySet();
        for (String actInst : actWithAssignKeySet) {
            long begin = System.currentTimeMillis();
            HashMap<String, Object> mainActInstInfoMap = new HashMap<String, Object>();
            ArrayList<String[]> assignList = actWithAssignArrMap.get(actInst);
            try {
                ArrayList<HashMap<String, Object>> fieldList = YZJFlowCenterHisProcessUtil.getBilldField(ctx, assignList);
                mainActInstInfoMap.put("field", fieldList);
            }
            catch (Exception e) {
                if ("no_found_billid".equals(e.getMessage())) continue;
            }
            mainActInstInfoMap.put("flowId", topProcInstId);
            mainActInstInfoMap.put("creator", procinsCreator);
            mainActInstInfoMap.put("supportJobNo", true);
            mainActInstInfoMap.put("flowStatus", procinsState);
            mainActInstInfoMap.put("flowCreateTime", YZJFlowCenterHisProcessUtil.standardTime2Timestamp(procinsCreatedTime));
            YZJFlowCenterHisProcessUtil.buildActInstInfo(ctx, actInst, assignList, mainActInstInfoMap);
            String todoUrl = null;
            String passUrl = null;
            ArrayList<HashMap<String, Object>> todoList = new ArrayList<HashMap<String, Object>>();
            for (String[] doingAssignInfoArr : assignList) {
                if (todoUrl == null) {
                    todoUrl = YZJFlowCenterHisProcessUtil.getTodoUrl(ctx, doingAssignInfoArr[7], doingAssignInfoArr[9], doingAssignInfoArr[10]);
                }
                if ("DOING".equals(todoFlag) && passUrl == null) {
                    passUrl = YZJFlowCenterHisProcessUtil.getPassUrl(ctx, doingAssignInfoArr[1], doingAssignInfoArr[12]);
                }
                HashMap<String, Object> assignMap = YZJFlowCenterHisProcessUtil.buildTodoInfoMap(ctx, todoFlag, todoUrl, passUrl, doingAssignInfoArr);
                todoList.add(assignMap);
            }
            mainActInstInfoMap.put("todo", todoList);
            mainActInstInfoMap.put("copy", new ArrayList());
            YZJFlowCenterHisProcessUtil.postMainActInstInfo2YZJ(ctx, mainActInstInfoMap, todoFlag);
            long end = System.currentTimeMillis();
            logger.error((Object)("postMainActInst:" + actInst + ",spend time:" + (double)(end - begin) / 1000.0));
        }
    }

    private static String getPassUrl(Context ctx, String assignId, String bizfunction) {
        String passUrl = "";
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(ctx.getAIS());
        String signKey = instance.getPubAcctProperty(eid, "WFMessage", "signKey", "");
        try {
            if (!StringUtils.isEmpty((String)signKey) && "MultiApproveUIFunction".equalsIgnoreCase(bizfunction)) {
                String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
                Map actmap = service.getActivityDefAndActivityInstInfo(assignId);
                ActivityDef def = (ActivityDef)actmap.get("ACTIVITYDEF");
                ExtendedAttributeDef ed = def.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                if (ed == null || StringUtils.isEmpty((String)ed.getValue()) || "view".equalsIgnoreCase(ed.getValue())) {
                    passUrl = host.substring(0, host.lastIndexOf("/page")) + "/auth/batchDealTodo?eid=" + eid;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPassUrl for yunzhijia failed", (Throwable)e);
        }
        return passUrl;
    }

    private static void postMainActInstInfo2YZJ(Context ctx, Map<String, Object> mainActInstInfoMap, String todoFlag) throws Exception {
        JSONObject initObject;
        boolean initSuccess;
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String realeid = instance.getXTInfoProperties().get("realEid");
        String dbEid = instance.getEidByDbCode(ctx.getAIS());
        realeid = StringUtils.isEmpty((String)realeid) ? dbEid : realeid;
        String appid = instance.getPubAcctProperty(dbEid, "WFMessage", "appId", "");
        String teamAccessToken = YZJInvokeUtil.getInstance().getTeamAccessToken(realeid, appid, "");
        String mainActInstInfoStr = JSON.toJSONString(mainActInstInfoMap);
        String url = instance.getXTMcloudUrl() + SYNURL + teamAccessToken;
        logger.error((Object)("postMainActInstInfo2YZJ mainActInstInfoJson :" + mainActInstInfoStr));
        String postResult = HttpClientUtil.doPost(url, mainActInstInfoStr, "UTF-8");
        logger.error((Object)("postMainActInstInfo2YZJ result :" + postResult));
        if (!StringUtils.isEmpty((String)postResult) && (initSuccess = (initObject = JSON.parseObject((String)postResult)).getBoolean("success").booleanValue())) {
            ArrayList syncedTodoList = (ArrayList)mainActInstInfoMap.get("todo");
            YZJFlowCenterHisProcessUtil.saveSyncData(ctx, syncedTodoList, todoFlag);
        }
    }

    private static void saveSyncData(Context ctx, List<HashMap<String, Object>> syncedTodoList, String todoFlag) {
        for (int i = 0; syncedTodoList != null && i < syncedTodoList.size(); ++i) {
            HashMap<String, Object> todoMap = syncedTodoList.get(i);
            String assignid = (String)todoMap.get("bizId");
            String insert = "INSERT INTO T_ASSIGN_XTMSG(MSGID,FASSIGNID,FUSERID,PROCINSTID,PUSHTYPE,FSTATE)  SELECT CONCAT('FC-',FASSIGNID) MSGID,FASSIGNID,FPERSONUSERID,FPROCINSTID,'4' TYPE, ";
            insert = "DONE".equals(todoFlag) ? insert + " null STATE FROM T_WFR_ASSIGNDETAIL WHERE FASSIGNID = ? " : insert + " '1' STATE FROM T_WFR_ASSIGN WHERE FASSIGNID = ? ";
            try {
                DbUtil.execute((Context)ctx, (String)insert, (Object[])new Object[]{assignid});
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("YZJFlowCenterHisProcessUtil saveSyncData error :" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void buildActInstInfo(Context ctx, String actInstId, List<String[]> assignList, Map<String, Object> mainActInstInfoMap) throws Exception {
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(ctx.getAIS());
        String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
        mainActInstInfoMap.put("appId", appId);
        String billid = null;
        String procinstid = null;
        String procinstDefName = null;
        String activityId = null;
        String activityName = null;
        for (String[] assignInfoArr : assignList) {
            if (StringUtils.isEmpty((String)assignInfoArr[10])) continue;
            billid = assignInfoArr[10];
            procinstid = assignInfoArr[11];
            procinstDefName = assignInfoArr[8];
            activityId = assignInfoArr[5];
            activityName = assignInfoArr[6];
            break;
        }
        if (StringUtils.isEmpty(billid)) {
            billid = YZJFlowCenterHisProcessUtil.getBillIdByProcinstid(ctx, procinstid);
        }
        String bosType = BOSUuid.read(billid).getType().toString();
        String typeId = YZJFlowCenterMouldHandler.getInstance().getMouldTypeId(ctx, bosType);
        mainActInstInfoMap.put("typeId", typeId);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        int urgency = YZJFlowCenterHisProcessUtil.getUrgency(actInstId, svc);
        mainActInstInfoMap.put("urgency", urgency);
        mainActInstInfoMap.put("title", procinstDefName);
        mainActInstInfoMap.put("serialNo", YZJFlowCenterHisProcessUtil.gitBilldNumber(ctx, billid));
        mainActInstInfoMap.put("activityId", activityId);
        mainActInstInfoMap.put("activityName", activityName);
        String host = instance.getPubAcctProperty(eid, "WFMessage", "host", "");
        String url = host + "&storeEid=21231&name=approveui.navui&eid=" + eid + "&appid=" + appId + "&cometype=mydoing&fprocinstid=" + procinstid;
        mainActInstInfoMap.put("webFlowLink", url);
        mainActInstInfoMap.put("mobileFlowLink", url + "&webFlowLink=true");
    }

    private static int getUrgency(String actInstId, IEnactmentService svc) {
        int urgency = 1;
        try {
            ActivityInstInfo aii = svc.getActivityInstByActInstId(actInstId);
            ActivityDef ad = svc.getActDefByActInstInfo(aii);
            int pri = ad.getActivityHeader().getpriority();
            if (pri == 1) {
                urgency = 2;
            } else if (pri == 2) {
                urgency = 3;
            } else if (pri > 2) {
                urgency = 4;
            }
        }
        catch (Exception e) {
            logger.error((Object)"calculateUrgency for yzj error!", (Throwable)e);
        }
        return urgency;
    }

    private static String gitBilldNumber(Context ctx, String billId) {
        String number = "";
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("number");
            IObjectValue objectById = BotpHelper.getObjectById((Context)ctx, (String)billId, (SelectorItemCollection)selectors);
            if (objectById != null) {
                number = (String)objectById.get("number");
            } else {
                logger.error((Object)("gitBilldNumber for yzj  getBotpObject null to billd :" + billId));
            }
        }
        catch (Exception e) {
            if ("com.kingdee.bos.dao.ObjectNotFoundException".equals(e.getClass().getName())) {
                logger.error((Object)("gitBilldNumber for yzj error! " + e.getMessage()));
            }
            logger.error((Object)"gitBilldNumber for yzj error!", (Throwable)e);
        }
        return number;
    }

    private static ArrayList<HashMap<String, Object>> getBilldField(Context ctx, ArrayList<String[]> assignList) throws Exception {
        String billid = null;
        String procinstid = null;
        for (String[] assignInfoArr : assignList) {
            if (StringUtils.isEmpty((String)assignInfoArr[10])) continue;
            billid = assignInfoArr[10];
            procinstid = assignInfoArr[11];
            break;
        }
        if (StringUtils.isEmpty(billid)) {
            billid = YZJFlowCenterHisProcessUtil.getBillIdByProcinstid(ctx, procinstid);
        }
        if (StringUtils.isEmpty(billid)) {
            throw new Exception("no_found_billid");
        }
        ArrayList<HashMap<String, Object>> fieldList = new ArrayList<HashMap<String, Object>>();
        String allFieldsKeysStr = "";
        SummaryProxy summary = BillDigestFactory.getLocalInstance((Context)ctx).getSummaryByUUIDAndDigType(billid, 2, "");
        if (summary != null && summary.getItems() != null) {
            List items = summary.getItems();
            for (Object[] objects : items) {
                String name = (String)objects[0];
                Object value = objects[1];
                HashMap<String, Object> field = new HashMap<String, Object>();
                field.put("name", name);
                field.put("value", value);
                allFieldsKeysStr = allFieldsKeysStr + "|" + name;
                fieldList.add(field);
            }
        }
        String bosType = BOSUuid.read((String)billid).getType().toString();
        String fieldMD5String = MD5Util.getMD5String((String)allFieldsKeysStr);
        YZJFlowCenterMouldHandler instance = YZJFlowCenterMouldHandler.getInstance();
        String typeId = instance.getMouldTypeId(ctx, bosType, fieldMD5String);
        if (StringUtils.isEmpty((String)typeId)) {
            String sendOpenId = YZJFlowCenterHisProcessUtil.getInitMouldOpenId(ctx, billid);
            instance.initMould(ctx, billid, sendOpenId, fieldList);
        }
        return fieldList;
    }

    private static HashMap<String, Object> buildTodoInfoMap(Context ctx, String todoFlag, String todoUrl, String passUrl, String[] assignInfoArr) {
        todoUrl = todoUrl + "&assignId=" + assignInfoArr[1];
        HashMap<String, Object> todoMap = new HashMap<String, Object>();
        todoMap.put("approver", assignInfoArr[0]);
        todoMap.put("bizId", assignInfoArr[1]);
        todoMap.put("messageMode", "MODE_MESSAGE");
        todoMap.put("messageContent", assignInfoArr[2]);
        todoMap.put("webLink", todoUrl);
        todoMap.put("mobileLink", todoUrl);
        todoMap.put("status", todoFlag);
        todoMap.put("createTime", YZJFlowCenterHisProcessUtil.standardTime2Timestamp(assignInfoArr[3]));
        if ("DONE".equals(todoFlag)) {
            todoMap.put("dealTime", YZJFlowCenterHisProcessUtil.standardTime2Timestamp(assignInfoArr[4]));
        }
        if ("DOING".equals(todoFlag) && !StringUtils.isEmpty((String)passUrl)) {
            todoMap.put("processUrl", passUrl);
        }
        return todoMap;
    }

    private static String getTodoUrl(Context ctx, String actDefId, String procDefId, String billid) {
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(ctx.getAIS());
        String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
        String url = "";
        try {
            String sql = "SELECT URL FROM T_WFR_MBOS_WORKFLOW WHERE ACTDEFID = ? AND PROCDEFID = ? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{actDefId, procDefId});
            if (rowSet.next()) {
                url = rowSet.getString("URL");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)url)) {
            String host = instance.getPubAcctProperty(eid, "WFMessage", "host", "");
            url = host + "&storeEid=21231&name=approveui.navui&eid=" + eid + "&appid=" + appId;
        } else {
            url = url.replace("page/loadPage", "mbosw/getWorkflowUrl");
            url = url + "&eid=" + eid + "&appid=" + appId + "&billID=" + URLEncoder.encode(billid);
        }
        return url;
    }

    private static long standardTime2Timestamp(String timeStr) {
        if (!StringUtils.isEmpty((String)timeStr)) {
            try {
                return STANDARDSDF.parse(timeStr).getTime();
            }
            catch (ParseException e) {
                logger.error((Object)("YZJFlowCenterHisProcessUtil standardTime2Timestamp error " + e.getMessage()), (Throwable)e);
            }
        }
        return System.currentTimeMillis();
    }

    private static HashMap<String, ArrayList<String[]>> getActinstAssign(Context ctx, ArrayList<String> procinstIdList, String todoFlag) throws BOSException, SQLException {
        String qryAssign = "SELECT A.FASSIGNID,A.FSUBJECT_L2 SUBJECT,A.FPERSONUSERID,A.FACTINSTID,A.FACTDEFNAME_L2 ACTDEFNAME,A.FACTDEFID,A.FPROCDEFNAME_L2 PROCDEFNAME, A.FPROCDEFID,   A.FCREATEDTIME, A.FLASTSTATETIME, A.FBIZOBJID, A.FPROCINSTID, A.FBIZFUNCTION, U.FNUMBER FROM T_WFR_ASSIGN A, T_PM_USER U  WHERE A.FPERSONUSERID = U.FID AND NOT EXISTS (SELECT 1 FROM T_ASSIGN_XTMSG M WHERE M.FASSIGNID = A.FASSIGNID ) AND NOT EXISTS (SELECT 1 FROM T_ASSIGN_XTMSGHST MH WHERE MH.FASSIGNID = A.FASSIGNID )  AND A.FPROCINSTID IN ( ";
        for (int i = 0; i < procinstIdList.size(); ++i) {
            qryAssign = qryAssign + "?,";
        }
        qryAssign = qryAssign.substring(0, qryAssign.length() - 1);
        qryAssign = qryAssign + " ) ORDER BY FCREATEDTIME ";
        if ("DONE".equals(todoFlag)) {
            qryAssign = qryAssign.replace("T_WFR_ASSIGN", "T_WFR_ASSIGNDETAIL");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)qryAssign, (Object[])procinstIdList.toArray());
        ArrayList<Object> assignList = null;
        HashMap<String, ArrayList<String[]>> actWithAssignArrMap = new HashMap<String, ArrayList<String[]>>();
        while (rowSet.next()) {
            String acinstId = rowSet.getString("FACTINSTID");
            if (actWithAssignArrMap.containsKey(acinstId)) {
                assignList = actWithAssignArrMap.get(acinstId);
            } else {
                assignList = new ArrayList();
                actWithAssignArrMap.put(acinstId, assignList);
            }
            String[] assignInfoArr = new String[]{rowSet.getString("FNUMBER"), rowSet.getString("FASSIGNID"), rowSet.getString("SUBJECT"), rowSet.getString("FCREATEDTIME"), rowSet.getString("FLASTSTATETIME"), acinstId, rowSet.getString("ACTDEFNAME"), rowSet.getString("FACTDEFID"), rowSet.getString("PROCDEFNAME"), rowSet.getString("FPROCDEFID"), rowSet.getString("FBIZOBJID"), rowSet.getString("FPROCINSTID"), rowSet.getString("FBIZFUNCTION")};
            assignList.add(assignInfoArr);
        }
        return actWithAssignArrMap;
    }

    private static String getBillIdByProcinstid(Context ctx, String procinstid) {
        String qryBillIdSql = "SELECT FREFID FROM T_WFR_PROCINSTREF WHERE FPROCINSTID = ?  AND FTYPE = '1'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)qryBillIdSql, (Object[])new Object[]{procinstid});
            if (rowSet.next()) {
                return rowSet.getString("FREFID");
            }
        }
        catch (Exception e) {
            logger.error((Object)("YZJFlowCenterHisProcessUtil getBillIdByProcinstid error " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private static ArrayList<String> getAllChildProcinstId(Context ctx, List<String> procinstIdList) throws BOSException, SQLException {
        ArrayList<String> allChildProcinstIdList = new ArrayList<String>();
        if (procinstIdList.size() == 0) {
            return allChildProcinstIdList;
        }
        String qryChildProcInstSql = "SELECT FPROCINSTID FROM T_WFR_PROCINST where FPARENTPROCINSTID IN (";
        for (int i = 0; i < procinstIdList.size(); ++i) {
            qryChildProcInstSql = qryChildProcInstSql + "?,";
        }
        qryChildProcInstSql = qryChildProcInstSql.substring(0, qryChildProcInstSql.length() - 1);
        qryChildProcInstSql = qryChildProcInstSql + ") order by FCREATEDTIME ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)qryChildProcInstSql, (Object[])procinstIdList.toArray());
        while (rowSet.next()) {
            allChildProcinstIdList.add(rowSet.getString("FPROCINSTID"));
        }
        return allChildProcinstIdList;
    }

    public static String deleteProcInst(Context ctx, String procinstId) throws Exception {
        JSONObject initObject;
        boolean initSuccess;
        ArrayList<String> procInstList = new ArrayList<String>();
        procInstList.add(procinstId);
        String parentProcInstId = YZJFlowCenterHisProcessUtil.qryParentProcInstId(ctx, procinstId);
        for (int count = 0; !StringUtils.isEmpty((String)parentProcInstId) && count < 10; ++count) {
            procInstList.add(parentProcInstId);
            procinstId = parentProcInstId;
            parentProcInstId = YZJFlowCenterHisProcessUtil.qryParentProcInstId(ctx, procinstId);
        }
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(ctx.getAIS());
        String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
        HashMap<String, String> dealMap = new HashMap<String, String>();
        dealMap.put("flowId", procinstId);
        dealMap.put("appId", appId);
        String realeid = instance.getXTInfoProperties().get("realEid");
        realeid = StringUtils.isEmpty((String)realeid) ? eid : realeid;
        String teamAccessToken = YZJInvokeUtil.getInstance().getTeamAccessToken(realeid, appId, "");
        String dealMapStr = JSON.toJSONString(dealMap);
        String url = instance.getXTMcloudUrl() + DELETEDATAURL + teamAccessToken;
        logger.error((Object)("postMainActInstInfoMap2YZJ deleteProcInst dealMapStr :" + dealMapStr));
        String postResult = HttpClientUtil.doPost(url, dealMapStr, "UTF-8");
        logger.error((Object)("postMainActInstInfoMap2YZJ deleteProcInst result :" + postResult));
        if (!StringUtils.isEmpty((String)postResult) && (initSuccess = (initObject = JSON.parseObject((String)postResult)).getBoolean("success").booleanValue())) {
            String del = "DELETE FROM T_ASSIGN_XTMSG WHERE PROCINSTID IN (";
            for (int i = 0; i < procInstList.size(); ++i) {
                del = del + "?,";
            }
            del = del.substring(0, del.length() - 1) + ") ";
            DbUtil.execute((Context)ctx, (String)del);
        }
        return "done!";
    }

    private static String qryParentProcInstId(Context ctx, String procinstId) {
        String qrySql = "SELECT FPARENTACTINSTID FROM T_WFR_PROCINST WHERE FPROCINSTID = ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)qrySql, (Object[])new Object[]{procinstId});
            if (rowSet.next()) {
                return rowSet.getString("FREFID");
            }
        }
        catch (Exception e) {
            logger.error((Object)("YZJFlowCenterHisProcessUtil getBillIdByProcinstid error " + e.getMessage()), (Throwable)e);
        }
        return "";
    }
}

