/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.wx;

import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessTokenCache {
    private static Map accessTokenMap = new HashMap();
    private static Object lock = new Object();
    private static Logger logger = Logger.getLogger(AccessTokenCache.class);

    public static String getAccessToken(String agentid) throws Exception {
        return AccessTokenCache.getAccessToken(agentid, null);
    }

    public static String getAccessToken(String agentid, String state) throws Exception {
        long passTime;
        long valideTime;
        long curTime = System.currentTimeMillis();
        AccessTokenInfo accessTokenInfo = null;
        if (accessTokenMap.get(agentid) != null && !StringUtils.isEmpty((String)(accessTokenInfo = (AccessTokenInfo)accessTokenMap.get(agentid)).accessToken) && (valideTime = curTime - (passTime = curTime - accessTokenInfo.accessTokenTime)) > 6600000L) {
            accessTokenInfo = null;
        }
        if (accessTokenInfo != null) {
            return accessTokenInfo.accessToken;
        }
        return AccessTokenCache.innerGet(agentid, state);
    }

    public static String refreshAccessToken(String agentid) throws Exception {
        return AccessTokenCache.innerGet(agentid, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String innerGet(String agentid, String state) throws Exception {
        AccessTokenInfo accessTokenInfo = null;
        Object object = lock;
        synchronized (object) {
            long passTime;
            long curTime;
            long valideTime;
            if (accessTokenMap.get(agentid) != null && !StringUtils.isEmpty((String)(accessTokenInfo = (AccessTokenInfo)accessTokenMap.get(agentid)).accessToken) && (valideTime = (curTime = System.currentTimeMillis()) - (passTime = curTime - accessTokenInfo.accessTokenTime)) > 6600000L) {
                accessTokenInfo = null;
            }
            if (accessTokenInfo != null) {
                return accessTokenInfo.accessToken;
            }
            accessTokenInfo = AccessTokenCache.innerGet0(agentid, state);
            return accessTokenInfo.accessToken;
        }
    }

    private static AccessTokenInfo innerGet0(String agentid, String state) throws Exception {
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        String accessTokenUrl = WXUtil.getWXHost() + "/cgi-bin/gettoken";
        try {
            String corpsecret;
            String[] configs = WXUtil.getWXConfig();
            String corpid = configs[0];
            if (!StringUtils.isEmpty((String)state)) {
                corpid = state;
            }
            if (StringUtils.isEmpty((String)(corpsecret = XTServiceConfig.getInstance().getWXSecret(agentid)))) {
                corpsecret = configs[1];
            }
            String url = accessTokenUrl + "?corpid=" + URLEncoder.encode(corpid, "UTF-8") + "&corpsecret=" + URLEncoder.encode(corpsecret, "UTF-8");
            System.out.println("accessToken get  url=" + url);
            logger.error((Object)("accessToken get  url=" + url));
            String result = WXUtil.getResponse(url);
            System.out.println("result=" + result);
            JSONObject jb = new JSONObject(result);
            if (jb.isNull("access_token")) {
                logger.error((Object)("accessToken get error ,result:" + result));
                throw new WorkflowException(WorkflowErrorEnums.CONNET_WXTOKENURL_RESPONSEERROR, url, null);
            }
            String access_token = jb.getString("access_token");
            accessTokenInfo.accessToken = access_token;
            accessTokenInfo.accessTokenTime = System.currentTimeMillis();
            accessTokenMap.put(agentid, accessTokenInfo);
        }
        catch (WorkflowException e) {
            logger.error((Object)("accessToken get error ,url:" + accessTokenUrl), (Throwable)e);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("accessToken get error ,url:" + accessTokenUrl), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_WXPARAMSENCODING, accessTokenUrl, e.getMessage());
        }
        catch (HttpException e) {
            logger.error((Object)("accessToken get error ,url:" + accessTokenUrl), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_WXTOKENURL_HTTPEXCEPTION, accessTokenUrl, e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)("accessToken get error ,url:" + accessTokenUrl), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_WXTOKENURL_IOEXCEPTION, accessTokenUrl, e.getMessage());
        }
        catch (JSONException e) {
            logger.error((Object)("accessToken get error ,url:" + accessTokenUrl), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_WXTOKENURL_JSONEXCEPTION, accessTokenUrl, null);
        }
        catch (Exception e) {
            logger.error((Object)("accessToken get error ,url:" + accessTokenUrl), (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONNET_WXTOKENURL_FAILED, accessTokenUrl, null);
        }
        return accessTokenInfo;
    }

    private static class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 0L;

        private AccessTokenInfo() {
        }
    }
}

