/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.wx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.json.JSONObject;
import com.kingdee.lightapp.wx.HttpKit;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WXMessagePusher
implements IMessagePusher {
    private static Logger logger = Logger.getLogger(WXMessagePusher.class);
    private String messageType;

    public WXMessagePusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> list) {
        String wxurl = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String assignid = "";
        String userid = "";
        for (IMessageAdapter adapter : list) {
            Map<String, Object> content = adapter.getContent();
            assignid = (String)content.get("assignId");
            userid = (String)adapter.getContent().get("receiver");
        }
        try {
            String[] wxConfig = WXUtil.getWXConfig();
            wxurl = WXUtil.getSendMessageUrl(wxConfig[2]);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25", (Throwable)e);
            returnMap.put("assignId", assignid);
            returnMap.put("errorCode", "0");
            returnMap.put("errormsg", "getSendMessageUr:" + e.getMessage());
            return returnMap;
        }
        Iterator<IMessageAdapter> iter = list.iterator();
        while (iter.hasNext()) {
            String wxMsgJson = WXMessagePusher.createMsg(ctx, iter);
            if (StringUtils.isEmpty((CharSequence)wxMsgJson)) {
                logger.info((Object)("WXMessagePusher assign not fit wxuser ==" + assignid));
                returnMap.put("success", "true");
                continue;
            }
            returnMap.put("assignId", assignid);
            try {
                String re = HttpClientUtil.doPost(wxurl, wxMsgJson, "UTF-8");
                logger.error((Object)("WXMessagePusher pushMessage re:" + re));
                JSONObject jb = new JSONObject(re);
                int errorcode = (Integer)jb.get("errcode");
                if (errorcode == 0) {
                    returnMap.put("sourceMsgId", assignid);
                    returnMap.put("success", "true");
                    continue;
                }
                returnMap.put("errorCode", String.valueOf(errorcode));
                returnMap.put("errormsg", String.valueOf(jb.get("errmsg")));
            }
            catch (Exception e) {
                returnMap.put("errorCode", "1");
                returnMap.put("errormsg", e.getMessage());
                logger.error((Object)e);
            }
        }
        this.savePushedMsg(ctx, assignid, userid, returnMap);
        return null;
    }

    private void savePushedMsg(Context ctx, String assignid, String userid, Map map) {
        try {
            String success = "";
            if (map.get("success") != null) {
                success = String.valueOf(map.get("success"));
            }
            String msg = (String)map.get("remessage");
            String msgId = (String)map.get("sourceMsgId");
            if (!StringUtils.isEmpty((CharSequence)msgId) && !"".equals(assignid) && "true".equals(success)) {
                String sql = " insert into t_assign_wxmsg(msgid,fassignid,fuserid) values(?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{msgId, assignid, userid});
            } else if (!"true".equals(success) && !"".equals(assignid)) {
                String errorcode = "";
                if (map.get("errorCode") != null) {
                    errorcode = String.valueOf(map.get("errorCode"));
                }
                if (StringUtils.isEmpty((CharSequence)msg)) {
                    msg = (String)map.get("errormsg");
                }
                String sql = " insert into t_assign_wxmsgerror(msgid,fassignid,fuserid,errorcode,errormsg,sendtime) values(?,?,?,?,?,getdate())";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{assignid, assignid, userid, errorcode, msg});
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void pushTest() {
        String wxurl = null;
        try {
            wxurl = WXUtil.getSendMessageUrl("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String wxMsgJson = WXMessagePusher.createTestMsg();
        WXMessagePusher.pushMessage(wxMsgJson, wxurl);
    }

    private static boolean pushMessage(String wxMsgJson, String wxurl) {
        HttpKit h = new HttpKit();
        HttpClient http = new HttpClient();
        Object post = null;
        try {
            String re = HttpKit.post(wxurl, wxMsgJson);
            System.out.println("11111111111111111re:" + re);
            JSONObject jb = new JSONObject(re);
            int errorcode = (Integer)jb.get("errcode");
            if (errorcode == 0) {
                return true;
            }
            logger.error((Object)("sendMessage error, errcode=" + errorcode + ",errmsg=" + jb.get("errmsg")));
            return false;
        }
        catch (Exception t) {
            t.printStackTrace();
            return false;
        }
    }

    private static String createTestMsg() {
        String[] config = WXUtil.getWXConfig();
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("touser", "wei_bu@kingdee.com");
        msgMap.put("msgtype", "text");
        msgMap.put("agentid", config[2]);
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("content", "test text message");
        msgMap.put("text", textMap);
        JSONObject json = new JSONObject(msgMap);
        return json.toString();
    }

    private static String createMsg(Context ctx, Iterator iter) {
        String wxtitle;
        IMessageAdapter adapter = (IMessageAdapter)iter.next();
        String title = "\u60a8\u6709\u5f85\u5ba1\u6279\u6d41\u7a0b";
        List<String> personIds = adapter.getUsers();
        String name = (String)adapter.getContent().get("title");
        List<String> wxids = WXMessagePusher.transferPersonIdToWxId(ctx, personIds);
        String[] config = WXUtil.getWXConfig();
        String touser = "";
        for (int i = 0; i < wxids.size(); ++i) {
            if (i > 0) {
                touser = touser + "|";
            }
            touser = touser + wxids.get(i);
        }
        if (StringUtils.isEmpty((CharSequence)touser)) {
            return null;
        }
        HashMap map = (HashMap)adapter.getContent();
        String text = (String)map.get("text");
        MessageTypeEnum a = adapter.getType();
        String description = null;
        int t = a.value();
        description = text;
        if (!StringUtils.isEmpty((CharSequence)name)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + name;
        }
        if (!StringUtils.isEmpty((CharSequence)(wxtitle = (String)map.get("wxtitle")))) {
            title = wxtitle;
        }
        if (t == 2) {
            HashMap<String, Object> msgMap = new HashMap<String, Object>();
            msgMap.put("touser", touser);
            msgMap.put("agentid", config[2]);
            HashMap newsMap = new HashMap(1);
            HashMap<String, String> articleMap = new HashMap<String, String>();
            articleMap.put("content", description);
            msgMap.put("text", articleMap);
            msgMap.put("msgtype", "text");
            JSONObject json = new JSONObject(msgMap);
            return json.toString();
        }
        String url = WXMessagePusher.bindUrlTurnToProxyUrl(ctx, (String)map.get("url"));
        url = WXUtil.encodeWXGetCodeUrl(url);
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("msgtype", "news");
        msgMap.put("touser", touser);
        msgMap.put("agentid", config[2]);
        HashMap<String, Object> articleMap = new HashMap<String, Object>();
        articleMap.put("title", title);
        articleMap.put("description", description);
        articleMap.put("url", url);
        Object WXMsgType = map.get("WXMsgType");
        if ("taskcard".equals(WXMsgType)) {
            ArrayList btnList = new ArrayList();
            HashMap<String, Object> btn1 = new HashMap<String, Object>();
            btn1.put("key", "1");
            btn1.put("name", "\u540c\u610f");
            btn1.put("replace_name", "\u5df2\u5ba1\u6279");
            btn1.put("is_bold", true);
            HashMap<String, String> btn2 = new HashMap<String, String>();
            btn2.put("key", "0");
            btn2.put("name", "\u62d2\u7edd");
            btn2.put("replace_name", "\u5df2\u5ba1\u6279");
            btnList.add(btn1);
            btnList.add(btn2);
            msgMap.put("msgtype", "taskcard");
            msgMap.put("taskcard", articleMap);
            articleMap.put("task_id", map.get("assignId"));
            articleMap.put("btn", btnList);
        } else {
            HashMap newsMap = new HashMap(1);
            ArrayList<HashMap<String, Object>> articlesList = new ArrayList<HashMap<String, Object>>(1);
            articlesList.add(articleMap);
            newsMap.put("articles", articlesList);
            msgMap.put("news", newsMap);
        }
        JSONObject json = new JSONObject(msgMap);
        return json.toString();
    }

    private static String bindUrlTurnToProxyUrl(Context ctx, String url) {
        try {
            if (url.contains("mbosw/getWorkflowUrl")) {
                String eid = XTServiceConfig.getInstance().getEidByDbCode(ctx.getAIS());
                String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
                String easHost = host.replaceAll("/mbos/page/loadPage\\S*", "");
                String mainPage = url.replaceAll("^http\\S*/getWorkflowUrl", "/mbos/mbosw/getWorkflowUrl");
                url = easHost + mainPage;
            }
        }
        catch (Exception e) {
            logger.error((Object)("bindUrlTurnToProxyUrl error " + e.getMessage()), (Throwable)e);
        }
        return url;
    }

    private static List<String> transferPersonIdToWxId(Context ctx, List<String> personIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        String ids = "";
        int index = 0;
        Iterator<String> iter = personIdList.iterator();
        while (iter.hasNext()) {
            if (index++ > 0) {
                ids = ids + ",";
            }
            String personId = iter.next();
            ids = ids + "'" + personId + "'";
        }
        String sql = "select FXtId from T_PM_easwxusermap where fuserid in (" + ids + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String xtid = rs.getString("FXtId");
                if (xtid == null || xtIdList.contains(xtid)) continue;
                xtIdList.add(xtid);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return xtIdList;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        this.pushMessage(ctx, messageList);
        return null;
    }
}

