/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt;

import com.kingdee.bos.Context;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.lightapp.xt.UserNotFoundException;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.lightapp.xt.util.LoginHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightAppServiceFacade {
    private static final Logger logger = LoggerFactory.getLogger(LightAppServiceFacade.class);

    public static Context loginEAS(HttpServletRequest request, XtParamsDTO xtparamsDto) throws Exception {
        Context ctx = null;
        if (xtparamsDto == null) {
            logger.error("LightAppServiceFacade == getEasContext== xtparamsDto is Empty!!!");
            throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_NOXTPARAMSDTO);
        }
        try {
            HttpSession session = request.getSession();
            String openId = (String)session.getAttribute("openid");
            ctx = LoginHelper.loginByXtId(request, xtparamsDto);
            request.getSession().setAttribute("XTContext", (Object)ctx);
            request.getSession().setAttribute("openid", (Object)xtparamsDto.getOpenid());
            request.getSession().setAttribute("sessionTime", (Object)System.currentTimeMillis());
            request.getSession().setAttribute("eid", (Object)xtparamsDto.getEid());
        }
        catch (UserNotFoundException e) {
            boolean isFromXT = true;
            HttpSession session = request.getSession();
            if (session.getAttribute("isWX") != null && session.getAttribute("isWX").toString().equalsIgnoreCase("true")) {
                isFromXT = false;
            }
            if (!isFromXT) {
                ctx = WXUtil.doAutoBind(request, xtparamsDto, request.getParameter("code"), request.getParameter("state"));
            }
            throw new UserNotFoundException();
        }
        return ctx;
    }
}

