/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class XTServiceConfig {
    private static Logger logger = Logger.getLogger(XTServiceConfig.class);
    private static final String CONFIGFILE = "XTServiceConfig.xml";
    private static final String CONFIGITEM_XTINFO = "XTInfo";
    private static final String CONFIGITEM_DBINFO = "DbInfo";
    private static final String CONFIGITEM_PUBACCT = "PubAcct";
    public static final String CONFIGITEM_YZJ = "YZJ";
    public static final String CONFIGITEM_WX = "WX";
    public static final String CONFIGITEM_DINGTALK = "Dingtalk";
    public static final String CONFIGITEM_WELINK = "WeLink";
    private static final String CONFIGITEM_MULTIAPP = "MultiApp";
    private static final String CONFIGITEM_KCCAPI = "KccAPI";
    private static final String CONFIGITEM_KCCLIGHT = "KccLight";
    protected static XTServiceConfig instance = new XTServiceConfig();
    private static XMLConfiguration configuration;
    private static Object lock;
    private static String xtMcloudUrl;
    private static String kdweiboUrl;
    private static String xtPushServerUrl;
    private static String xtNewPushServerUrl;
    private static String reloadMode;
    long lastModified = 0L;

    protected XTServiceConfig() {
        this.load();
    }

    public static XTServiceConfig getInstance() {
        return instance;
    }

    public XMLConfiguration getConfiguration() {
        this.reload();
        return configuration;
    }

    public ConfigurationItem getConfigurationItem(String configKey) {
        this.reload();
        return configuration.getConfigItem(configKey);
    }

    public ConfigurationItem getConfigurationItemByPath(String configPath) {
        this.reload();
        return configuration.getConfigItemByPath(configPath);
    }

    public Map<String, String> getXTInfoProperties() {
        this.reload();
        try {
            return this.getConfigurationItemByPath(CONFIGITEM_XTINFO).getProperties();
        }
        catch (Exception e) {
            logger.info((Object)"cann't find the properties:XTInfo");
            throw new RuntimeException("cann't find the properties:XTInfo");
        }
    }

    public String getContentType() {
        return this.getXTInfoProperties().get("xt.pubacct.connect.content.type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXTServerUrl() {
        if (!StringUtils.isEmpty((String)xtPushServerUrl)) {
            return xtPushServerUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtPushServerUrl)) {
                return xtPushServerUrl;
            }
            xtPushServerUrl = this.getXTInfoProperties().get("xt.pubacct.connect.server.url");
            if (StringUtils.isEmpty((String)xtPushServerUrl)) {
                xtPushServerUrl = xtMcloudUrl + "/pubacc/pubsend";
            }
        }
        return xtPushServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewXTServerUrl() {
        if (!StringUtils.isEmpty((String)xtNewPushServerUrl)) {
            return xtNewPushServerUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtNewPushServerUrl)) {
                return xtNewPushServerUrl;
            }
            xtNewPushServerUrl = this.getXTInfoProperties().get("newxt.pubacct.connect.server.url");
            if (StringUtils.isEmpty((String)xtNewPushServerUrl)) {
                xtNewPushServerUrl = xtMcloudUrl + "/gateway/newtodo/open";
            }
        }
        return xtNewPushServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXTMcloudUrl() {
        if (!StringUtils.isEmpty((String)xtMcloudUrl)) {
            return xtMcloudUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)xtMcloudUrl)) {
                return xtMcloudUrl;
            }
            xtMcloudUrl = this.getXTInfoProperties().get("xt.mcloud.url");
            if (StringUtils.isEmpty((String)xtMcloudUrl)) {
                xtMcloudUrl = "http://www.yunzhijia.com";
            }
        }
        return xtMcloudUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKdWeiboUrl() {
        if (!StringUtils.isEmpty((String)kdweiboUrl)) {
            return kdweiboUrl;
        }
        Object object = lock;
        synchronized (object) {
            if (!StringUtils.isEmpty((String)kdweiboUrl)) {
                return kdweiboUrl;
            }
            kdweiboUrl = this.getXTInfoProperties().get("xt.kdweibo.url");
            if (StringUtils.isEmpty((String)kdweiboUrl)) {
                kdweiboUrl = "http://www.yunzhijia.com";
            }
        }
        return kdweiboUrl;
    }

    public String getEidByDbCode(String dbCode) {
        this.reload();
        String eid = null;
        try {
            ConfigurationItem ct = this.getConfigurationItemByPath(CONFIGITEM_DBINFO);
            List cl = ct.getAllChildren();
            for (int i = 0; i < cl.size(); ++i) {
                ConfigurationItem item = (ConfigurationItem)cl.get(i);
                if (!dbCode.equals(item.getProperty("dbCode"))) continue;
                eid = item.getName();
                break;
            }
        }
        catch (Exception e) {
            logger.info((Object)"cann't find the properties:DbMap");
            throw new RuntimeException("cann't find the properties:DbMap");
        }
        return eid;
    }

    public Map<String, String> getDbInfoProperties(String eid) {
        this.reload();
        try {
            return this.getConfigurationItemByPath("DbInfo/" + eid).getProperties();
        }
        catch (Exception e) {
            logger.info((Object)"cann't find the properties:XTInfo");
            throw new RuntimeException("cann't find the properties:XTInfo");
        }
    }

    public String getDbInfoProperty(String eid, String key, String defaultValue) {
        this.reload();
        return this.getConfigurationItemByPath("DbInfo/" + eid).getProperty(key, defaultValue);
    }

    public int getDbType(String eid) {
        return Integer.parseInt(this.getDbInfoProperties(eid).get("dbType"));
    }

    public String getDbCode(String eid) {
        return this.getDbInfoProperties(eid).get("dbCode");
    }

    public String getSlnName(String eid) {
        return this.getDbInfoProperties(eid).get("slnName");
    }

    public String getLocale(String eid) {
        return this.getDbInfoProperties(eid).get("locale");
    }

    private ConfigurationItem getPubAcctProperties(String eid, String pubAcctName) {
        logger.info((Object)("getPubAcctProperties==pubAcctName" + pubAcctName));
        logger.info((Object)("getPubAcctProperties==eid" + eid));
        return this.getConfigurationItemByPath("PubAcct/" + eid + "/" + pubAcctName);
    }

    public String getPubAcctProperty(String eid, String pubAcctName, String key, String defaultValue) {
        logger.info((Object)("getPubAcctProperty==eid" + eid));
        logger.info((Object)("getPubAcctProperty==pubAcctName" + pubAcctName));
        logger.info((Object)("getPubAcctProperty==key" + key));
        return this.getPubAcctProperties(eid, pubAcctName).getProperty(key, defaultValue);
    }

    public String getPubCode(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("code");
    }

    public String getPubKey(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("pubKey");
    }

    public boolean getPubEnabled(String eid, String pubAcctName) {
        return Boolean.parseBoolean(this.getPubAcctProperties(eid, pubAcctName).getProperty("enabled"));
    }

    public String getPubTempFileDir(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("xt.pubacct.local.server.dir");
    }

    public String getPubClean(String eid, String pubAcctName) {
        return this.getPubAcctProperties(eid, pubAcctName).getProperty("clean");
    }

    public String getPubkeyBypubaccid(String eid, String pubaccid) {
        String pubKey = null;
        logger.info((Object)("getPubkeyBypubaccid==eid" + eid));
        ConfigurationItem ct = this.getConfigurationItemByPath("PubAcct/" + eid);
        if (ct != null) {
            List cl = ct.getAllChildren();
            for (int i = 0; i < cl.size(); ++i) {
                ConfigurationItem item = (ConfigurationItem)cl.get(i);
                if (!pubaccid.equals(item.getProperty("code"))) continue;
                pubKey = item.getProperty("pubKey");
                break;
            }
        } else {
            logger.error((Object)("XTServiceConfig getPubkeyBypubaccid error:can not get pubKey of " + eid));
        }
        return pubKey;
    }

    public String getAppSecret(String appId) {
        return this.getConfigurationItemByPath("AppSecret").getProperty(appId);
    }

    public String getWXSecret(String appId) {
        ConfigurationItem item = this.getConfigurationItemByPath("WXSecret");
        String secret = "";
        secret = item != null ? this.getConfigurationItemByPath("WXSecret").getProperty(appId) : this.getConfigurationItemByPath("AppSecret").getProperty(appId);
        return secret;
    }

    public String getOtherAppUrl(String type) {
        return this.getConfigurationItemByPath("OtherApp").getProperty(type);
    }

    public boolean checkIsDingtalkApp() {
        ConfigurationItem configurationItem = this.getConfigurationItem(CONFIGITEM_DINGTALK);
        return configurationItem != null;
    }

    public String getDingtalkCorpId() {
        return this.getConfigurationItemByPath(CONFIGITEM_DINGTALK).getProperty("CorpId");
    }

    public String getDingtalkApiType() {
        try {
            return this.getConfigurationItemByPath(CONFIGITEM_DINGTALK).getProperty("ApiType");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDingtalkProperty(String configName) {
        return this.getConfigurationItemByPath(CONFIGITEM_DINGTALK).getProperty(configName);
    }

    public String getDingtalkAppAgentId(String eid) {
        Map properties = this.getConfigurationItemByPath("Dingtalk/" + eid).getProperties();
        return (String)properties.get("AgentId");
    }

    public String getDingtalkAppKey(String eid) {
        Map properties = this.getConfigurationItemByPath("Dingtalk/" + eid).getProperties();
        return (String)properties.get("AppKey");
    }

    public String getDingtalkAppSecret(String eid) {
        Map properties = this.getConfigurationItemByPath("Dingtalk/" + eid).getProperties();
        return (String)properties.get("AppSecret");
    }

    public boolean checkIsWeLink() {
        ConfigurationItem configurationItem = this.getConfigurationItem(CONFIGITEM_WELINK);
        return configurationItem != null;
    }

    public String getWeLinkCorpId() {
        return this.getConfigurationItemByPath(CONFIGITEM_WELINK).getProperty("CorpId");
    }

    public String getWeLinkHost() {
        String host = this.getConfigurationItemByPath(CONFIGITEM_WELINK).getProperty("WlHost");
        if (StringUtils.isEmpty((String)host)) {
            host = "https://open.welink.huaweicloud.com";
        }
        return host;
    }

    public String getWeLinkConfig(String configName) {
        return this.getConfigurationItemByPath(CONFIGITEM_WELINK).getProperty(configName);
    }

    public String getWeLinkClientId(String corpId) {
        Map properties = this.getConfigurationItemByPath("WeLink/" + corpId).getProperties();
        return (String)properties.get("client_id");
    }

    public String getWeLinkCorpConfig(String corpId, String config) {
        Map properties = this.getConfigurationItemByPath("WeLink/" + corpId).getProperties();
        return (String)properties.get(config);
    }

    public boolean checkIsMultiApp() {
        ConfigurationItem configurationItem = this.getConfigurationItem(CONFIGITEM_MULTIAPP);
        return configurationItem != null;
    }

    public List<String> getMultiAppConfNamesListByEid(String eid) {
        List list = this.getConfigurationItemByPath("MultiApp/" + eid).getAllChildren();
        ArrayList<String> multiApp = new ArrayList<String>();
        for (ConfigurationItem Item : list) {
            multiApp.add(Item.getName());
        }
        return multiApp;
    }

    public Map<String, String> getMultiAppConfProperties(String eid, String appName) {
        ConfigurationItem configItem = this.getConfigurationItemByPath("MultiApp/" + eid + "/" + appName);
        Map properties = configItem.getProperties();
        return properties;
    }

    public String getKccLightConfig(String eid, String proName) {
        ConfigurationItem confItem = this.getConfigurationItemByPath("KccLight/" + eid);
        return confItem.getProperty(proName);
    }

    public String getKccAPIConfig(String proName) {
        ConfigurationItem confItem = this.getConfigurationItemByPath(CONFIGITEM_KCCAPI);
        return confItem.getProperty(proName);
    }

    private void load() {
        System.out.println("-------------------reload XTServiceConfig XML");
        String propertiesPath = System.getProperty("eas.properties.dir");
        String fileName = propertiesPath + File.separator + CONFIGFILE;
        File configFile = new File(fileName);
        if (configFile.lastModified() == this.lastModified) {
            return;
        }
        this.lastModified = configFile.lastModified();
        if (!configFile.exists()) {
            throw new RuntimeException("cann't find the config file!");
        }
        configuration = XMLConfiguration.getInstance((File)configFile);
        this.loadMode();
    }

    private void loadMode() {
        String mode = this.getConfigurationItemByPath("ReadMode").getProperty("reload");
        if (!StringUtils.isEmpty((String)mode)) {
            reloadMode = mode;
        }
    }

    protected void reload() {
        if ("true".equals(reloadMode)) {
            // empty if block
        }
    }

    static {
        lock = new Object();
        xtMcloudUrl = null;
        kdweiboUrl = null;
        xtPushServerUrl = null;
        xtNewPushServerUrl = null;
    }
}

